/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.events;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.axis.AAxis;
import info.monitorenter.gui.chart.events.AChart2DAction;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Chart2DActionSetAxis
extends AChart2DAction {
    private static final long serialVersionUID = 2385589123139195036L;
    private final int m_axisTarget;
    private final transient AAxis<?> m_axis;

    public Chart2DActionSetAxis(Chart2D chart2D, AAxis<?> aAxis, String string, int n) throws IllegalArgumentException {
        super(chart2D, string);
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException("Argument axisTarget is invalid, choose one of Chart2D.X, Chart2D.Y.");
        }
        this.m_axisTarget = n;
        this.m_axis = aAxis;
        chart2D.addPropertyChangeListener("Chart2D.PROPERTY_AXIS_X", this);
        chart2D.addPropertyChangeListener("Chart2D.PROPERTY_AXIS_Y", this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        switch (this.m_axisTarget) {
            case 1: {
                this.m_chart.setAxisXBottom(this.m_axis, 0);
                break;
            }
            case 2: {
                this.m_chart.setAxisYLeft(this.m_axis, 0);
                break;
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("Chart2D.PROPERTY_AXIS_X") && this.m_axisTarget == 1) {
            if (propertyChangeEvent.getNewValue() != null) {
                Class<?> clazz = propertyChangeEvent.getNewValue().getClass();
                if (this.m_axis.getClass() == clazz) {
                    this.firePropertyChange("", new Boolean(false), new Boolean(true));
                } else {
                    this.firePropertyChange("", new Boolean(true), new Boolean(false));
                }
            }
        } else if (propertyChangeEvent.getPropertyName().equals("Chart2D.PROPERTY_AXIS_Y") && this.m_axisTarget == 2 && propertyChangeEvent.getNewValue() != null) {
            Class<?> clazz = propertyChangeEvent.getNewValue().getClass();
            if (this.m_axis.getClass() == clazz) {
                this.firePropertyChange("", new Boolean(false), new Boolean(true));
            } else {
                this.firePropertyChange("", new Boolean(true), new Boolean(false));
            }
        }
    }
}

