/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.events;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.events.AChart2DAction;
import info.monitorenter.gui.chart.io.FileFilterExtensions;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public final class Chart2DActionSaveImageSingleton
extends AChart2DAction {
    private static final long serialVersionUID = -2800571545563022874L;
    private JFileChooser m_filechooser;
    private static Map<String, Chart2DActionSaveImageSingleton> instances = new HashMap<String, Chart2DActionSaveImageSingleton>();

    public static Chart2DActionSaveImageSingleton getInstance(Chart2D chart2D, String string) {
        Chart2DActionSaveImageSingleton chart2DActionSaveImageSingleton = instances.get(Chart2DActionSaveImageSingleton.key(chart2D));
        if (chart2DActionSaveImageSingleton == null) {
            chart2DActionSaveImageSingleton = new Chart2DActionSaveImageSingleton(chart2D, string);
            instances.put(Chart2DActionSaveImageSingleton.key(chart2D), chart2DActionSaveImageSingleton);
        }
        return chart2DActionSaveImageSingleton;
    }

    private static String key(Chart2D chart2D) {
        return chart2D.getClass().getName() + chart2D.hashCode();
    }

    private Chart2DActionSaveImageSingleton(Chart2D chart2D, String string) {
        super(chart2D, string);
        chart2D.addPropertyChangeListener("Chart2D.PROPERTY_GRID_COLOR", this);
        this.m_filechooser = new JFileChooser();
        this.m_filechooser.setAcceptAllFileFilterUsed(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        BufferedImage bufferedImage = this.m_chart.snapShot();
        FileFilter[] fileFilterArray = this.m_filechooser.getChoosableFileFilters();
        for (int i = 0; i < fileFilterArray.length; ++i) {
            this.m_filechooser.removeChoosableFileFilter(fileFilterArray[i]);
        }
        String[] stringArray = ImageIO.getWriterFormatNames();
        TreeSet<String> treeSet = new TreeSet<String>();
        ImageTypeSpecifier imageTypeSpecifier = ImageTypeSpecifier.createFromRenderedImage(bufferedImage);
        for (int i = 0; i < stringArray.length; ++i) {
            Iterator<ImageWriter> iterator = ImageIO.getImageWriters(imageTypeSpecifier, stringArray[i]);
            if (!iterator.hasNext()) continue;
            treeSet.add(stringArray[i].toLowerCase());
        }
        for (String string : treeSet) {
            this.m_filechooser.addChoosableFileFilter(new FileFilterExtensions(new String[]{string}));
        }
        int n = this.m_filechooser.showSaveDialog(this.m_chart);
        if (n == 0) {
            String string;
            File file = this.m_filechooser.getSelectedFile();
            string = this.m_filechooser.getFileFilter().getDescription().substring(2);
            ImageWriter imageWriter = ImageIO.getImageWritersBySuffix(string).next();
            ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
            if (imageWriteParam.canWriteCompressed()) {
                imageWriteParam.setCompressionMode(0);
            }
            try {
                imageWriter.setOutput(new FileImageOutputStream(new File(file.getAbsolutePath() + "." + string)));
                imageWriter.write(bufferedImage);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }
}

