/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.events;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.events.AChart2DAction;
import info.monitorenter.gui.chart.io.FileFilterExtensions;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.apache.xmlgraphics.java2d.ps.EPSDocumentGraphics2D;

public final class Chart2DActionSaveEpsSingletonApacheFop {
    private static final long serialVersionUID = -7446202109342192546L;
    public static final boolean EPS_SUPPORTED;
    private static Map<String, Action> instances;

    public static Action getInstance(Chart2D chart2D, String string) {
        Action action = instances.get(Chart2DActionSaveEpsSingletonApacheFop.key(chart2D));
        if (action == null) {
            action = EPS_SUPPORTED ? new Chart2DActionSaveEps(chart2D, string) : new ActionDisabledDummy(string);
            instances.put(Chart2DActionSaveEpsSingletonApacheFop.key(chart2D), action);
        }
        return action;
    }

    private static String key(Chart2D chart2D) {
        return chart2D.getClass().getName() + chart2D.hashCode();
    }

    private Chart2DActionSaveEpsSingletonApacheFop() {
    }

    static {
        instances = new HashMap<String, Action>();
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.apache.xmlgraphics.java2d.ps.EPSDocumentGraphics2D");
        }
        catch (Throwable throwable) {
        }
        finally {
            EPS_SUPPORTED = clazz != null;
        }
    }

    private static final class Chart2DActionSaveEps
    extends AChart2DAction {
        private static final long serialVersionUID = 4165725826047395414L;
        private JFileChooser m_filechooser;

        public Chart2DActionSaveEps(Chart2D chart2D, String string) {
            super(chart2D, string);
            chart2D.addPropertyChangeListener("Chart2D.PROPERTY_GRID_COLOR", this);
            this.m_filechooser = new JFileChooser();
            this.m_filechooser.setAcceptAllFileFilterUsed(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FileFilter[] fileFilterArray = this.m_filechooser.getChoosableFileFilters();
            for (int i = 0; i < fileFilterArray.length; ++i) {
                this.m_filechooser.removeChoosableFileFilter(fileFilterArray[i]);
            }
            String string = "eps";
            this.m_filechooser.addChoosableFileFilter(new FileFilterExtensions(new String[]{string}));
            int n = this.m_filechooser.showSaveDialog(this.m_chart);
            if (n == 0) {
                File file = new File(this.m_filechooser.getSelectedFile().getAbsolutePath() + "." + string);
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    EPSDocumentGraphics2D ePSDocumentGraphics2D = new EPSDocumentGraphics2D(true);
                    ePSDocumentGraphics2D.setGraphicContext(new GraphicContext());
                    ePSDocumentGraphics2D.setupDocument(fileOutputStream, this.m_chart.getWidth(), this.m_chart.getHeight());
                    this.m_chart.paint(ePSDocumentGraphics2D);
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        }
    }

    private static class ActionDisabledDummy
    extends AbstractAction {
        private static final long serialVersionUID = 5537391176736852739L;

        public ActionDisabledDummy(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public boolean isEnabled() {
            return false;
        }
    }
}

