/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.errorbars;

import info.monitorenter.gui.chart.ITracePoint2D;
import info.monitorenter.gui.chart.errorbars.AErrorBarPolicyConfigurable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ErrorBarPolicyRelative
extends AErrorBarPolicyConfigurable {
    private static final long serialVersionUID = 1031825382468141565L;
    private double m_relativeXError = 0.02;
    private double m_relativeYError = 0.02;

    public ErrorBarPolicyRelative(double d) throws IllegalArgumentException {
        this(d, d);
    }

    public ErrorBarPolicyRelative(double d, double d2) throws IllegalArgumentException {
        this.setRelativeXError(d);
        this.setRelativeYError(d2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ErrorBarPolicyRelative errorBarPolicyRelative = (ErrorBarPolicyRelative)object;
        if (Double.doubleToLongBits(this.m_relativeXError) != Double.doubleToLongBits(errorBarPolicyRelative.m_relativeXError)) {
            return false;
        }
        return Double.doubleToLongBits(this.m_relativeYError) == Double.doubleToLongBits(errorBarPolicyRelative.m_relativeYError);
    }

    public JComponent getCustomConfigurator() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        JLabel jLabel = new JLabel("Relative X error (%) ");
        jPanel.add((Component)jLabel, gridBagConstraints);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(this.getRelativeXError() * 100.0, 0.0, 100.0, 1.0);
        JSpinner jSpinner = new JSpinner(spinnerNumberModel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jSpinner, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        jPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        JLabel jLabel2 = new JLabel("Relative Y error (%) ");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        SpinnerNumberModel spinnerNumberModel2 = new SpinnerNumberModel(this.getRelativeYError() * 100.0, 0.0, 100.0, 1.0);
        JSpinner jSpinner2 = new JSpinner(spinnerNumberModel2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jSpinner2, gridBagConstraints);
        jSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JSpinner jSpinner = (JSpinner)changeEvent.getSource();
                SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)jSpinner.getModel();
                Number number = spinnerNumberModel.getNumber();
                ErrorBarPolicyRelative.this.setRelativeXError(number.doubleValue() / 100.0);
            }
        });
        jSpinner2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JSpinner jSpinner = (JSpinner)changeEvent.getSource();
                SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)jSpinner.getModel();
                Number number = spinnerNumberModel.getNumber();
                ErrorBarPolicyRelative.this.setRelativeYError(number.doubleValue() / 100.0);
            }
        });
        return jPanel;
    }

    public final double getRelativeXError() {
        return this.m_relativeXError;
    }

    public final double getRelativeYError() {
        return this.m_relativeYError;
    }

    public final double getXError(double d) {
        return this.m_relativeXError * d;
    }

    public final double getYError(double d) {
        return this.m_relativeYError * d;
    }

    public int hashCode() {
        int n = super.hashCode();
        long l = Double.doubleToLongBits(this.m_relativeXError);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.m_relativeYError);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    protected int internalGetNegativeXError(int n, int n2, ITracePoint2D iTracePoint2D) {
        double d = (double)(n - this.getTrace().getRenderer().getXChartStart()) * this.m_relativeXError;
        int n3 = (int)Math.round((double)n - d);
        return n3;
    }

    protected int internalGetNegativeYError(int n, int n2, ITracePoint2D iTracePoint2D) {
        int n3 = (int)Math.round((double)(this.getTrace().getRenderer().getYChartStart() - n2) * this.m_relativeYError);
        return n2 + n3;
    }

    protected int internalGetPositiveXError(int n, int n2, ITracePoint2D iTracePoint2D) {
        double d = (double)(n - this.getTrace().getRenderer().getXChartStart()) * this.m_relativeXError;
        int n3 = (int)Math.round((double)n + d);
        return n3;
    }

    protected int internalGetPositiveYError(int n, int n2, ITracePoint2D iTracePoint2D) {
        int n3 = (int)Math.round((double)(this.getTrace().getRenderer().getYChartStart() - n2) * this.m_relativeYError);
        return n2 - n3;
    }

    public final void setRelativeXError(double d) throws IllegalArgumentException {
        boolean bl;
        if (d <= 0.0 || d >= 1.0) {
            throw new IllegalArgumentException("Given relative error (" + d + ")has to be between 0.0 and 1.0.");
        }
        boolean bl2 = bl = this.m_relativeXError != d;
        if (bl) {
            this.m_relativeXError = d;
            this.firePropertyChange("IErrorBarPolicy.PROPERTY_CONFIGURATION", null, null);
        }
    }

    public final void setRelativeYError(double d) throws IllegalArgumentException {
        boolean bl;
        if (d <= 0.0 || d >= 1.0) {
            throw new IllegalArgumentException("Given relative error (" + d + ")has to be between 0.0 and 1.0.");
        }
        boolean bl2 = bl = this.m_relativeYError != d;
        if (bl) {
            this.m_relativeYError = d;
            this.firePropertyChange("IErrorBarPolicy.PROPERTY_CONFIGURATION", null, null);
        }
    }
}

