/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.errorbars;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.IAxis;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.ITracePoint2D;
import info.monitorenter.gui.chart.errorbars.AErrorBarPolicyConfigurable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ErrorBarPolicyAbsoluteSummation
extends AErrorBarPolicyConfigurable {
    private static final long serialVersionUID = 256014145931710475L;
    private double m_xError = 4.0;
    private double m_yError = 4.0;

    public ErrorBarPolicyAbsoluteSummation(double d, double d2) throws IllegalArgumentException {
        this.setXError(d);
        this.setYError(d2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ErrorBarPolicyAbsoluteSummation errorBarPolicyAbsoluteSummation = (ErrorBarPolicyAbsoluteSummation)object;
        if (Double.doubleToLongBits(this.m_xError) != Double.doubleToLongBits(errorBarPolicyAbsoluteSummation.m_xError)) {
            return false;
        }
        return Double.doubleToLongBits(this.m_yError) == Double.doubleToLongBits(errorBarPolicyAbsoluteSummation.m_yError);
    }

    public JComponent getCustomConfigurator() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        JLabel jLabel = new JLabel("Absolute X error ");
        jPanel.add((Component)jLabel, gridBagConstraints);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(this.getXError(0.0), 0.0, 1000000.0, 10.0);
        JSpinner jSpinner = new JSpinner(spinnerNumberModel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jSpinner, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        jPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        JLabel jLabel2 = new JLabel("Absolute Y error ");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        SpinnerNumberModel spinnerNumberModel2 = new SpinnerNumberModel(this.getYError(0.0), 0.0, 1000000.0, 10.0);
        JSpinner jSpinner2 = new JSpinner(spinnerNumberModel2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jSpinner2, gridBagConstraints);
        jSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JSpinner jSpinner = (JSpinner)changeEvent.getSource();
                SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)jSpinner.getModel();
                Number number = spinnerNumberModel.getNumber();
                ErrorBarPolicyAbsoluteSummation.this.setXError(number.doubleValue());
            }
        });
        jSpinner2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JSpinner jSpinner = (JSpinner)changeEvent.getSource();
                SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)jSpinner.getModel();
                Number number = spinnerNumberModel.getNumber();
                ErrorBarPolicyAbsoluteSummation.this.setYError(number.doubleValue());
            }
        });
        return jPanel;
    }

    public final double getXError(double d) {
        return this.m_xError;
    }

    public final double getYError(double d) {
        return this.m_yError;
    }

    public int hashCode() {
        int n = super.hashCode();
        long l = Double.doubleToLongBits(this.m_xError);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.m_yError);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    protected int internalGetNegativeXError(int n, int n2, ITracePoint2D iTracePoint2D) {
        ITrace2D iTrace2D = this.getTrace();
        Chart2D chart2D = iTrace2D.getRenderer();
        IAxis<?> iAxis = chart2D.getAxisX();
        int n3 = iAxis.translateValueToPx(iTracePoint2D.getX() - this.m_xError);
        return n3;
    }

    protected int internalGetNegativeYError(int n, int n2, ITracePoint2D iTracePoint2D) {
        ITrace2D iTrace2D = this.getTrace();
        Chart2D chart2D = iTrace2D.getRenderer();
        IAxis<?> iAxis = chart2D.getAxisY();
        int n3 = iAxis.translateValueToPx(iTracePoint2D.getY() - this.m_yError);
        return n3;
    }

    protected int internalGetPositiveXError(int n, int n2, ITracePoint2D iTracePoint2D) {
        ITrace2D iTrace2D = this.getTrace();
        Chart2D chart2D = iTrace2D.getRenderer();
        IAxis<?> iAxis = chart2D.getAxisX();
        int n3 = iAxis.translateValueToPx(iTracePoint2D.getX() + this.m_xError);
        return n3;
    }

    protected int internalGetPositiveYError(int n, int n2, ITracePoint2D iTracePoint2D) {
        ITrace2D iTrace2D = this.getTrace();
        Chart2D chart2D = iTrace2D.getRenderer();
        IAxis<?> iAxis = chart2D.getAxisY();
        int n3 = iAxis.translateValueToPx(iTracePoint2D.getY() + this.m_yError);
        return n3;
    }

    public final void setXError(double d) throws IllegalArgumentException {
        boolean bl;
        if (d < 0.0) {
            throw new IllegalArgumentException("Given absolute error (" + d + ")has to be > 0.");
        }
        boolean bl2 = bl = this.m_xError != d;
        if (bl) {
            this.m_xError = d;
            this.firePropertyChange("IErrorBarPolicy.PROPERTY_CONFIGURATION", null, null);
        }
    }

    public final void setYError(double d) throws IllegalArgumentException {
        boolean bl;
        if (d < 0.0) {
            throw new IllegalArgumentException("Given absolute error (" + d + ")has to be > 0.");
        }
        boolean bl2 = bl = this.m_yError != d;
        if (bl) {
            this.m_yError = d;
            this.firePropertyChange("IErrorBarPolicy.PROPERTY_CONFIGURATION", null, null);
        }
    }
}

