/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.errorbars;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.IErrorBarPainter;
import info.monitorenter.gui.chart.IErrorBarPixel;
import info.monitorenter.gui.chart.IPointPainter;
import info.monitorenter.gui.chart.IPointPainterConfigurableUI;
import info.monitorenter.gui.chart.ITracePoint2D;
import info.monitorenter.gui.chart.pointpainters.PointPainterDisc;
import info.monitorenter.gui.chart.pointpainters.PointPainterLine;
import java.awt.Color;
import java.awt.Graphics;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.event.SwingPropertyChangeSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorBarPainter
implements IErrorBarPainter {
    private static final long serialVersionUID = -4978322492200966266L;
    private IPointPainterConfigurableUI<?> m_connectionPainter;
    private IPointPainterConfigurableUI<?> m_endPointPainter;
    protected PropertyChangeSupport m_propertyChangeSupport = new SwingPropertyChangeSupport(this);
    private final IErrorBarPainter.ISegment m_segmentConnection = new ASegment(){
        private static final long serialVersionUID = 2582262217019921050L;

        @Override
        public Color getColor() {
            return ErrorBarPainter.this.getConnectionColor();
        }

        @Override
        public String getName() {
            return "Connection segment";
        }

        @Override
        public IPointPainterConfigurableUI<?> getPointPainter() {
            return ErrorBarPainter.this.getConnectionPainter();
        }

        @Override
        public final String getPropertySegmentColor() {
            return "IErrorBarPainter.PROPERTY_CONNECTION_COLOR";
        }

        @Override
        public final String getPropertySegmentPointPainter() {
            return "IErrorBarPainter.PROPERTY_CONNECTION";
        }

        @Override
        public void setColor(Color color) {
            ErrorBarPainter.this.setConnectionColor(color);
        }

        @Override
        public void setPointPainter(IPointPainterConfigurableUI<?> iPointPainterConfigurableUI) {
            ErrorBarPainter.this.setConnectionPainter(iPointPainterConfigurableUI);
        }
    };
    private final IErrorBarPainter.ISegment m_segmentEnd = new ASegment(){
        private static final long serialVersionUID = -5655272957651523988L;

        @Override
        public Color getColor() {
            return ErrorBarPainter.this.getEndPointColor();
        }

        @Override
        public String getName() {
            return "End segment";
        }

        @Override
        public IPointPainterConfigurableUI<?> getPointPainter() {
            return ErrorBarPainter.this.getEndPointPainter();
        }

        @Override
        public String getPropertySegmentColor() {
            return "IErrorBarPainter.PROPERTY_ENDPOINT_COLOR";
        }

        @Override
        public String getPropertySegmentPointPainter() {
            return "IErrorBarPainter.PROPERTY_ENDPOINT";
        }

        @Override
        public void setColor(Color color) {
            ErrorBarPainter.this.setEndPointColor(color);
        }

        @Override
        public void setPointPainter(IPointPainterConfigurableUI<?> iPointPainterConfigurableUI) {
            ErrorBarPainter.this.setEndPointPainter(iPointPainterConfigurableUI);
        }
    };
    private final IErrorBarPainter.ISegment m_segmentStart = new ASegment(){
        private static final long serialVersionUID = -1547300597027982211L;

        @Override
        public Color getColor() {
            return ErrorBarPainter.this.getStartPointColor();
        }

        @Override
        public String getName() {
            return "Start segment";
        }

        @Override
        public IPointPainterConfigurableUI<?> getPointPainter() {
            return ErrorBarPainter.this.getStartPointPainter();
        }

        @Override
        public String getPropertySegmentColor() {
            return "IErrorBarPainter.PROPERTY_STARTPOINT_COLOR";
        }

        @Override
        public String getPropertySegmentPointPainter() {
            return "IErrorBarPainter.PROPERTY_STARTPOINT";
        }

        @Override
        public void setColor(Color color) {
            ErrorBarPainter.this.setStartPointColor(color);
        }

        @Override
        public void setPointPainter(IPointPainterConfigurableUI<?> iPointPainterConfigurableUI) {
            ErrorBarPainter.this.setStartPointPainter(iPointPainterConfigurableUI);
        }
    };
    private IPointPainterConfigurableUI<?> m_startPointPainter = null;
    public static final Color DEFAULT_SEGMENT_COLOR = Color.GRAY;

    public ErrorBarPainter() {
        this.m_connectionPainter = new PointPainterLine();
        this.m_endPointPainter = new PointPainterDisc(4);
    }

    @Override
    public final void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.m_propertyChangeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ErrorBarPainter errorBarPainter = (ErrorBarPainter)object;
        if (this.m_connectionPainter == null ? errorBarPainter.m_connectionPainter != null : !this.m_connectionPainter.equals(errorBarPainter.m_connectionPainter)) {
            return false;
        }
        if (this.m_endPointPainter == null ? errorBarPainter.m_endPointPainter != null : !this.m_endPointPainter.equals(errorBarPainter.m_endPointPainter)) {
            return false;
        }
        if (this.m_propertyChangeSupport == null ? errorBarPainter.m_propertyChangeSupport != null : !this.m_propertyChangeSupport.equals(errorBarPainter.m_propertyChangeSupport)) {
            return false;
        }
        if (this.m_segmentConnection == null ? errorBarPainter.m_segmentConnection != null : !this.m_segmentConnection.equals(errorBarPainter.m_segmentConnection)) {
            return false;
        }
        if (this.m_segmentEnd == null ? errorBarPainter.m_segmentEnd != null : !this.m_segmentEnd.equals(errorBarPainter.m_segmentEnd)) {
            return false;
        }
        if (this.m_segmentStart == null ? errorBarPainter.m_segmentStart != null : !this.m_segmentStart.equals(errorBarPainter.m_segmentStart)) {
            return false;
        }
        return !(this.m_startPointPainter == null ? errorBarPainter.m_startPointPainter != null : !this.m_startPointPainter.equals(errorBarPainter.m_startPointPainter));
    }

    @Override
    public final Color getConnectionColor() {
        Color color = this.getDefaultedColor(this.m_connectionPainter);
        return color;
    }

    public final IPointPainterConfigurableUI<?> getConnectionPainter() {
        return this.m_connectionPainter;
    }

    @Override
    public final Color getEndPointColor() {
        Color color = this.getDefaultedColor(this.m_endPointPainter);
        return color;
    }

    @Override
    public final IPointPainterConfigurableUI<?> getEndPointPainter() {
        return this.m_endPointPainter;
    }

    @Override
    public PropertyChangeListener[] getPropertyChangeListeners(String string) {
        return this.m_propertyChangeSupport.getPropertyChangeListeners(string);
    }

    @Override
    public IErrorBarPainter.ISegment getSegmentConnection() {
        return this.m_segmentConnection;
    }

    @Override
    public IErrorBarPainter.ISegment getSegmentEnd() {
        return this.m_segmentEnd;
    }

    @Override
    public IErrorBarPainter.ISegment getSegmentStart() {
        return this.m_segmentStart;
    }

    @Override
    public final Color getStartPointColor() {
        Color color = this.getDefaultedColor(this.m_startPointPainter);
        return color;
    }

    private Color getDefaultedColor(IPointPainterConfigurableUI<?> iPointPainterConfigurableUI) {
        Color color = null;
        if (iPointPainterConfigurableUI != null) {
            color = iPointPainterConfigurableUI.getColor();
        }
        if (color == null) {
            color = DEFAULT_SEGMENT_COLOR;
        }
        return color;
    }

    @Override
    public final IPointPainterConfigurableUI<?> getStartPointPainter() {
        return this.m_startPointPainter;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.m_connectionPainter == null ? 0 : this.m_connectionPainter.hashCode());
        n = 31 * n + (this.m_endPointPainter == null ? 0 : this.m_endPointPainter.hashCode());
        n = 31 * n + (this.m_propertyChangeSupport == null ? 0 : this.m_propertyChangeSupport.hashCode());
        n = 31 * n + (this.m_segmentConnection == null ? 0 : this.m_segmentConnection.hashCode());
        n = 31 * n + (this.m_segmentEnd == null ? 0 : this.m_segmentEnd.hashCode());
        n = 31 * n + (this.m_segmentStart == null ? 0 : this.m_segmentStart.hashCode());
        n = 31 * n + (this.m_startPointPainter == null ? 0 : this.m_startPointPainter.hashCode());
        return n;
    }

    @Override
    public void paintErrorBar(int n, int n2, ITracePoint2D iTracePoint2D, Graphics graphics, IErrorBarPixel iErrorBarPixel) {
        int n3;
        int n4;
        Chart2D chart2D = iErrorBarPixel.getTrace().getRenderer();
        int n5 = chart2D.getXChartStart();
        int n6 = chart2D.getXChartEnd();
        int n7 = chart2D.getYChartStart();
        int n8 = chart2D.getYChartEnd();
        int n9 = n < n5 ? n5 : n;
        n9 = n > n6 ? n6 : n;
        int n10 = n2 > n7 ? n7 : n2;
        n10 = n2 < n8 ? n8 : n2;
        int n11 = iErrorBarPixel.getNegativeXErrorPixel();
        if (n11 != Integer.MAX_VALUE) {
            n4 = n10;
            n3 = n11 < n5 ? n5 : n11;
            this.paintErrorBarPart(n9, n10, n3, n4, iTracePoint2D, this.m_connectionPainter, graphics);
            this.paintErrorBarPart(n9, n10, n3, n4, iTracePoint2D, this.m_startPointPainter, graphics);
            if (n3 == n11) {
                this.paintErrorBarPart(n3, n10, n9, n10, iTracePoint2D, this.m_endPointPainter, graphics);
            }
        }
        if ((n11 = iErrorBarPixel.getPositiveXErrorPixel()) != Integer.MAX_VALUE) {
            n4 = n10;
            n3 = n11 > n6 ? n6 : n11;
            this.paintErrorBarPart(n9, n10, n3, n4, iTracePoint2D, this.m_connectionPainter, graphics);
            this.paintErrorBarPart(n9, n10, n3, n4, iTracePoint2D, this.m_startPointPainter, graphics);
            if (n3 == n11) {
                this.paintErrorBarPart(n3, n10, n9, n10, iTracePoint2D, this.m_endPointPainter, graphics);
            }
        }
        if ((n11 = iErrorBarPixel.getNegativeYErrorPixel()) != Integer.MAX_VALUE) {
            n3 = n9;
            n4 = n11 > n7 ? n7 : n11;
            this.paintErrorBarPart(n9, n10, n3, n4, iTracePoint2D, this.m_connectionPainter, graphics);
            this.paintErrorBarPart(n9, n10, n3, n4, iTracePoint2D, this.m_startPointPainter, graphics);
            if (n4 == n11) {
                this.paintErrorBarPart(n9, n4, n9, n10, iTracePoint2D, this.m_endPointPainter, graphics);
            }
        }
        if ((n11 = iErrorBarPixel.getPositiveYErrorPixel()) != Integer.MAX_VALUE) {
            n3 = n9;
            n4 = n11 < n8 ? n8 : n11;
            this.paintErrorBarPart(n9, n10, n3, n4, iTracePoint2D, this.m_connectionPainter, graphics);
            this.paintErrorBarPart(n9, n10, n3, n4, iTracePoint2D, this.m_startPointPainter, graphics);
            if (n4 == n11) {
                this.paintErrorBarPart(n9, n4, n9, n10, iTracePoint2D, this.m_endPointPainter, graphics);
            }
        }
    }

    private final void paintErrorBarPart(int n, int n2, int n3, int n4, ITracePoint2D iTracePoint2D, IPointPainter<?> iPointPainter, Graphics graphics) {
        if (iPointPainter != null) {
            iPointPainter.paintPoint(n, n2, n3, n4, graphics, iTracePoint2D);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.m_propertyChangeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    @Override
    public final void setConnectionColor(Color color) {
        if (this.m_connectionPainter != null) {
            Color color2 = this.m_connectionPainter.getColor();
            this.m_connectionPainter.setColor(color);
            this.m_propertyChangeSupport.firePropertyChange("IErrorBarPainter.PROPERTY_CONNECTION_COLOR", color2, color);
        }
    }

    @Override
    public final void setConnectionPainter(IPointPainterConfigurableUI<?> iPointPainterConfigurableUI) {
        Color color;
        IPointPainterConfigurableUI<?> iPointPainterConfigurableUI2 = this.m_connectionPainter;
        if (this.m_connectionPainter != null && (color = this.m_connectionPainter.getColor()) != null && iPointPainterConfigurableUI != null) {
            iPointPainterConfigurableUI.setColor(color);
        }
        this.m_connectionPainter = iPointPainterConfigurableUI;
        this.m_propertyChangeSupport.firePropertyChange("IErrorBarPainter.PROPERTY_CONNECTION", iPointPainterConfigurableUI2, iPointPainterConfigurableUI);
    }

    @Override
    public final void setEndPointColor(Color color) {
        if (this.m_endPointPainter != null) {
            Color color2 = this.m_endPointPainter.getColor();
            this.m_endPointPainter.setColor(color);
            this.m_propertyChangeSupport.firePropertyChange("IErrorBarPainter.PROPERTY_ENDPOINT_COLOR", color2, color);
        }
    }

    @Override
    public final void setEndPointPainter(IPointPainterConfigurableUI<?> iPointPainterConfigurableUI) {
        Color color;
        IPointPainterConfigurableUI<?> iPointPainterConfigurableUI2 = this.m_endPointPainter;
        if (this.m_endPointPainter != null && (color = this.m_endPointPainter.getColor()) != null && iPointPainterConfigurableUI != null) {
            iPointPainterConfigurableUI.setColor(color);
        }
        this.m_endPointPainter = iPointPainterConfigurableUI;
        this.m_propertyChangeSupport.firePropertyChange("IErrorBarPainter.PROPERTY_ENDPOINT", iPointPainterConfigurableUI2, iPointPainterConfigurableUI);
    }

    @Override
    public final void setStartPointColor(Color color) {
        if (this.m_startPointPainter != null) {
            Color color2 = this.m_startPointPainter.getColor();
            this.m_startPointPainter.setColor(color);
            this.m_propertyChangeSupport.firePropertyChange("IErrorBarPainter.PROPERTY_STARTPOINT_COLOR", color2, color);
        }
    }

    @Override
    public final void setStartPointPainter(IPointPainterConfigurableUI<?> iPointPainterConfigurableUI) {
        Color color;
        IPointPainterConfigurableUI<?> iPointPainterConfigurableUI2 = this.m_startPointPainter;
        if (this.m_startPointPainter != null && (color = this.m_startPointPainter.getColor()) != null && iPointPainterConfigurableUI != null) {
            iPointPainterConfigurableUI.setColor(color);
        }
        this.m_startPointPainter = iPointPainterConfigurableUI;
        this.m_propertyChangeSupport.firePropertyChange("IErrorBarPainter.PROPERTY_STARTPOINT", iPointPainterConfigurableUI2, this.m_startPointPainter);
    }

    private abstract class ASegment
    implements IErrorBarPainter.ISegment {
        private static final long serialVersionUID = 6620706884643200785L;

        protected ASegment() {
        }

        public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
            ErrorBarPainter.this.addPropertyChangeListener(string, propertyChangeListener);
        }
    }
}

