/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.errorbars;

import info.monitorenter.gui.chart.IErrorBarPainter;
import info.monitorenter.gui.chart.IErrorBarPolicy;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.ITracePoint2D;
import info.monitorenter.gui.chart.errorbars.ErrorBarPixel;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.SwingPropertyChangeSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AErrorBarPolicyConfigurable
implements IErrorBarPolicy<AErrorBarPolicyConfigurable>,
PropertyChangeListener {
    private static final long serialVersionUID = -1163969612681194656L;
    private final Set<IErrorBarPainter> m_errorBarPainters = new LinkedHashSet<IErrorBarPainter>();
    private boolean m_isEnded = false;
    protected ITracePoint2D m_lastPoint;
    protected int m_lastX;
    protected int m_lastY;
    protected PropertyChangeSupport m_propertyChangeSupport = new SwingPropertyChangeSupport(this);
    private final ErrorBarPixel m_reusedErrorBarPixel = new ErrorBarPixel(null);
    private boolean m_showNegativeXErrors;
    private boolean m_showNegativeYErrors;
    private boolean m_showPositiveXErrors;
    private boolean m_showPositiveYErrors;
    private ITrace2D m_trace;

    @Override
    public void addErrorBarPainter(IErrorBarPainter iErrorBarPainter) {
        this.m_errorBarPainters.add(iErrorBarPainter);
        iErrorBarPainter.addPropertyChangeListener("IErrorBarPainter.PROPERTY_CONNECTION", this);
        iErrorBarPainter.addPropertyChangeListener("IErrorBarPainter.PROPERTY_CONNECTION_COLOR", this);
        iErrorBarPainter.addPropertyChangeListener("IErrorBarPainter.PROPERTY_ENDPOINT", this);
        iErrorBarPainter.addPropertyChangeListener("IErrorBarPainter.PROPERTY_ENDPOINT_COLOR", this);
        iErrorBarPainter.addPropertyChangeListener("IErrorBarPainter.PROPERTY_STARTPOINT", this);
        iErrorBarPainter.addPropertyChangeListener("IErrorBarPainter.PROPERTY_STARTPOINT_COLOR", this);
        this.firePropertyChange("IErrorBarPolicy.PROPERTY_ERRORBARPAINTER", null, iErrorBarPainter);
        this.firePropertyChange("IErrorBarPolicy.PROPERTY_CONFIGURATION", null, null);
    }

    @Override
    public final void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.m_propertyChangeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    @Override
    public final void calculateErrorBar(int n, int n2, ErrorBarPixel errorBarPixel, ITracePoint2D iTracePoint2D) {
        errorBarPixel.clear();
        if (this.m_showNegativeXErrors) {
            errorBarPixel.setNegativeXErrorPixel(this.internalGetNegativeXError(n, n2, iTracePoint2D));
        }
        if (this.m_showNegativeYErrors) {
            errorBarPixel.setNegativeYErrorPixel(this.internalGetNegativeYError(n, n2, iTracePoint2D));
        }
        if (this.m_showPositiveXErrors) {
            errorBarPixel.setPositiveXErrorPixel(this.internalGetPositiveXError(n, n2, iTracePoint2D));
        }
        if (this.m_showPositiveYErrors) {
            errorBarPixel.setPositiveYErrorPixel(this.internalGetPositiveYError(n, n2, iTracePoint2D));
        }
    }

    @Override
    public int compareTo(AErrorBarPolicyConfigurable aErrorBarPolicyConfigurable) {
        return this.getClass().getName().compareTo(aErrorBarPolicyConfigurable.getClass().getName());
    }

    @Override
    public void discontinue(Graphics graphics) {
        this.endPaintIteration(graphics);
        this.startPaintIteration(graphics);
    }

    @Override
    public void endPaintIteration(Graphics graphics) {
        if (graphics != null) {
            this.calculateErrorBar(this.getPreviousX(), this.getPreviousY(), this.m_reusedErrorBarPixel, this.getPreviousTracePoint());
            for (IErrorBarPainter iErrorBarPainter : this.m_errorBarPainters) {
                iErrorBarPainter.paintErrorBar(this.getPreviousX(), this.getPreviousY(), this.getPreviousTracePoint(), graphics, this.m_reusedErrorBarPixel);
            }
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AErrorBarPolicyConfigurable aErrorBarPolicyConfigurable = (AErrorBarPolicyConfigurable)object;
        if (this.m_errorBarPainters == null ? aErrorBarPolicyConfigurable.m_errorBarPainters != null : !this.m_errorBarPainters.equals(aErrorBarPolicyConfigurable.m_errorBarPainters)) {
            return false;
        }
        if (this.m_isEnded != aErrorBarPolicyConfigurable.m_isEnded) {
            return false;
        }
        if (this.m_lastPoint == null ? aErrorBarPolicyConfigurable.m_lastPoint != null : !this.m_lastPoint.equals(aErrorBarPolicyConfigurable.m_lastPoint)) {
            return false;
        }
        if (this.m_lastX != aErrorBarPolicyConfigurable.m_lastX) {
            return false;
        }
        if (this.m_lastY != aErrorBarPolicyConfigurable.m_lastY) {
            return false;
        }
        if (this.m_showNegativeXErrors != aErrorBarPolicyConfigurable.m_showNegativeXErrors) {
            return false;
        }
        if (this.m_showNegativeYErrors != aErrorBarPolicyConfigurable.m_showNegativeYErrors) {
            return false;
        }
        if (this.m_showPositiveXErrors != aErrorBarPolicyConfigurable.m_showPositiveXErrors) {
            return false;
        }
        return this.m_showPositiveYErrors == aErrorBarPolicyConfigurable.m_showPositiveYErrors;
    }

    protected final void firePropertyChange(String string, Object object, Object object2) {
        this.m_propertyChangeSupport.firePropertyChange(string, object, object2);
    }

    @Override
    public JComponent getCustomConfigurator() {
        return null;
    }

    @Override
    public Set<IErrorBarPainter> getErrorBarPainters() {
        return this.m_errorBarPainters;
    }

    private ITracePoint2D getPreviousTracePoint() {
        ITracePoint2D iTracePoint2D = this.m_lastPoint;
        return iTracePoint2D;
    }

    private int getPreviousX() {
        int n = this.m_lastX;
        if (this.m_isEnded) {
            this.m_lastX = Integer.MIN_VALUE;
            if (this.m_lastY == Integer.MIN_VALUE) {
                this.m_isEnded = false;
            }
        }
        return n;
    }

    private int getPreviousY() {
        int n = this.m_lastY;
        if (this.m_isEnded) {
            this.m_lastY = Integer.MIN_VALUE;
            if (this.m_lastX == Integer.MIN_VALUE) {
                this.m_isEnded = false;
            }
        }
        return n;
    }

    protected final ITrace2D getTrace() {
        return this.m_trace;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.m_errorBarPainters == null ? 0 : this.m_errorBarPainters.hashCode());
        n = 31 * n + (this.m_isEnded ? 1231 : 1237);
        n = 31 * n + (this.m_lastPoint == null ? 0 : this.m_lastPoint.hashCode());
        n = 31 * n + this.m_lastX;
        n = 31 * n + this.m_lastY;
        n = 31 * n + (this.m_showNegativeXErrors ? 1231 : 1237);
        n = 31 * n + (this.m_showNegativeYErrors ? 1231 : 1237);
        n = 31 * n + (this.m_showPositiveXErrors ? 1231 : 1237);
        n = 31 * n + (this.m_showPositiveYErrors ? 1231 : 1237);
        return n;
    }

    protected abstract int internalGetNegativeXError(int var1, int var2, ITracePoint2D var3);

    protected abstract int internalGetNegativeYError(int var1, int var2, ITracePoint2D var3);

    protected abstract int internalGetPositiveXError(int var1, int var2, ITracePoint2D var3);

    protected abstract int internalGetPositiveYError(int var1, int var2, ITracePoint2D var3);

    @Override
    public final boolean isShowNegativeXErrors() {
        return this.m_showNegativeXErrors;
    }

    @Override
    public final boolean isShowNegativeYErrors() {
        return this.m_showNegativeYErrors;
    }

    @Override
    public final boolean isShowPositiveXErrors() {
        return this.m_showPositiveXErrors;
    }

    @Override
    public final boolean isShowPositiveYErrors() {
        return this.m_showPositiveYErrors;
    }

    @Override
    public void paintPoint(int n, int n2, int n3, int n4, Graphics graphics, ITracePoint2D iTracePoint2D) {
        this.calculateErrorBar(n3, n4, this.m_reusedErrorBarPixel, iTracePoint2D);
        for (IErrorBarPainter iErrorBarPainter : this.m_errorBarPainters) {
            iErrorBarPainter.paintErrorBar(n3, n4, iTracePoint2D, graphics, this.m_reusedErrorBarPixel);
        }
        this.m_lastX = n3;
        this.m_lastY = n4;
        this.m_lastPoint = iTracePoint2D;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.firePropertyChange("IErrorBarPolicy.PROPERTY_CONFIGURATION", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
    }

    @Override
    public boolean removeErrorBarPainter(IErrorBarPainter iErrorBarPainter) {
        boolean bl = this.m_errorBarPainters.remove(iErrorBarPainter);
        iErrorBarPainter.removePropertyChangeListener("IErrorBarPainter.PROPERTY_CONNECTION", this);
        iErrorBarPainter.removePropertyChangeListener("IErrorBarPainter.PROPERTY_CONNECTION_COLOR", this);
        iErrorBarPainter.removePropertyChangeListener("IErrorBarPainter.PROPERTY_ENDPOINT", this);
        iErrorBarPainter.removePropertyChangeListener("IErrorBarPainter.PROPERTY_ENDPOINT_COLOR", this);
        iErrorBarPainter.removePropertyChangeListener("IErrorBarPainter.PROPERTY_STARTPOINT", this);
        iErrorBarPainter.removePropertyChangeListener("IErrorBarPainter.PROPERTY_STARTPOINT_COLOR", this);
        if (bl) {
            this.firePropertyChange("IErrorBarPolicy.PROPERTY_ERRORBARPAINTER", iErrorBarPainter, null);
            this.firePropertyChange("IErrorBarPolicy.PROPERTY_CONFIGURATION", null, null);
        }
        return bl;
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.m_propertyChangeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    @Override
    public void setErrorBarPainter(IErrorBarPainter iErrorBarPainter) {
        Iterator<IErrorBarPainter> iterator = this.m_errorBarPainters.iterator();
        while (iterator.hasNext()) {
            IErrorBarPainter iErrorBarPainter2 = iterator.next();
            iterator.remove();
            iErrorBarPainter2.removePropertyChangeListener("IErrorBarPainter.PROPERTY_CONNECTION", this);
            iErrorBarPainter2.removePropertyChangeListener("IErrorBarPainter.PROPERTY_CONNECTION_COLOR", this);
            iErrorBarPainter2.removePropertyChangeListener("IErrorBarPainter.PROPERTY_ENDPOINT", this);
            iErrorBarPainter2.removePropertyChangeListener("IErrorBarPainter.PROPERTY_ENDPOINT_COLOR", this);
            iErrorBarPainter2.removePropertyChangeListener("IErrorBarPainter.PROPERTY_STARTPOINT", this);
            iErrorBarPainter2.removePropertyChangeListener("IErrorBarPainter.PROPERTY_STARTPOINT_COLOR", this);
            this.firePropertyChange("IErrorBarPolicy.PROPERTY_ERRORBARPAINTER", iErrorBarPainter2, null);
        }
        this.m_errorBarPainters.add(iErrorBarPainter);
        iErrorBarPainter.addPropertyChangeListener("IErrorBarPainter.PROPERTY_CONNECTION", this);
        iErrorBarPainter.addPropertyChangeListener("IErrorBarPainter.PROPERTY_CONNECTION_COLOR", this);
        iErrorBarPainter.addPropertyChangeListener("IErrorBarPainter.PROPERTY_ENDPOINT", this);
        iErrorBarPainter.addPropertyChangeListener("IErrorBarPainter.PROPERTY_ENDPOINT_COLOR", this);
        iErrorBarPainter.addPropertyChangeListener("IErrorBarPainter.PROPERTY_STARTPOINT", this);
        iErrorBarPainter.addPropertyChangeListener("IErrorBarPainter.PROPERTY_STARTPOINT_COLOR", this);
        this.firePropertyChange("IErrorBarPolicy.PROPERTY_ERRORBARPAINTER", null, iErrorBarPainter);
        this.firePropertyChange("IErrorBarPolicy.PROPERTY_CONFIGURATION", null, null);
    }

    @Override
    public final void setShowNegativeXErrors(boolean bl) {
        boolean bl2 = this.m_showNegativeXErrors ^ bl;
        if (bl2) {
            this.m_showNegativeXErrors = bl;
            this.firePropertyChange("IErrorBarPolicy.PROPERTY_CONFIGURATION", null, null);
        }
    }

    @Override
    public final void setShowNegativeYErrors(boolean bl) {
        boolean bl2 = this.m_showNegativeYErrors ^ bl;
        if (bl2) {
            this.m_showNegativeYErrors = bl;
            this.firePropertyChange("IErrorBarPolicy.PROPERTY_CONFIGURATION", null, null);
        }
    }

    @Override
    public final void setShowPositiveXErrors(boolean bl) {
        boolean bl2 = this.m_showPositiveXErrors ^ bl;
        if (bl2) {
            this.m_showPositiveXErrors = bl;
            this.firePropertyChange("IErrorBarPolicy.PROPERTY_CONFIGURATION", null, null);
        }
    }

    @Override
    public final void setShowPositiveYErrors(boolean bl) {
        boolean bl2 = this.m_showPositiveYErrors ^ bl;
        if (bl2) {
            this.m_showPositiveYErrors = bl;
            this.firePropertyChange("IErrorBarPolicy.PROPERTY_CONFIGURATION", null, null);
        }
    }

    @Override
    public void setTrace(ITrace2D iTrace2D) {
        this.m_trace = iTrace2D;
        this.m_reusedErrorBarPixel.setTrace(iTrace2D);
    }

    @Override
    public void startPaintIteration(Graphics graphics) {
    }
}

