/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.demos;

import info.monitorenter.gui.chart.ZoomableChart;
import info.monitorenter.gui.chart.axis.AxisLogE;
import info.monitorenter.gui.chart.errorbars.ErrorBarPainter;
import info.monitorenter.gui.chart.errorbars.ErrorBarPolicyAbsoluteSummation;
import info.monitorenter.gui.chart.traces.Trace2DSimple;
import info.monitorenter.gui.chart.views.ChartPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;

public class ZoomChartWithErrorBarsAndLogAxis
extends JFrame {
    private static final long serialVersionUID = 1497610918434714345L;

    public static void main(String[] stringArray) {
        ZoomChartWithErrorBarsAndLogAxis zoomChartWithErrorBarsAndLogAxis = new ZoomChartWithErrorBarsAndLogAxis();
        zoomChartWithErrorBarsAndLogAxis.setSize(640, 480);
        zoomChartWithErrorBarsAndLogAxis.setVisible(true);
    }

    public ZoomChartWithErrorBarsAndLogAxis() {
        super("ZoomableChart with log y axis and errorbars");
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        ZoomableChart zoomableChart = new ZoomableChart();
        Trace2DSimple trace2DSimple = new Trace2DSimple("Trace");
        trace2DSimple.setColor(Color.BLUE);
        zoomableChart.addTrace(trace2DSimple);
        ErrorBarPolicyAbsoluteSummation errorBarPolicyAbsoluteSummation = new ErrorBarPolicyAbsoluteSummation(4.0, 4.0);
        errorBarPolicyAbsoluteSummation.setShowPositiveYErrors(true);
        ErrorBarPainter errorBarPainter = new ErrorBarPainter();
        errorBarPolicyAbsoluteSummation.addErrorBarPainter(errorBarPainter);
        trace2DSimple.addErrorBarPolicy(errorBarPolicyAbsoluteSummation);
        zoomableChart.setAxisYLeft(new AxisLogE(), 0);
        for (int i = 1; i < 100; ++i) {
            trace2DSimple.addPoint(i, i);
        }
        container.add(new ChartPanel(zoomableChart));
        JButton jButton = new JButton("Zoom All");
        jButton.addActionListener(new ZoomAllAdapter(zoomableChart));
        container.add((Component)jButton, "North");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
    }

    class ZoomAllAdapter
    implements ActionListener {
        private ZoomableChart m_zoomableChart;

        public ZoomAllAdapter(ZoomableChart zoomableChart) {
            this.m_zoomableChart = zoomableChart;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.m_zoomableChart.zoomAll();
        }
    }
}

