/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.demos;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.io.AStaticDataCollector;
import info.monitorenter.gui.chart.io.PropertyFileStaticDataCollector;
import info.monitorenter.gui.chart.traces.Trace2DSimple;
import info.monitorenter.gui.chart.views.ChartPanel;
import info.monitorenter.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class StaticCollectorChart
extends JPanel {
    private static final long serialVersionUID = 3689069555917797688L;
    private Chart2D m_chart;

    public static void main(String[] stringArray) throws IOException {
        JFrame jFrame = new JFrame("SampleChart");
        boolean bl = false;
        try {
            File file;
            if (stringArray.length != 0 && !StringUtil.isEmpty(stringArray[0]) && (file = new File(stringArray[0])).exists() && file.isFile()) {
                bl = true;
                FileInputStream fileInputStream = new FileInputStream(new File(stringArray[0]));
                Trace2DSimple trace2DSimple = new Trace2DSimple();
                PropertyFileStaticDataCollector propertyFileStaticDataCollector = new PropertyFileStaticDataCollector(trace2DSimple, fileInputStream);
                jFrame.getContentPane().add(new StaticCollectorChart(propertyFileStaticDataCollector));
                jFrame.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        System.exit(0);
                    }
                });
                jFrame.setSize(600, 600);
                jFrame.setVisible(true);
            }
        }
        catch (Throwable throwable) {
            bl = false;
            throwable.printStackTrace(System.err);
        }
        if (!bl) {
            System.out.println("Missing program argument. Please give the location of a property-file to this program.\n Example: java -cp jchart2d-version.jar " + StaticCollectorChart.class.getName() + " /home/me/data.properties");
        }
    }

    public StaticCollectorChart(AStaticDataCollector aStaticDataCollector) throws IOException {
        this.setLayout(new BorderLayout());
        this.m_chart = new Chart2D();
        this.m_chart.addTrace(aStaticDataCollector.getTrace());
        aStaticDataCollector.collectData();
        this.add((Component)new ChartPanel(this.m_chart), "Center");
    }

    public final Chart2D getChart() {
        return this.m_chart;
    }
}

