/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.demos;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.controls.LayoutFactory;
import info.monitorenter.gui.chart.events.Chart2DActionSaveImageSingleton;
import info.monitorenter.gui.chart.io.ADataCollector;
import info.monitorenter.gui.chart.io.RandomDataCollectorOffset;
import info.monitorenter.gui.chart.rangepolicies.RangePolicyMinimumViewport;
import info.monitorenter.gui.chart.traces.Trace2DLtd;
import info.monitorenter.gui.chart.views.ChartPanel;
import info.monitorenter.util.Range;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class Showcase
extends JApplet {
    private static final long serialVersionUID = 3904676068135678004L;
    protected Chart2D m_chart;
    private transient ADataCollector m_collector;
    private Trace2DLtd m_trace;

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Showcase");
        Showcase showcase = new Showcase();
        showcase.init();
        jFrame.getContentPane().add(showcase);
        jFrame.setSize(400, 600);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.setVisible(true);
    }

    public synchronized void clearTrace() {
        this.getTrace().removeAllPoints();
    }

    public Chart2D getChart() {
        return this.m_chart;
    }

    public ADataCollector getCollector() {
        return this.m_collector;
    }

    public Trace2DLtd getTrace() {
        return this.m_trace;
    }

    public void init() {
        super.init();
        Chart2D chart2D = new Chart2D();
        this.setChart(chart2D);
        this.setSize(new Dimension(600, 500));
        this.m_chart.getAxisX().setPaintGrid(true);
        this.m_chart.getAxisY().setPaintGrid(true);
        chart2D.getAxisY().setRangePolicy(new RangePolicyMinimumViewport(new Range(-20.0, 20.0)));
        chart2D.setGridColor(Color.LIGHT_GRAY);
        this.setTrace(new Trace2DLtd(100));
        this.getTrace().setName("random");
        this.getTrace().setPhysicalUnits("Milliseconds", "random value");
        this.getTrace().setColor(Color.RED);
        chart2D.addTrace(this.getTrace());
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        LayoutFactory layoutFactory = LayoutFactory.getInstance();
        ChartPanel chartPanel = new ChartPanel(chart2D);
        this.setJMenuBar(layoutFactory.createChartMenuBar(chartPanel, false));
        container.add(chartPanel);
        container.addPropertyChangeListener(chartPanel);
        this.setCollector(new RandomDataCollectorOffset((ITrace2D)this.getTrace(), 50));
        container.add(new ControlPanel());
    }

    public void setChart(Chart2D chart2D) {
        if (this.m_chart == null) {
            this.m_chart = chart2D;
        }
    }

    private void setCollector(RandomDataCollectorOffset randomDataCollectorOffset) {
        this.m_collector = randomDataCollectorOffset;
    }

    public void setTrace(Trace2DLtd trace2DLtd) {
        if (this.m_trace == null) {
            this.m_trace = trace2DLtd;
        }
    }

    public synchronized void startData() {
        if (!this.getCollector().isRunning()) {
            this.getCollector().start();
        }
    }

    public synchronized void stopData() {
        if (this.getCollector().isRunning()) {
            this.getCollector().stop();
        }
    }

    final class ControlPanel
    extends JPanel {
        private static final long serialVersionUID = 3257005441048129846L;
        private JSlider m_amountPointsSlider;
        private JButton m_clear;
        private JComboBox m_colorChooser;
        private JSlider m_latencyTimeSlider;
        private JButton m_snapshot;
        private JButton m_startStop;

        protected ControlPanel() {
            this.setBackground(Color.WHITE);
            this.createAmountPointSlider();
            this.createLatencySlider();
            this.createStartStopButton();
            this.createSnapShotButton();
            this.createClearButton();
            this.createColorChooserButton();
            this.setLayout(new BoxLayout(this, 1));
            this.add(this.m_amountPointsSlider);
            this.add(this.m_latencyTimeSlider);
            JPanel jPanel = new JPanel();
            jPanel.setBackground(Color.WHITE);
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.add(Box.createHorizontalGlue());
            jPanel.add(this.m_startStop);
            jPanel.add(Box.createHorizontalGlue());
            jPanel.add(this.m_clear);
            if (this.m_snapshot != null) {
                jPanel.add(Box.createHorizontalGlue());
                jPanel.add(this.m_snapshot);
            }
            jPanel.add(Box.createHorizontalGlue());
            jPanel.add(this.m_colorChooser);
            jPanel.add(Box.createHorizontalGlue());
            this.add(jPanel);
        }

        private void createAmountPointSlider() {
            this.m_amountPointsSlider = new JSlider(10, 410);
            this.m_amountPointsSlider.setBackground(Color.WHITE);
            int n = Showcase.this.getTrace().getMaxSize();
            this.m_amountPointsSlider.setValue(n);
            this.m_amountPointsSlider.setMajorTickSpacing(40);
            this.m_amountPointsSlider.setMinorTickSpacing(20);
            this.m_amountPointsSlider.setSnapToTicks(true);
            this.m_amountPointsSlider.setPaintLabels(true);
            this.m_amountPointsSlider.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Amount of points.", 1, 3));
            this.m_amountPointsSlider.setPaintTicks(true);
            this.m_amountPointsSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    JSlider jSlider = (JSlider)changeEvent.getSource();
                    if (!jSlider.getValueIsAdjusting()) {
                        int n = jSlider.getValue();
                        Showcase.this.getTrace().setMaxSize(n);
                    }
                }
            });
        }

        private void createClearButton() {
            this.m_clear = new JButton("clear");
            this.m_clear.setBackground(Color.WHITE);
            this.m_clear.setBackground(Color.WHITE);
            this.m_clear.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Showcase.this.clearTrace();
                }
            });
        }

        private void createColorChooserButton() {
            this.m_colorChooser = new JComboBox();
            this.m_colorChooser.setBackground(Color.WHITE);
            final class ColorItem
            extends Color {
                private static final long serialVersionUID = 3257854281104568629L;
                private String m_name;

                public ColorItem(Color color, String string) {
                    super(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
                    this.m_name = string;
                }

                public String toString() {
                    return this.m_name;
                }
            }
            this.m_colorChooser.addItem(new ColorItem(Color.BLACK, "black"));
            this.m_colorChooser.addItem(new ColorItem(Color.BLUE, "blue"));
            this.m_colorChooser.addItem(new ColorItem(Color.CYAN, "cyan"));
            this.m_colorChooser.addItem(new ColorItem(Color.DARK_GRAY, "darg gray"));
            this.m_colorChooser.addItem(new ColorItem(Color.GRAY, "gray"));
            this.m_colorChooser.addItem(new ColorItem(Color.GREEN, "green"));
            this.m_colorChooser.addItem(new ColorItem(Color.LIGHT_GRAY, "light gray"));
            this.m_colorChooser.addItem(new ColorItem(Color.MAGENTA, "magenta"));
            this.m_colorChooser.addItem(new ColorItem(Color.ORANGE, "orange"));
            this.m_colorChooser.addItem(new ColorItem(Color.PINK, "pink"));
            this.m_colorChooser.addItem(new ColorItem(Color.RED, "red"));
            this.m_colorChooser.addItem(new ColorItem(Color.YELLOW, "yellow"));
            this.m_colorChooser.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Color color = (Color)((JComboBox)actionEvent.getSource()).getSelectedItem();
                    Showcase.this.getTrace().setColor(color);
                }
            });
            this.m_colorChooser.setSelectedIndex(10);
            this.m_colorChooser.setMaximumSize(new Dimension(200, this.m_clear.getMaximumSize().height));
        }

        private void createLatencySlider() {
            this.m_latencyTimeSlider = new JSlider(10, 210);
            this.m_latencyTimeSlider.setBackground(Color.WHITE);
            this.m_latencyTimeSlider.setValue((int)Showcase.this.getCollector().getLatency());
            this.m_latencyTimeSlider.setMajorTickSpacing(50);
            this.m_latencyTimeSlider.setMinorTickSpacing(10);
            this.m_latencyTimeSlider.setSnapToTicks(true);
            this.m_latencyTimeSlider.setPaintLabels(true);
            this.m_latencyTimeSlider.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Latency for adding points.", 1, 3));
            this.m_latencyTimeSlider.setPaintTicks(true);
            this.m_latencyTimeSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    JSlider jSlider = (JSlider)changeEvent.getSource();
                    if (!jSlider.getValueIsAdjusting()) {
                        int n = jSlider.getValue();
                        Showcase.this.getCollector().setLatency(n);
                    }
                }
            });
        }

        private void createSnapShotButton() {
            this.m_snapshot = new JButton(Chart2DActionSaveImageSingleton.getInstance(Showcase.this.m_chart, "Save image"));
            this.m_snapshot.setBackground(Color.WHITE);
        }

        private void createStartStopButton() {
            this.m_startStop = new JButton("start");
            this.m_startStop.setBackground(Color.WHITE);
            this.m_startStop.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JButton jButton = (JButton)actionEvent.getSource();
                    if (Showcase.this.getCollector().isRunning()) {
                        Showcase.this.stopData();
                        jButton.setText("start");
                    } else {
                        Showcase.this.startData();
                        jButton.setText("stop");
                    }
                    jButton.invalidate();
                    jButton.repaint();
                }
            });
        }
    }
}

