/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.demos;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.pointpainters.PointPainterDisc;
import info.monitorenter.gui.chart.traces.Trace2DSimple;
import info.monitorenter.gui.chart.views.ChartPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public final class MultitraceStaticChart
extends JPanel {
    private static final long serialVersionUID = 5364605038515831018L;

    public static void main(String[] stringArray) {
        for (int i = 0; i < 1; ++i) {
            JFrame jFrame = new JFrame("SampleChart");
            jFrame.getContentPane().add(new MultitraceStaticChart());
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            jFrame.setSize(600, 600);
            jFrame.setLocation(i % 3 * 200, i / 3 * 100);
            jFrame.setVisible(true);
        }
    }

    private MultitraceStaticChart() {
        int n;
        this.setLayout(new BorderLayout());
        Chart2D chart2D = new Chart2D();
        Trace2DSimple trace2DSimple = new Trace2DSimple();
        trace2DSimple.setColor(Color.RED);
        chart2D.addTrace(trace2DSimple);
        chart2D.setToolTipType(Chart2D.ToolTipType.VALUE_SNAP_TO_TRACEPOINTS);
        chart2D.enablePointHighlighting(true);
        trace2DSimple.setPointHighlighter(new PointPainterDisc(8));
        double d = System.currentTimeMillis();
        for (n = 0; n < 100; ++n) {
            trace2DSimple.addPoint(d + (double)n, (double)n * Math.random());
        }
        trace2DSimple = new Trace2DSimple();
        trace2DSimple.setColor(Color.BLUE);
        chart2D.addTrace(trace2DSimple);
        trace2DSimple.setPointHighlighter(new PointPainterDisc(8));
        for (n = 0; n < 100; ++n) {
            trace2DSimple.addPoint(d + (double)n, 200.0 - (double)n * Math.random());
        }
        this.add((Component)new ChartPanel(chart2D), "Center");
    }
}

