/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.demos;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.rangepolicies.RangePolicyMinimumViewport;
import info.monitorenter.gui.chart.traces.Trace2DSimple;
import info.monitorenter.gui.chart.views.ChartPanel;
import info.monitorenter.util.Range;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Random;
import javax.swing.JFrame;

public final class MultiTracing
extends JFrame {
    private static final long serialVersionUID = 3256722879394820657L;
    private static final int SLEEP = 100;
    protected Chart2D m_chart = new Chart2D();

    public static void main(String[] stringArray) {
        int n;
        double[][] dArray = new double[6][200];
        Random random = new Random();
        dArray[0][0] = random.nextDouble() * 5.0;
        for (int i = 1; i < dArray[0].length; ++i) {
            dArray[0][i] = random.nextDouble() < 0.5 ? dArray[0][i - 1] + random.nextDouble() * 5.0 : dArray[0][i - 1] - random.nextDouble() * 5.0;
        }
        for (n = 0; n < dArray[0].length; ++n) {
            double d;
            dArray[1][n] = d = Math.pow(Math.E, (double)n / 40.0) + (Math.random() < 0.5 ? dArray[0][n] : -dArray[0][n]);
        }
        for (n = 0; n < dArray[0].length; ++n) {
            dArray[2][n] = Math.pow(Math.cos((double)n / 10.0) * 5.0, 2.0);
        }
        dArray[3][0] = dArray[0][0];
        double d = 0.0;
        for (n = 1; n < dArray[0].length; ++n) {
            for (int i = Math.max(0, n - 10); i <= n; ++i) {
                d += dArray[0][i];
            }
            dArray[3][n] = d / ((double)n + 1.0);
            d = 0.0;
        }
        for (n = 0; n < dArray[0].length; ++n) {
            dArray[4][n] = dArray[1][n] + dArray[2][n] * (0.1 * -dArray[0][n]);
        }
        for (n = 0; n < dArray[0].length; ++n) {
            dArray[5][n] = dArray[0][n] + dArray[2][n];
        }
        MultiTracing multiTracing = new MultiTracing();
        multiTracing.setLocation(100, 300);
        multiTracing.setSize(800, 300);
        multiTracing.setResizable(true);
        multiTracing.setVisible(true);
        Trace2DSimple trace2DSimple = new Trace2DSimple();
        trace2DSimple.setColor(Color.red);
        new AddPaintRemoveThread(multiTracing.m_chart, trace2DSimple, dArray[0], 100L).start();
        trace2DSimple = new Trace2DSimple();
        trace2DSimple.setColor(Color.green);
        new AddPaintRemoveThread(multiTracing.m_chart, trace2DSimple, dArray[1], 150L).start();
        trace2DSimple = new Trace2DSimple();
        trace2DSimple.setColor(Color.blue);
        new AddPaintRemoveThread(multiTracing.m_chart, trace2DSimple, dArray[2], 200L).start();
        trace2DSimple = new Trace2DSimple();
        trace2DSimple.setColor(Color.cyan);
        new AddPaintRemoveThread(multiTracing.m_chart, trace2DSimple, dArray[3], 250L).start();
        trace2DSimple = new Trace2DSimple();
        trace2DSimple.setColor(Color.black);
        new AddPaintRemoveThread(multiTracing.m_chart, trace2DSimple, dArray[4], 300L).start();
        trace2DSimple = new Trace2DSimple();
        trace2DSimple.setColor(Color.white);
        new AddPaintRemoveThread(multiTracing.m_chart, trace2DSimple, dArray[5], 350L).start();
    }

    public MultiTracing() {
        super("MultiTracing");
        this.m_chart.getAxisX().setPaintGrid(true);
        this.m_chart.getAxisY().setPaintGrid(true);
        this.m_chart.setBackground(Color.lightGray);
        this.m_chart.setGridColor(new Color(221, 221, 221));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)new ChartPanel(this.m_chart), "Center");
    }

    public void setForceXRange(Range range) {
        this.m_chart.getAxisX().setRangePolicy(new RangePolicyMinimumViewport(range));
    }

    public void setForceYRange(Range range) {
        this.m_chart.getAxisY().setRangePolicy(new RangePolicyMinimumViewport(range));
    }

    static final class AddPaintRemoveThread
    extends Thread {
        private double[] m_data;
        private Chart2D m_innnerChart;
        private long m_sleep;
        private ITrace2D m_trace;

        public AddPaintRemoveThread(Chart2D chart2D, ITrace2D iTrace2D, double[] dArray, long l) {
            this.m_innnerChart = chart2D;
            this.m_trace = iTrace2D;
            this.m_trace.setName(this.getName());
            this.m_data = dArray;
            this.m_sleep = l;
        }

        public void run() {
            try {
                while (true) {
                    this.m_innnerChart.addTrace(this.m_trace);
                    for (int i = 0; i < this.m_data.length; ++i) {
                        this.m_trace.addPoint(i, this.m_data[i]);
                        try {
                            Thread.sleep(this.m_sleep);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace(System.err);
                        }
                    }
                    try {
                        Thread.sleep((long)(Math.random() * (double)this.m_sleep));
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace(System.err);
                    }
                    this.m_innnerChart.removeTrace(this.m_trace);
                    this.m_trace.removeAllPoints();
                    try {
                        Thread.sleep((long)(Math.random() * (double)this.m_sleep));
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace(System.err);
                    }
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(System.err);
                return;
            }
        }
    }
}

