/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.demos;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.ITracePoint2D;
import info.monitorenter.gui.chart.ITracePointProvider;
import info.monitorenter.gui.chart.axis.AxisLinear;
import info.monitorenter.gui.chart.traces.Trace2DSimple;
import info.monitorenter.gui.chart.views.ChartPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.JFrame;
import javax.swing.JPanel;

public final class MultiAxesStaticChart
extends JPanel {
    private static final long serialVersionUID = 3476998470009995195L;

    public static void main(String[] stringArray) {
        for (int i = 0; i < 1; ++i) {
            JFrame jFrame = new JFrame(MultiAxesStaticChart.class.getName());
            jFrame.getContentPane().add(new MultiAxesStaticChart());
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            jFrame.setSize(600, 600);
            jFrame.setLocation(i % 3 * 200, i / 3 * 100);
            jFrame.setVisible(true);
        }
    }

    private MultiAxesStaticChart() {
        ITracePoint2D iTracePoint2D;
        int n;
        this.setLayout(new BorderLayout());
        Chart2D chart2D = new Chart2D();
        chart2D.setToolTipType(Chart2D.ToolTipType.VALUE_SNAP_TO_TRACEPOINTS);
        ITracePointProvider iTracePointProvider = chart2D.getTracePointProvider();
        Trace2DSimple trace2DSimple = new Trace2DSimple();
        trace2DSimple.setColor(Color.RED);
        trace2DSimple.setName("Apples");
        Trace2DSimple trace2DSimple2 = new Trace2DSimple();
        trace2DSimple2.setColor(Color.BLUE);
        trace2DSimple2.setName("Pears");
        Trace2DSimple trace2DSimple3 = new Trace2DSimple();
        trace2DSimple3.setColor(Color.MAGENTA);
        trace2DSimple3.setName("Carrots");
        AxisLinear axisLinear = new AxisLinear();
        axisLinear.getAxisTitle().setTitle("Y-Apples");
        axisLinear.getAxisTitle().setTitleColor(Color.RED);
        AxisLinear axisLinear2 = new AxisLinear();
        axisLinear2.getAxisTitle().setTitle("Y-Pears");
        axisLinear2.getAxisTitle().setTitleColor(Color.BLUE);
        AxisLinear axisLinear3 = new AxisLinear();
        axisLinear3.getAxisTitle().setTitle("Y-Carrots");
        axisLinear3.getAxisTitle().setTitleColor(Color.MAGENTA);
        chart2D.setAxisYLeft(axisLinear, 0);
        chart2D.setAxisYRight(axisLinear2, 0);
        chart2D.addAxisYLeft(axisLinear3);
        AxisLinear axisLinear4 = new AxisLinear();
        axisLinear4.getAxisTitle().setTitle("X-Apples");
        axisLinear4.getAxisTitle().setTitleColor(Color.RED);
        AxisLinear axisLinear5 = new AxisLinear();
        axisLinear5.getAxisTitle().setTitle("X-Pears");
        axisLinear5.getAxisTitle().setTitleColor(Color.BLUE);
        AxisLinear axisLinear6 = new AxisLinear();
        axisLinear6.getAxisTitle().setTitle("X-Carrots");
        axisLinear6.getAxisTitle().setTitleColor(Color.MAGENTA);
        chart2D.setAxisXBottom(axisLinear4, 0);
        chart2D.setAxisXTop(axisLinear5, 0);
        chart2D.addAxisXBottom(axisLinear6);
        chart2D.addTrace(trace2DSimple, axisLinear4, axisLinear);
        chart2D.addTrace(trace2DSimple2, axisLinear5, axisLinear2);
        chart2D.addTrace(trace2DSimple3, axisLinear6, axisLinear3);
        double d = System.currentTimeMillis();
        for (n = 0; n < 120; ++n) {
            trace2DSimple.addPoint(iTracePointProvider.createTracePoint(d + (double)(n * 10000), (10.0 + Math.random()) * (double)n));
        }
        Iterator<ITracePoint2D> iterator = trace2DSimple.iterator();
        n = 0;
        while (iterator.hasNext()) {
            iTracePoint2D = iterator.next();
            trace2DSimple2.addPoint(iTracePointProvider.createTracePoint((double)n * 0.001, iTracePoint2D.getY() + Math.random() * 1000.0));
            ++n;
        }
        iterator = trace2DSimple.iterator();
        n = 0;
        while (iterator.hasNext()) {
            iTracePoint2D = iterator.next();
            trace2DSimple3.addPoint(iTracePointProvider.createTracePoint(n * 100, 100.0 - iTracePoint2D.getY()));
            ++n;
        }
        this.add((Component)new ChartPanel(chart2D), "Center");
    }
}

