/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.demos;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.ZoomableChart;
import info.monitorenter.gui.chart.axis.AxisLog10;
import info.monitorenter.gui.chart.labelformatters.LabelFormatterSimple;
import info.monitorenter.gui.chart.pointpainters.PointPainterDisc;
import info.monitorenter.gui.chart.traces.Trace2DSimple;
import info.monitorenter.gui.chart.traces.painters.TracePainterDisc;
import info.monitorenter.gui.chart.views.ChartPanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import javax.swing.JFrame;

public final class Log10AxisChartZoomable {
    public static void main(String[] stringArray) {
        ZoomableChart zoomableChart = new ZoomableChart();
        zoomableChart.setUseAntialiasing(true);
        zoomableChart.setToolTipType(Chart2D.ToolTipType.VALUE_SNAP_TO_TRACEPOINTS);
        zoomableChart.enablePointHighlighting(true);
        AxisLog10 axisLog10 = new AxisLog10();
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMaximumFractionDigits(100);
        zoomableChart.setAxisYLeft(axisLog10, 0);
        axisLog10.setFormatter(new LabelFormatterSimple());
        axisLog10.setPaintGrid(true);
        zoomableChart.getAxisX().setPaintGrid(true);
        Trace2DSimple trace2DSimple = new Trace2DSimple();
        zoomableChart.addTrace(trace2DSimple);
        trace2DSimple.addPointHighlighter(new PointPainterDisc(10));
        trace2DSimple.setTracePainter(new TracePainterDisc(4));
        trace2DSimple.setColor(Color.BLUE);
        trace2DSimple.setStroke(new BasicStroke(1.0f));
        for (double d = 1.0; d <= 10.0; d += 0.1) {
            trace2DSimple.addPoint(d, Math.pow(10.0, d));
        }
        JFrame jFrame = new JFrame(Log10AxisChartZoomable.class.getName());
        jFrame.getContentPane().add(new ChartPanel(zoomableChart));
        jFrame.setSize(400, 300);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.setVisible(true);
    }

    private Log10AxisChartZoomable() {
    }
}

