/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.demos;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.axis.AxisLog10;
import info.monitorenter.gui.chart.labelformatters.LabelFormatterAutoUnits;
import info.monitorenter.gui.chart.labelformatters.LabelFormatterNumber;
import info.monitorenter.gui.chart.traces.Trace2DSimple;
import info.monitorenter.gui.chart.traces.painters.TracePainterDisc;
import info.monitorenter.gui.chart.views.ChartPanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import javax.swing.JFrame;

public final class Log10AxisChart {
    public static void main(String[] stringArray) {
        Chart2D chart2D = new Chart2D();
        chart2D.setUseAntialiasing(true);
        AxisLog10 axisLog10 = new AxisLog10();
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMaximumFractionDigits(100);
        chart2D.setAxisYLeft(axisLog10, 0);
        axisLog10.setFormatter(new LabelFormatterAutoUnits(new LabelFormatterNumber(decimalFormat)));
        Trace2DSimple trace2DSimple = new Trace2DSimple();
        chart2D.addTrace(trace2DSimple);
        trace2DSimple.setTracePainter(new TracePainterDisc(4));
        trace2DSimple.setColor(Color.BLUE);
        trace2DSimple.setStroke(new BasicStroke(1.0f));
        for (double d = 1.0; d < 10.0; d += 0.1) {
            trace2DSimple.addPoint(d, Math.pow(10.0, d));
        }
        JFrame jFrame = new JFrame(Log10AxisChart.class.getName());
        jFrame.getContentPane().add(new ChartPanel(chart2D));
        jFrame.setSize(400, 300);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.setVisible(true);
    }

    private Log10AxisChart() {
    }
}

