/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.demos;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.controls.LayoutFactory;
import info.monitorenter.gui.chart.io.AStaticDataCollector;
import info.monitorenter.gui.chart.io.PropertyFileStaticDataCollector;
import info.monitorenter.gui.chart.pointpainters.PointPainterDisc;
import info.monitorenter.gui.chart.traces.Trace2DLtd;
import info.monitorenter.gui.chart.views.ChartCoordinateView;
import info.monitorenter.gui.chart.views.ChartPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JFrame;

public class CoordinateViewChart
extends JFrame {
    private static final long serialVersionUID = 1195707820931595997L;
    private Chart2D m_chart;

    public static void main(String[] stringArray) throws IOException {
        Chart2D chart2D = new Chart2D();
        chart2D.enablePointHighlighting(true);
        chart2D.setToolTipType(Chart2D.ToolTipType.VALUE_SNAP_TO_TRACEPOINTS);
        Trace2DLtd trace2DLtd = new Trace2DLtd(400);
        PropertyFileStaticDataCollector propertyFileStaticDataCollector = new PropertyFileStaticDataCollector(trace2DLtd, CoordinateViewChart.class.getResourceAsStream("data.properties"));
        chart2D.addTrace(trace2DLtd);
        trace2DLtd.setPointHighlighter(new PointPainterDisc(10));
        ((AStaticDataCollector)propertyFileStaticDataCollector).collectData();
        new CoordinateViewChart(chart2D);
    }

    public CoordinateViewChart(Chart2D chart2D) {
        super("View coordinates");
        this.m_chart = chart2D;
        ChartCoordinateView chartCoordinateView = new ChartCoordinateView(this.m_chart);
        new LayoutFactory.BasicPropertyAdaptSupport(chartCoordinateView, this.m_chart, LayoutFactory.BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance());
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        new LayoutFactory.BasicPropertyAdaptSupport(container, this.m_chart, LayoutFactory.BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets.bottom = 8;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 1;
        container.add((Component)new ChartPanel(this.m_chart), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 0;
        container.add((Component)chartCoordinateView, gridBagConstraints);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.setSize(new Dimension(400, 300));
        this.setVisible(true);
    }
}

