/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.demos;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.rangepolicies.RangePolicyMinimumViewport;
import info.monitorenter.gui.chart.traces.Trace2DLtd;
import info.monitorenter.gui.chart.traces.painters.TracePainterPolyline;
import info.monitorenter.gui.chart.views.ChartPanel;
import info.monitorenter.reflection.ObjRecorder2Trace2DAdapter;
import info.monitorenter.util.Range;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Random;
import javax.swing.JFrame;

public class AntialiasingChart
extends JFrame {
    private static final long serialVersionUID = 3545231432038627123L;
    protected Chart2D m_chart = null;

    public static void main(String[] stringArray) {
        Chart2D chart2D = new Chart2D();
        chart2D.setUseAntialiasing(true);
        chart2D.setMinPaintLatency(20);
        Trace2DLtd trace2DLtd = new Trace2DLtd(300);
        trace2DLtd.setStroke(new BasicStroke(3.0f));
        trace2DLtd.setColor(new Color(255, 0, 0, 255));
        trace2DLtd.setName("random");
        trace2DLtd.setPhysicalUnits("hertz", "ms");
        TracePainterPolyline tracePainterPolyline = new TracePainterPolyline();
        trace2DLtd.setTracePainter(tracePainterPolyline);
        chart2D.addTrace(trace2DLtd);
        AntialiasingChart antialiasingChart = new AntialiasingChart(chart2D, "AntialiasingChart");
        chart2D.getAxisX().setPaintGrid(true);
        chart2D.getAxisX().setStartMajorTick(false);
        chart2D.getAxisY().setPaintGrid(true);
        chart2D.getAxisX().setPaintScale(true);
        chart2D.getAxisX().setPaintScale(true);
        chart2D.getAxisY().setRangePolicy(new RangePolicyMinimumViewport(new Range(-10000.0, 10000.0)));
        antialiasingChart.setLocation(200, 300);
        antialiasingChart.setSize(700, 210);
        antialiasingChart.setResizable(true);
        antialiasingChart.setVisible(true);
        new ObjRecorder2Trace2DAdapter(trace2DLtd, new RandomBumper(0.5, 1000), "m_number", 1000L);
    }

    public AntialiasingChart(Chart2D chart2D, String string) {
        super(string);
        this.m_chart = chart2D;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AntialiasingChart.this.setVisible(false);
                AntialiasingChart.this.dispose();
                System.exit(0);
            }
        });
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)new ChartPanel(this.m_chart), "Center");
    }

    static class RandomBumper
    extends Thread {
        protected double m_factor;
        protected double m_number = 0.0;
        protected double m_plusminus = 0.5;
        protected Random m_randomizer = new Random();

        public RandomBumper(double d, int n) {
            if (d < 0.0 || d > 1.0) {
                System.out.println(this.getClass().getName() + " ignores constructor-passed value. Must be between 0.0 and 1.0!");
            } else {
                this.m_plusminus = d;
            }
            this.m_factor = n;
            this.setDaemon(true);
            this.start();
        }

        public void run() {
            while (true) {
                double d;
                this.m_number = (d = this.m_randomizer.nextDouble()) < this.m_plusminus ? (this.m_number += this.m_randomizer.nextDouble() * this.m_factor) : (this.m_number -= this.m_randomizer.nextDouble() * this.m_factor);
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

