/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.demos;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.IAxis;
import info.monitorenter.gui.chart.IPointPainter;
import info.monitorenter.gui.chart.axis.AxisLinear;
import info.monitorenter.gui.chart.labelformatters.LabelFormatterDate;
import info.monitorenter.gui.chart.pointpainters.PointPainterDisc;
import info.monitorenter.gui.chart.rangepolicies.RangePolicyFixedViewport;
import info.monitorenter.gui.chart.traces.Trace2DSimple;
import info.monitorenter.gui.chart.traces.painters.TracePainterVerticalBar;
import info.monitorenter.gui.chart.views.ChartPanel;
import info.monitorenter.util.Range;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.UIManager;

public final class AdvancedStaticChart {
    public static void main(String[] stringArray) throws ParseException {
        Chart2D chart2D = new Chart2D();
        IAxis<?> iAxis = chart2D.getAxisX();
        IAxis<?> iAxis2 = chart2D.getAxisY();
        chart2D.setGridColor(Color.LIGHT_GRAY);
        iAxis.setPaintGrid(true);
        iAxis2.setPaintGrid(true);
        Trace2DSimple trace2DSimple = new Trace2DSimple();
        chart2D.addTrace(trace2DSimple);
        trace2DSimple.setTracePainter(new TracePainterVerticalBar(4, chart2D));
        trace2DSimple.setColor(Color.ORANGE);
        Font font = UIManager.getDefaults().getFont("Label.font").deriveFont(14.0f).deriveFont(1);
        IAxis.AxisTitle axisTitle = iAxis2.getAxisTitle();
        axisTitle.setTitleFont(font);
        axisTitle.setTitle("hoppelhase");
        iAxis2.setFormatter(new LabelFormatterDate(new SimpleDateFormat()));
        axisTitle = iAxis.getAxisTitle();
        axisTitle.setTitle("emil");
        axisTitle.setTitleFont(font);
        iAxis.setRangePolicy(new RangePolicyFixedViewport(new Range(0.0, 220.0)));
        chart2D.setToolTipType(Chart2D.ToolTipType.VALUE_SNAP_TO_TRACEPOINTS);
        Set<IPointPainter<?>> set = trace2DSimple.getPointHighlighters();
        set.clear();
        trace2DSimple.addPointHighlighter(new PointPainterDisc(20));
        chart2D.enablePointHighlighting(true);
        double d = System.currentTimeMillis();
        for (double d2 = 0.0; d2 < 20.0; d2 += 1.0) {
            trace2DSimple.addPoint(d2 * 10.0, d);
            d += 50000.0;
        }
        AxisLinear axisLinear = new AxisLinear(new LabelFormatterDate(new SimpleDateFormat("")));
        axisLinear.setPaintScale(false);
        AxisLinear axisLinear2 = new AxisLinear(new LabelFormatterDate(new SimpleDateFormat("")));
        axisLinear2.setPaintScale(false);
        chart2D.setAxisXTop(axisLinear, 0);
        chart2D.setAxisYRight(axisLinear2, 0);
        JFrame jFrame = new JFrame("AdvancedStaticChart");
        jFrame.getContentPane().add(new ChartPanel(chart2D));
        jFrame.setSize(600, 600);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.setVisible(true);
    }

    private AdvancedStaticChart() {
    }
}

