/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.demos;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.axis.AxisLinear;
import info.monitorenter.gui.chart.io.RandomDataCollectorTimeStamped;
import info.monitorenter.gui.chart.labelformatters.LabelFormatterDate;
import info.monitorenter.gui.chart.labelformatters.LabelFormatterNumber;
import info.monitorenter.gui.chart.rangepolicies.RangePolicyMinimumViewport;
import info.monitorenter.gui.chart.traces.Trace2DAxisSwap;
import info.monitorenter.gui.chart.traces.Trace2DLtd;
import info.monitorenter.gui.chart.views.ChartPanel;
import info.monitorenter.util.Range;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import javax.swing.JFrame;

public final class AdvancedDynamicChart {
    public static void main(String[] stringArray) {
        Chart2D chart2D = new Chart2D();
        AxisLinear axisLinear = new AxisLinear();
        AxisLinear axisLinear2 = new AxisLinear();
        axisLinear.setFormatter(new LabelFormatterDate(new SimpleDateFormat("HH:mm:ss")));
        chart2D.setAxisYLeft(axisLinear, 0);
        DecimalFormat decimalFormat = new DecimalFormat("#");
        ((NumberFormat)decimalFormat).setMaximumIntegerDigits(3);
        axisLinear2.setFormatter(new LabelFormatterNumber(decimalFormat));
        chart2D.setAxisXBottom(axisLinear2, 0);
        axisLinear2.setRangePolicy(new RangePolicyMinimumViewport(new Range(-10.0, 10.0)));
        Trace2DLtd trace2DLtd = new Trace2DLtd(400);
        trace2DLtd.setColor(Color.RED);
        BasicStroke basicStroke = new BasicStroke(1.0f, 0, 1, 10.0f, new float[]{15.0f, 10.0f}, 5.0f);
        trace2DLtd.setStroke(basicStroke);
        chart2D.addTrace(trace2DLtd);
        JFrame jFrame = new JFrame("AdvancedDynamicChart");
        jFrame.getContentPane().add(new ChartPanel(chart2D));
        jFrame.setSize(400, 300);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.setVisible(true);
        RandomDataCollectorTimeStamped randomDataCollectorTimeStamped = new RandomDataCollectorTimeStamped((ITrace2D)new Trace2DAxisSwap(trace2DLtd), 50);
        randomDataCollectorTimeStamped.start();
    }

    private AdvancedDynamicChart() {
    }
}

