/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.controls.errorbarwizard;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.IErrorBarPolicy;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.controls.errorbarwizard.ErrorBarPolicyPanel;
import info.monitorenter.gui.chart.errorbars.ErrorBarPainter;
import info.monitorenter.gui.chart.errorbars.ErrorBarPolicyRelative;
import info.monitorenter.gui.chart.pointpainters.PointPainterDisc;
import info.monitorenter.gui.chart.pointpainters.PointPainterLine;
import info.monitorenter.gui.chart.traces.Trace2DSimple;
import info.monitorenter.util.FileUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class ErrorBarWizard
extends JPanel {
    private static final long serialVersionUID = 6973894101328190445L;

    public static void main(String[] stringArray) {
        Chart2D chart2D = new Chart2D();
        Trace2DSimple trace2DSimple = new Trace2DSimple();
        trace2DSimple.setColor(Color.RED);
        ErrorBarPolicyRelative errorBarPolicyRelative = new ErrorBarPolicyRelative(0.2, 0.2);
        errorBarPolicyRelative.setShowNegativeYErrors(true);
        errorBarPolicyRelative.setShowPositiveYErrors(true);
        trace2DSimple.setErrorBarPolicy(errorBarPolicyRelative);
        ErrorBarPainter errorBarPainter = new ErrorBarPainter();
        errorBarPainter.setEndPointPainter(new PointPainterDisc());
        errorBarPainter.setEndPointColor(Color.RED);
        errorBarPainter.setConnectionPainter(new PointPainterLine());
        errorBarPainter.setConnectionColor(Color.GREEN);
        errorBarPolicyRelative.setErrorBarPainter(errorBarPainter);
        for (double d = 2.0; d < 40.0; d += 1.0) {
            trace2DSimple.addPoint(d, Math.random() * d + d * 10.0);
        }
        chart2D.addTrace(trace2DSimple);
        ErrorBarWizard errorBarWizard = new ErrorBarWizard(trace2DSimple);
        JFrame jFrame = new JFrame(ErrorBarWizard.class.getName());
        jFrame.getContentPane().add(errorBarWizard);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.setVisible(true);
    }

    public ErrorBarWizard(ITrace2D iTrace2D) {
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        for (IErrorBarPolicy<?> iErrorBarPolicy : iTrace2D.getErrorBarPolicies()) {
            String string = FileUtil.cutExtension(iErrorBarPolicy.getClass().getName()).getValue();
            jTabbedPane.addTab(string, null, new ErrorBarPolicyPanel(iErrorBarPolicy), "Does nothing");
        }
        this.setLayout(new BorderLayout());
        this.add(jTabbedPane);
    }
}

