/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.controls.errorbarwizard;

import info.monitorenter.gui.chart.IErrorBarPainter;
import info.monitorenter.gui.chart.IErrorBarPolicy;
import info.monitorenter.gui.chart.events.ErrorBarPainterActionEdit;
import info.monitorenter.gui.chart.events.ErrorBarPolicyActionAddPainter;
import info.monitorenter.gui.chart.events.ErrorBarPolicyActionRemovePainter;
import info.monitorenter.util.FileUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorBarPaintersPanel
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = 2293007395124251482L;
    private JButton m_addButton;

    public ErrorBarPaintersPanel(IErrorBarPolicy<?> iErrorBarPolicy) {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        for (IErrorBarPainter iErrorBarPainter : iErrorBarPolicy.getErrorBarPainters()) {
            this.add((Component)new ErrorBarPainterConfigurablePanel(iErrorBarPainter, iErrorBarPolicy), gridBagConstraints);
            ++gridBagConstraints.gridy;
        }
        this.m_addButton = new JButton(new ErrorBarPolicyActionAddPainter(iErrorBarPolicy, "Add"));
        this.add((Component)this.m_addButton, gridBagConstraints);
        iErrorBarPolicy.addPropertyChangeListener("IErrorBarPolicy.PROPERTY_ERRORBARPAINTER", this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("IErrorBarPolicy.PROPERTY_ERRORBARPAINTER".equals(string)) {
            IErrorBarPainter iErrorBarPainter = (IErrorBarPainter)propertyChangeEvent.getOldValue();
            IErrorBarPainter iErrorBarPainter2 = (IErrorBarPainter)propertyChangeEvent.getNewValue();
            if (iErrorBarPainter == null) {
                IErrorBarPolicy iErrorBarPolicy = (IErrorBarPolicy)propertyChangeEvent.getSource();
                GridBagLayout gridBagLayout = (GridBagLayout)this.getLayout();
                GridBagConstraints gridBagConstraints = gridBagLayout.getConstraints(this.m_addButton);
                ++gridBagConstraints.gridy;
                gridBagLayout.setConstraints(this.m_addButton, gridBagConstraints);
                --gridBagConstraints.gridy;
                this.add((Component)new ErrorBarPainterConfigurablePanel(iErrorBarPainter2, iErrorBarPolicy), gridBagConstraints);
                Container container = this.getParent();
                if (container != null) {
                    ((Component)container).invalidate();
                    ((Component)container).validate();
                    container.repaint(400L);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ErrorBarPainterConfigurablePanel
    extends JPanel
    implements PropertyChangeListener {
        private static final long serialVersionUID = 1055140441129248409L;
        private IErrorBarPainter m_errorBarPainter;

        public ErrorBarPainterConfigurablePanel(IErrorBarPainter iErrorBarPainter, IErrorBarPolicy<?> iErrorBarPolicy) {
            this.m_errorBarPainter = iErrorBarPainter;
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            String string = FileUtil.cutExtension(iErrorBarPainter.getClass().getName()).getValue();
            JButton jButton = new JButton(new ErrorBarPainterActionEdit(iErrorBarPainter, "Edit", this));
            this.add((Component)new JLabel(string), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            this.add((Component)jButton, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            JButton jButton2 = new JButton(new ErrorBarPolicyActionRemovePainter(iErrorBarPolicy, "Remove", iErrorBarPainter));
            this.add((Component)jButton2, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            iErrorBarPolicy.addPropertyChangeListener("IErrorBarPolicy.PROPERTY_ERRORBARPAINTER", this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("IErrorBarPolicy.PROPERTY_ERRORBARPAINTER".equals(string)) {
                IErrorBarPolicy iErrorBarPolicy = (IErrorBarPolicy)propertyChangeEvent.getSource();
                IErrorBarPainter iErrorBarPainter = (IErrorBarPainter)propertyChangeEvent.getOldValue();
                IErrorBarPainter iErrorBarPainter2 = (IErrorBarPainter)propertyChangeEvent.getNewValue();
                if (iErrorBarPainter == this.m_errorBarPainter && iErrorBarPainter2 == null) {
                    Container container = this.getParent();
                    ErrorBarPaintersPanel.this.remove(this);
                    iErrorBarPolicy.removePropertyChangeListener("IErrorBarPolicy.PROPERTY_ERRORBARPAINTER", this);
                    if (container != null && (container = container.getParent()) != null) {
                        ((Component)container).invalidate();
                        ((Component)container).validate();
                        container.repaint(500L);
                    }
                }
            }
        }
    }
}

