/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.controls.errorbarwizard;

import info.monitorenter.gui.chart.IErrorBarPainter;
import info.monitorenter.gui.chart.IPointPainterConfigurableUI;
import info.monitorenter.gui.chart.events.ErrorBarPainterActionSetSegmentColor;
import info.monitorenter.gui.chart.events.ErrorBarPainterActionSetSegmentPainter;
import info.monitorenter.gui.chart.pointpainters.APointPainter;
import info.monitorenter.gui.chart.pointpainters.PointPainterDisc;
import info.monitorenter.gui.chart.pointpainters.PointPainterLine;
import info.monitorenter.gui.util.ColorIcon;
import info.monitorenter.util.FileUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class ErrorBarPainterEditPanel
extends JPanel {
    private static final long serialVersionUID = -6564631494967160532L;
    private IErrorBarPainter m_errorBarPainter;

    public ErrorBarPainterEditPanel(IErrorBarPainter iErrorBarPainter) {
        this.m_errorBarPainter = iErrorBarPainter;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)new SegmentChooserPanel(this.m_errorBarPainter.getSegmentStart()), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.add((Component)new SegmentChooserPanel(this.m_errorBarPainter.getSegmentConnection()), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.add((Component)new SegmentChooserPanel(this.m_errorBarPainter.getSegmentEnd()), gridBagConstraints);
    }

    private class SegmentChooserPanel
    extends JPanel {
        private static final long serialVersionUID = 6645527616687209066L;
        protected IErrorBarPainter.ISegment m_segment;

        public SegmentChooserPanel(IErrorBarPainter.ISegment iSegment) {
            this.m_segment = iSegment;
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), iSegment.getName(), 1, 0));
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.gridx = 0;
            final ErrorBarPainterActionSetSegmentColor errorBarPainterActionSetSegmentColor = new ErrorBarPainterActionSetSegmentColor(iSegment, this, "color");
            JComboBox<ErrorBarPainterActionSetSegmentPainter> jComboBox = new JComboBox<ErrorBarPainterActionSetSegmentPainter>();
            IPointPainterConfigurableUI<?> iPointPainterConfigurableUI = iSegment.getPointPainter();
            APointPainter aPointPainter = null;
            boolean bl = false;
            ErrorBarPainterActionSetSegmentPainter errorBarPainterActionSetSegmentPainter = new ErrorBarPainterActionSetSegmentPainter(iSegment, aPointPainter, "Empty");
            jComboBox.addItem(errorBarPainterActionSetSegmentPainter);
            if (iPointPainterConfigurableUI == null) {
                jComboBox.setSelectedItem(errorBarPainterActionSetSegmentPainter);
            }
            aPointPainter = new PointPainterLine();
            errorBarPainterActionSetSegmentPainter = new ErrorBarPainterActionSetSegmentPainter(iSegment, aPointPainter, FileUtil.cutExtension(aPointPainter.getClass().getName()).getValue());
            jComboBox.addItem(errorBarPainterActionSetSegmentPainter);
            if (iPointPainterConfigurableUI != null && aPointPainter.getClass().equals(iPointPainterConfigurableUI.getClass())) {
                jComboBox.setSelectedItem(errorBarPainterActionSetSegmentPainter);
                bl = true;
            }
            aPointPainter = new PointPainterDisc();
            errorBarPainterActionSetSegmentPainter = new ErrorBarPainterActionSetSegmentPainter(iSegment, aPointPainter, FileUtil.cutExtension(aPointPainter.getClass().getName()).getValue());
            jComboBox.addItem(errorBarPainterActionSetSegmentPainter);
            if (iPointPainterConfigurableUI != null && aPointPainter.getClass().equals(iPointPainterConfigurableUI.getClass())) {
                jComboBox.setSelectedItem(errorBarPainterActionSetSegmentPainter);
                bl = true;
            }
            jComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                    Action action = (Action)jComboBox.getSelectedItem();
                    action.actionPerformed(actionEvent);
                    if (action.getValue("Name").equals("Empty")) {
                        errorBarPainterActionSetSegmentColor.setEnabled(false);
                    } else {
                        errorBarPainterActionSetSegmentColor.setEnabled(true);
                    }
                }
            });
            this.add(jComboBox, gridBagConstraints);
            ColorIcon colorIcon = new ColorIcon(iSegment.getColor());
            errorBarPainterActionSetSegmentColor.putValue("SmallIcon", colorIcon);
            errorBarPainterActionSetSegmentColor.setEnabled(bl);
            JButton jButton = new JButton(errorBarPainterActionSetSegmentColor);
            gridBagConstraints.gridy = 1;
            iSegment.addPropertyChangeListener(iSegment.getPropertySegmentColor(), new ColorIconUpdater(colorIcon));
            this.add((Component)jButton, gridBagConstraints);
        }

        final class ColorIconUpdater
        implements PropertyChangeListener {
            private ColorIcon m_adaptee;

            protected ColorIconUpdater(ColorIcon colorIcon) {
                this.m_adaptee = colorIcon;
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (SegmentChooserPanel.this.m_segment.getPropertySegmentColor().equals(string)) {
                    this.m_adaptee.setColor((Color)propertyChangeEvent.getNewValue());
                }
            }
        }
    }
}

