/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.controls;

import com.jidesoft.swing.RangeSlider;
import info.monitorenter.util.Range;
import info.monitorenter.util.math.MathUtil;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RangeChooserPanel
extends JPanel {
    private static final long serialVersionUID = 3258413911148410931L;
    protected RangeSlider m_rangeSlider;
    protected NumberFormat m_nf = NumberFormat.getNumberInstance(Locale.getDefault());

    public RangeChooserPanel(Range range) {
        this.m_nf.setMinimumFractionDigits(2);
        this.m_nf.setMaximumFractionDigits(2);
        int n = (int)range.getMin();
        int n2 = (int)range.getMax();
        if (!MathUtil.isDouble(n) || (double)n == -1.7976931348623157E308) {
            n = -100;
        }
        if (!MathUtil.isDouble(n2) || (double)n2 == Double.MAX_VALUE) {
            n2 = 100;
        }
        int n3 = n - (n2 - n) / 2;
        int n4 = n2 + (n2 - n) / 2;
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
        this.m_rangeSlider = new RangeSlider();
        this.m_rangeSlider.setMinimum(n3);
        this.m_rangeSlider.setMaximum(n4);
        this.m_rangeSlider.setHighValue(n2);
        this.m_rangeSlider.setLowValue(n);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.add(this.m_rangeSlider);
        this.add(jPanel);
        this.add(Box.createVerticalStrut(10));
        final JTextField jTextField = new JTextField();
        jTextField.setText(this.m_nf.format(new Double(this.m_rangeSlider.getLowValue())));
        jTextField.setEditable(true);
        jTextField.setPreferredSize(new Dimension(120, 20));
        jTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTextField jTextField = (JTextField)actionEvent.getSource();
                try {
                    Number number = RangeChooserPanel.this.m_nf.parse(jTextField.getText());
                    int n = number.intValue();
                    int n2 = RangeChooserPanel.this.m_rangeSlider.getHighValue();
                    int n3 = n - (n2 - n) / 2;
                    RangeChooserPanel.this.m_rangeSlider.setMinimum(n3);
                    RangeChooserPanel.this.m_rangeSlider.setLowValue(n);
                }
                catch (ParseException parseException) {
                    jTextField.setText(RangeChooserPanel.this.m_nf.format(RangeChooserPanel.this.m_rangeSlider.getMinimum()));
                    parseException.printStackTrace();
                }
            }
        });
        jTextField.setToolTipText("Enter a number and hit Return.");
        final JTextField jTextField2 = new JTextField();
        jTextField2.setText(new Double(this.m_rangeSlider.getHighValue()).toString());
        jTextField2.setEditable(true);
        jTextField2.setPreferredSize(new Dimension(120, 20));
        jTextField2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTextField jTextField = (JTextField)actionEvent.getSource();
                try {
                    Number number = RangeChooserPanel.this.m_nf.parse(jTextField.getText());
                    int n = number.intValue();
                    int n2 = RangeChooserPanel.this.m_rangeSlider.getLowValue();
                    int n3 = (n - n2) / 2;
                    RangeChooserPanel.this.m_rangeSlider.setMaximum(n3);
                    RangeChooserPanel.this.m_rangeSlider.setHighValue(n);
                }
                catch (ParseException parseException) {
                    jTextField.setText(RangeChooserPanel.this.m_nf.format(RangeChooserPanel.this.m_rangeSlider.getMaximum()));
                    parseException.printStackTrace();
                }
            }
        });
        jTextField2.setToolTipText("Enter a number and hit Return.");
        this.m_rangeSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                RangeSlider rangeSlider = (RangeSlider)changeEvent.getSource();
                int n = rangeSlider.getLowValue();
                String string = RangeChooserPanel.this.m_nf.format(n);
                jTextField.setText(string);
                n = rangeSlider.getHighValue();
                string = RangeChooserPanel.this.m_nf.format(n);
                jTextField2.setText(string);
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setMaximumSize(new Dimension(300, 30));
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(jTextField);
        jPanel2.add(Box.createHorizontalStrut(10));
        jPanel2.add(jTextField2);
        jPanel2.add(Box.createHorizontalGlue());
        this.add(Box.createVerticalStrut(10));
        this.add(jPanel2);
        this.add(Box.createVerticalGlue());
    }

    public Range getRange() {
        return new Range(this.m_rangeSlider.getLowValue(), this.m_rangeSlider.getHighValue());
    }
}

