/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.controls;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.IAxis;
import info.monitorenter.gui.chart.IAxisLabelFormatter;
import info.monitorenter.gui.chart.IErrorBarPolicy;
import info.monitorenter.gui.chart.IPointPainter;
import info.monitorenter.gui.chart.IToolTipType;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.ZoomableChart;
import info.monitorenter.gui.chart.axis.AxisLinear;
import info.monitorenter.gui.chart.axis.AxisLog10;
import info.monitorenter.gui.chart.axis.AxisLogE;
import info.monitorenter.gui.chart.errorbars.AErrorBarPolicyConfigurable;
import info.monitorenter.gui.chart.errorbars.ErrorBarPolicyAbsoluteSummation;
import info.monitorenter.gui.chart.errorbars.ErrorBarPolicyRelative;
import info.monitorenter.gui.chart.events.AxisActionSetFormatter;
import info.monitorenter.gui.chart.events.AxisActionSetGrid;
import info.monitorenter.gui.chart.events.AxisActionSetRange;
import info.monitorenter.gui.chart.events.AxisActionSetRangePolicy;
import info.monitorenter.gui.chart.events.AxisActionSetTitle;
import info.monitorenter.gui.chart.events.AxisActionSetTitleFont;
import info.monitorenter.gui.chart.events.Chart2DActionEnableAntialiasing;
import info.monitorenter.gui.chart.events.Chart2DActionEnableHighlighting;
import info.monitorenter.gui.chart.events.Chart2DActionPrintSingleton;
import info.monitorenter.gui.chart.events.Chart2DActionSaveEpsSingletonApacheFop;
import info.monitorenter.gui.chart.events.Chart2DActionSaveImageSingleton;
import info.monitorenter.gui.chart.events.Chart2DActionSetAxis;
import info.monitorenter.gui.chart.events.Chart2DActionSetCustomGridColorSingleton;
import info.monitorenter.gui.chart.events.Chart2DActionSetGridColor;
import info.monitorenter.gui.chart.events.ChartActionSetToolTipType;
import info.monitorenter.gui.chart.events.ChartPanelActionAddAnnotation;
import info.monitorenter.gui.chart.events.ErrorBarPolicyMultiAction;
import info.monitorenter.gui.chart.events.JComponentActionSetBackground;
import info.monitorenter.gui.chart.events.JComponentActionSetCustomBackgroundSingleton;
import info.monitorenter.gui.chart.events.JComponentActionSetCustomForegroundSingleton;
import info.monitorenter.gui.chart.events.JComponentActionSetForeground;
import info.monitorenter.gui.chart.events.PopupListener;
import info.monitorenter.gui.chart.events.Trace2DActionAddRemoveHighlighter;
import info.monitorenter.gui.chart.events.Trace2DActionAddRemoveTracePainter;
import info.monitorenter.gui.chart.events.Trace2DActionRemove;
import info.monitorenter.gui.chart.events.Trace2DActionSetColor;
import info.monitorenter.gui.chart.events.Trace2DActionSetCustomColor;
import info.monitorenter.gui.chart.events.Trace2DActionSetName;
import info.monitorenter.gui.chart.events.Trace2DActionSetPhysicalUnits;
import info.monitorenter.gui.chart.events.Trace2DActionSetStroke;
import info.monitorenter.gui.chart.events.Trace2DActionSetVisible;
import info.monitorenter.gui.chart.events.Trace2DActionSetZindex;
import info.monitorenter.gui.chart.events.Trace2DActionZindexDecrease;
import info.monitorenter.gui.chart.events.Trace2DActionZindexIncrease;
import info.monitorenter.gui.chart.events.ZoomableChartZoomOutAction;
import info.monitorenter.gui.chart.labelformatters.ALabelFormatter;
import info.monitorenter.gui.chart.labelformatters.LabelFormatterAutoUnits;
import info.monitorenter.gui.chart.labelformatters.LabelFormatterDate;
import info.monitorenter.gui.chart.labelformatters.LabelFormatterNumber;
import info.monitorenter.gui.chart.pointpainters.PointPainterDisc;
import info.monitorenter.gui.chart.rangepolicies.RangePolicyFixedViewport;
import info.monitorenter.gui.chart.rangepolicies.RangePolicyForcedPoint;
import info.monitorenter.gui.chart.rangepolicies.RangePolicyHighestValues;
import info.monitorenter.gui.chart.rangepolicies.RangePolicyMinimumViewport;
import info.monitorenter.gui.chart.rangepolicies.RangePolicyUnbounded;
import info.monitorenter.gui.chart.traces.painters.ATracePainter;
import info.monitorenter.gui.chart.traces.painters.TracePainterDisc;
import info.monitorenter.gui.chart.traces.painters.TracePainterFill;
import info.monitorenter.gui.chart.traces.painters.TracePainterPolyline;
import info.monitorenter.gui.chart.traces.painters.TracePainterVerticalBar;
import info.monitorenter.gui.chart.views.ChartPanel;
import info.monitorenter.util.Range;
import info.monitorenter.util.StringUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LayoutFactory {
    private static LayoutFactory instance;
    private boolean m_showAnnotationMenu = false;
    private boolean m_showAntialiasingMenu = true;
    private boolean m_showAxisFormatterMenu = true;
    private boolean m_showAxisXGridMenu = true;
    private boolean m_showAxisXMenu = true;
    private boolean m_showAxisXRangePolicyMenu = true;
    private boolean m_showAxisXTitleMenu = true;
    private boolean m_showAxisXTypeMenu = true;
    private boolean m_showAxisYGridMenu = true;
    private boolean m_showAxisYMenu = true;
    private boolean m_showAxisYRangePolicyMenu = true;
    private boolean m_showAxisYTitleMenu = true;
    private boolean m_showAxisYTypeMenu = true;
    private boolean m_showChartBackgroundMenu = true;
    private boolean m_showChartForegroundMenu = true;
    private boolean m_showChartHighlighterMenu = true;
    private boolean m_showErrorBarWizardMenu = true;
    private boolean m_showGridColorMenu = true;
    private boolean m_showGridMenu = true;
    private boolean m_showHighlightMenu = true;
    private boolean m_showPhysicalUnitsMenu = true;
    private boolean m_showPrintMenu = true;
    private boolean m_showRemoveTraceMenu = false;
    private boolean m_showSaveEpsMenu = true;
    private boolean m_showSaveMenu = true;
    private boolean m_showToolTipMenu = true;
    private boolean m_showToolTipTypeMenu = true;
    private boolean m_showTraceColorMenu = true;
    private boolean m_showTraceHighlighterMenu = true;
    private boolean m_showTraceNameMenu = true;
    private boolean m_showTracePainterMenu = true;
    private boolean m_showTraceStrokeMenu = true;
    private boolean m_showTraceVisibleMenu = true;
    private boolean m_showTraceZindexMenu = true;
    private boolean m_showZoomOutMenu = true;
    private String[] m_strokeNames;
    private Stroke[] m_strokes = new Stroke[6];

    public static LayoutFactory getInstance() {
        if (instance == null) {
            instance = new LayoutFactory();
        }
        return instance;
    }

    private static Font[] getSystemFonts(float f) {
        Font[] fontArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        for (int i = fontArray.length - 1; i > -1; --i) {
            fontArray[i] = fontArray[i].deriveFont(f);
        }
        return fontArray;
    }

    private LayoutFactory() {
        this.m_strokeNames = new String[6];
        this.m_strokes[0] = new BasicStroke();
        this.m_strokeNames[0] = "basic";
        this.m_strokes[1] = new BasicStroke(2.0f);
        this.m_strokeNames[1] = "thick";
        this.m_strokes[2] = new BasicStroke(6.0f, 1, 1, 10.0f, new float[]{0.0f, 10.0f}, 0.0f);
        this.m_strokeNames[2] = "round caps";
        this.m_strokes[3] = new BasicStroke(1.0f, 0, 0, 1.5f, new float[]{5.0f, 5.0f}, 2.5f);
        this.m_strokeNames[3] = "dashed";
        this.m_strokes[4] = new BasicStroke(6.0f, 2, 1, 10.0f, new float[]{0.0f, 10.0f}, 0.0f);
        this.m_strokeNames[4] = "square caps";
        this.m_strokes[5] = new BasicStroke(3.0f, 0, 2, 1.5f, new float[]{10.0f, 2.0f}, 1.0f);
        this.m_strokeNames[5] = "dashed thick";
    }

    public JMenu createAnnoationsMenu(ChartPanel chartPanel, boolean bl) {
        JMenu jMenu;
        Chart2D chart2D = chartPanel.getChart();
        if (bl) {
            jMenu = new PropertyChangeMenu(chart2D, "Annotate", BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance());
            PropertyChangeMenuItem propertyChangeMenuItem = new PropertyChangeMenuItem(chart2D, new ChartPanelActionAddAnnotation(chartPanel, "Annotation 1"), BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance());
            jMenu.add(propertyChangeMenuItem);
        } else {
            jMenu = new JMenu("Annotate");
            JMenuItem jMenuItem = new JMenuItem(new ChartPanelActionAddAnnotation(chartPanel, "Annotation 1"));
            jMenu.add(jMenuItem);
        }
        return jMenu;
    }

    private Component createAxisFormatterMenu(Chart2D chart2D, IAxis<?> iAxis, int n, boolean bl) {
        IAxisLabelFormatter iAxisLabelFormatter = iAxis.getFormatter();
        ButtonGroup buttonGroup = new ButtonGroup();
        JMenu jMenu = bl ? new PropertyChangeMenu(chart2D, "Label formatter", BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenu("Label formatter");
        JMenu jMenu2 = bl ? new PropertyChangeMenu(chart2D, "Numbers", BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenu("Numbers");
        jMenu.add(jMenu2);
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        ALabelFormatter aLabelFormatter = new LabelFormatterNumber(numberFormat);
        AxisActionSetFormatter axisActionSetFormatter = new AxisActionSetFormatter(chart2D, "Whole numbers", n, aLabelFormatter);
        boolean bl2 = ((Object)aLabelFormatter).equals(iAxisLabelFormatter);
        JRadioButtonMenuItem jRadioButtonMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chart2D, axisActionSetFormatter, bl2, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(axisActionSetFormatter, bl2);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu2.add(jRadioButtonMenuItem);
        numberFormat = new DecimalFormat("#.#");
        aLabelFormatter = new LabelFormatterNumber(numberFormat);
        axisActionSetFormatter = new AxisActionSetFormatter(chart2D, "1 fraction digit", n, aLabelFormatter);
        bl2 = ((Object)aLabelFormatter).equals(iAxisLabelFormatter);
        jRadioButtonMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chart2D, axisActionSetFormatter, bl2, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(axisActionSetFormatter, bl2);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu2.add(jRadioButtonMenuItem);
        numberFormat = new DecimalFormat("#.##");
        aLabelFormatter = new LabelFormatterNumber(numberFormat);
        axisActionSetFormatter = new AxisActionSetFormatter(chart2D, "2 fraction digits", n, aLabelFormatter);
        bl2 = ((Object)aLabelFormatter).equals(iAxisLabelFormatter);
        jRadioButtonMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chart2D, axisActionSetFormatter, bl2, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(axisActionSetFormatter, bl2);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu2.add(jRadioButtonMenuItem);
        JMenu jMenu3 = bl ? new PropertyChangeMenu(chart2D, "Date/Time", BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenu("Date/Time");
        jMenu.add(jMenu3);
        String string = "This works only if your values are milliseconds since January 1st 1970 (System.currentTimeMillis()).";
        jMenu3.setToolTipText(string);
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateInstance(3);
        aLabelFormatter = new LabelFormatterDate(simpleDateFormat);
        axisActionSetFormatter = new AxisActionSetFormatter(chart2D, "Date (short)", n, aLabelFormatter);
        bl2 = ((Object)aLabelFormatter).equals(iAxisLabelFormatter);
        jRadioButtonMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chart2D, axisActionSetFormatter, bl2, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(axisActionSetFormatter, bl2);
        jRadioButtonMenuItem.setToolTipText(string);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu3.add(jRadioButtonMenuItem);
        simpleDateFormat = (SimpleDateFormat)DateFormat.getDateInstance(2);
        aLabelFormatter = new LabelFormatterDate(simpleDateFormat);
        axisActionSetFormatter = new AxisActionSetFormatter(chart2D, "Date (medium)", n, aLabelFormatter);
        bl2 = ((Object)aLabelFormatter).equals(iAxisLabelFormatter);
        jRadioButtonMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chart2D, axisActionSetFormatter, bl2, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(axisActionSetFormatter, bl2);
        jRadioButtonMenuItem.setToolTipText(string);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu3.add(jRadioButtonMenuItem);
        simpleDateFormat = (SimpleDateFormat)DateFormat.getDateInstance(1);
        aLabelFormatter = new LabelFormatterDate(simpleDateFormat);
        axisActionSetFormatter = new AxisActionSetFormatter(chart2D, "Date (long)", n, aLabelFormatter);
        bl2 = ((Object)aLabelFormatter).equals(iAxisLabelFormatter);
        jRadioButtonMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chart2D, axisActionSetFormatter, bl2, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(axisActionSetFormatter, bl2);
        jRadioButtonMenuItem.setToolTipText(string);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu3.add(jRadioButtonMenuItem);
        simpleDateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance(3, 3);
        aLabelFormatter = new LabelFormatterDate(simpleDateFormat);
        axisActionSetFormatter = new AxisActionSetFormatter(chart2D, "Date & Time (short)", n, aLabelFormatter);
        bl2 = ((Object)aLabelFormatter).equals(iAxisLabelFormatter);
        jRadioButtonMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chart2D, axisActionSetFormatter, bl2, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(axisActionSetFormatter, bl2);
        jRadioButtonMenuItem.setToolTipText(string);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu3.add(jRadioButtonMenuItem);
        simpleDateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance(2, 2);
        aLabelFormatter = new LabelFormatterDate(simpleDateFormat);
        axisActionSetFormatter = new AxisActionSetFormatter(chart2D, "Date & Time (medium)", n, aLabelFormatter);
        bl2 = ((Object)aLabelFormatter).equals(iAxisLabelFormatter);
        jRadioButtonMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chart2D, axisActionSetFormatter, bl2, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(axisActionSetFormatter, bl2);
        jRadioButtonMenuItem.setToolTipText(string);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu3.add(jRadioButtonMenuItem);
        simpleDateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance(1, 1);
        aLabelFormatter = new LabelFormatterDate(simpleDateFormat);
        axisActionSetFormatter = new AxisActionSetFormatter(chart2D, "Date & Time (long)", n, aLabelFormatter);
        bl2 = ((Object)aLabelFormatter).equals(iAxisLabelFormatter);
        jRadioButtonMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chart2D, axisActionSetFormatter, bl2, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(axisActionSetFormatter, bl2);
        jRadioButtonMenuItem.setToolTipText(string);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu3.add(jRadioButtonMenuItem);
        aLabelFormatter = new LabelFormatterAutoUnits();
        axisActionSetFormatter = new AxisActionSetFormatter(chart2D, "Automatic unit (pico,nano,femto...)", n, aLabelFormatter);
        bl2 = ((Object)aLabelFormatter).equals(iAxisLabelFormatter);
        jRadioButtonMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chart2D, axisActionSetFormatter, bl2, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(axisActionSetFormatter, bl2);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        numberFormat = NumberFormat.getPercentInstance();
        aLabelFormatter = new LabelFormatterNumber(numberFormat);
        axisActionSetFormatter = new AxisActionSetFormatter(chart2D, "Percent", n, aLabelFormatter);
        bl2 = ((Object)aLabelFormatter).equals(iAxisLabelFormatter);
        jRadioButtonMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chart2D, axisActionSetFormatter, bl2, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(axisActionSetFormatter, bl2);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        numberFormat = NumberFormat.getCurrencyInstance();
        aLabelFormatter = new LabelFormatterNumber(numberFormat);
        axisActionSetFormatter = new AxisActionSetFormatter(chart2D, "Currency (" + numberFormat.getCurrency().getSymbol() + ")", n, aLabelFormatter);
        bl2 = ((Object)aLabelFormatter).equals(iAxisLabelFormatter);
        jRadioButtonMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chart2D, axisActionSetFormatter, bl2, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(axisActionSetFormatter, bl2);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        return jMenu;
    }

    public JMenuItem createAxisMenuItem(IAxis<?> iAxis, int n, boolean bl) {
        Chart2D chart2D = iAxis.getAccessor().getChart();
        JMenu jMenu = bl ? new PropertyChangeMenu(chart2D, "Axis" + iAxis.getAccessor().toString(), BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenu("Axis" + iAxis.getAccessor().toString());
        if (this.m_showAxisXTypeMenu && n == 1 || this.m_showAxisYTypeMenu && n == 2) {
            ((Container)jMenu).add(this.createAxisTypeMenu(chart2D, iAxis, n, bl));
        }
        if (this.m_showAxisFormatterMenu) {
            ((Container)jMenu).add(this.createAxisFormatterMenu(chart2D, iAxis, n, bl));
        }
        if (this.m_showAxisXRangePolicyMenu && n == 1 || this.m_showAxisYRangePolicyMenu && n == 2) {
            ((Container)jMenu).add(this.createAxisRangePolicyMenu(chart2D, iAxis, bl));
            JMenuItem jMenuItem = bl ? new PropertyChangeMenuItem(chart2D, new AxisActionSetRange(chart2D, "Range", n), BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenuItem(new AxisActionSetRange(chart2D, "Range", n));
            if (!AxisActionSetRange.RANGE_CHOOSER_SUPPORTED) {
                jMenuItem.setToolTipText("This is disabled as bislider.jar is missing on the class path.");
            }
            ((Container)jMenu).add(jMenuItem);
        }
        if (this.m_showAxisXTitleMenu && n == 1 || this.m_showAxisYTitleMenu && n == 2) {
            ((Container)jMenu).add(this.createAxisTitleMenu(chart2D, iAxis, n, bl));
        }
        return jMenu;
    }

    public JMenu createAxisRangePolicyMenu(Chart2D chart2D, IAxis<?> iAxis, boolean bl) {
        JMenu jMenu = bl ? new PropertyChangeMenu(chart2D, "Range policy", BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenu("Range policy");
        ButtonGroup buttonGroup = new ButtonGroup();
        Class<?> clazz = iAxis.getRangePolicy().getClass();
        boolean bl2 = clazz == RangePolicyFixedViewport.class;
        JRadioButtonMenuItem jRadioButtonMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chart2D, new AxisActionSetRangePolicy(chart2D, "Fixed viewport", iAxis.getDimension(), new RangePolicyFixedViewport()), bl2, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(new AxisActionSetRangePolicy(chart2D, "Fixed viewport", iAxis.getDimension(), new RangePolicyFixedViewport()), bl2);
        jRadioButtonMenuItem.setToolTipText("Zooms or expands to the configured range without respect to the data to display. ");
        jMenu.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem);
        bl2 = clazz == RangePolicyUnbounded.class;
        jRadioButtonMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chart2D, new AxisActionSetRangePolicy(chart2D, "Minimum viewport", iAxis.getDimension(), new RangePolicyUnbounded()), bl2, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(new AxisActionSetRangePolicy(chart2D, "Minimum viewport", iAxis.getDimension(), new RangePolicyUnbounded()), bl2);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem.setToolTipText("Ensures all data is shown with minimal bounds.");
        buttonGroup.add(jRadioButtonMenuItem);
        bl2 = clazz == RangePolicyMinimumViewport.class;
        jRadioButtonMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chart2D, new AxisActionSetRangePolicy(chart2D, "Minimum viewport with range", iAxis.getDimension(), new RangePolicyMinimumViewport(new Range(10.0, 10.0))), bl2, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(new AxisActionSetRangePolicy(chart2D, "Minimum viewport with range", iAxis.getDimension(), new RangePolicyMinimumViewport(new Range(10.0, 10.0))), bl2);
        jRadioButtonMenuItem.setToolTipText("Ensures that all data is shown and expands if range is higher. ");
        jMenu.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem);
        bl2 = clazz == RangePolicyForcedPoint.class;
        jRadioButtonMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chart2D, new AxisActionSetRangePolicy(chart2D, "Ensure visible point", iAxis.getDimension(), new RangePolicyForcedPoint(0.0)), bl2, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(new AxisActionSetRangePolicy(chart2D, "Ensure visible point", iAxis.getDimension(), new RangePolicyForcedPoint(0.0)), bl2);
        jRadioButtonMenuItem.setToolTipText("Only the minimum value of the axis' range will be ensured to be visible.");
        jMenu.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem);
        bl2 = clazz == RangePolicyHighestValues.class;
        jRadioButtonMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chart2D, new AxisActionSetRangePolicy(chart2D, "Highest points within max-50 to max.", iAxis.getDimension(), new RangePolicyHighestValues(50)), bl2, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(new AxisActionSetRangePolicy(chart2D, "Highest points within max-50 to max.", iAxis.getDimension(), new RangePolicyHighestValues(50)), bl2);
        jRadioButtonMenuItem.setToolTipText("Shows the highest values from max-50 to max.");
        jMenu.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem);
        return jMenu;
    }

    public JMenu createAxisTitleMenu(Chart2D chart2D, IAxis<?> iAxis, int n, boolean bl) {
        JMenu jMenu = bl ? new PropertyChangeMenu(chart2D, "Title", BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenu("Title");
        JMenuItem jMenuItem = bl ? new PropertyChangeMenuItem(chart2D, new AxisActionSetTitle(chart2D, "Title", n), BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenuItem(new AxisActionSetTitle(chart2D, "Title", n));
        jMenu.add(jMenuItem);
        JMenu jMenu2 = bl ? new PropertyChangeMenu(chart2D, "Font", BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenu("Font");
        Font[] fontArray = LayoutFactory.getSystemFonts(14.0f);
        for (int i = fontArray.length - 1; i > -1; --i) {
            jMenuItem = bl ? new OrderingCheckBoxPropertyChangeMenuItem(chart2D, new AxisActionSetTitleFont(chart2D, fontArray[i].getName(), n, fontArray[i]), jMenu2, false, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new OrderingCheckBoxMenuItem(new AxisActionSetTitleFont(chart2D, fontArray[i].getName(), n, fontArray[i]), jMenu2, false);
            jMenuItem.setFont(fontArray[i]);
            jMenu2.add(jMenuItem);
        }
        jMenu.add(jMenu2);
        return jMenu;
    }

    public JMenu createAxisTypeMenu(Chart2D chart2D, IAxis<?> iAxis, int n, boolean bl) {
        JMenu jMenu = bl ? new PropertyChangeMenu(chart2D, "Type", BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenu("Type");
        ButtonGroup buttonGroup = new ButtonGroup();
        Class<?> clazz = iAxis.getClass();
        boolean bl2 = clazz == AxisLinear.class;
        JRadioButtonMenuItem jRadioButtonMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chart2D, new Chart2DActionSetAxis(chart2D, new AxisLinear(), "Linear", n), bl2, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(new Chart2DActionSetAxis(chart2D, new AxisLinear(), "Linear", n), bl2);
        jMenu.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem);
        bl2 = clazz == AxisLogE.class;
        jRadioButtonMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chart2D, new Chart2DActionSetAxis(chart2D, new AxisLogE(), "Log E", n), bl2, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(new Chart2DActionSetAxis(chart2D, new AxisLogE(), "Log E", n), bl2);
        jMenu.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem);
        bl2 = clazz == AxisLog10.class;
        jRadioButtonMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chart2D, new Chart2DActionSetAxis(chart2D, new AxisLog10(), "Log 10", n), bl2, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(new Chart2DActionSetAxis(chart2D, new AxisLog10(), "Log 10", n), bl2);
        jMenu.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem);
        return jMenu;
    }

    public JMenu createBackgroundColorMenu(ChartPanel chartPanel, boolean bl) {
        Chart2D chart2D = chartPanel.getChart();
        Color color = chartPanel.getBackground();
        boolean bl2 = true;
        JMenu jMenu = bl ? new PropertyChangeMenu(chart2D, "Background color", BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenu("Background color");
        ButtonGroup buttonGroup = new ButtonGroup();
        boolean bl3 = color.equals(Color.WHITE);
        bl2 &= !bl3;
        JRadioButtonMenuItem jRadioButtonMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chart2D, new JComponentActionSetBackground(chart2D, "White", Color.WHITE), bl3, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(new JComponentActionSetBackground(chart2D, "White", Color.WHITE), bl3);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        bl3 = color.equals(Color.GRAY);
        bl2 &= !bl3;
        jRadioButtonMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chart2D, new JComponentActionSetBackground(chart2D, "Gray", Color.GRAY), bl3, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(new JComponentActionSetBackground(chart2D, "Gray", Color.GRAY), bl3);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        bl3 = color.equals(Color.LIGHT_GRAY);
        bl2 &= !bl3;
        jRadioButtonMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chart2D, new JComponentActionSetBackground(chart2D, "Light gray", Color.LIGHT_GRAY), bl3, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(new JComponentActionSetBackground(chart2D, "Light gray", Color.LIGHT_GRAY), bl3);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        bl3 = color.equals(Color.BLACK);
        boolean bl4 = !bl3;
        jRadioButtonMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chart2D, new JComponentActionSetBackground(chart2D, "Black", Color.BLACK), bl3, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(new JComponentActionSetBackground(chart2D, "Black", Color.BLACK), bl3);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chart2D, JComponentActionSetCustomBackgroundSingleton.getInstance(chart2D, "Custom Color"), bl2, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(JComponentActionSetCustomBackgroundSingleton.getInstance(chart2D, "Custom Color"), bl2 &= bl4);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        return jMenu;
    }

    public JMenuItem createChartGridMenu(ChartPanel chartPanel, boolean bl) {
        JCheckBoxMenuItem jCheckBoxMenuItem;
        Chart2D chart2D = chartPanel.getChart();
        JMenu jMenu = bl ? new PropertyChangeMenu(chart2D, "Grid", BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenu("Grid");
        if (this.m_showGridColorMenu) {
            jMenu.add(this.createGridColorMenu(chartPanel, bl));
        }
        if (this.m_showAxisXGridMenu) {
            jCheckBoxMenuItem = bl ? new PropertyChangeCheckBoxMenuItem(chart2D, new AxisActionSetGrid(chart2D, "Grid X", 1), chart2D.getAxisX().isPaintGrid(), BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJCheckBoxMenuItem(new AxisActionSetGrid(chart2D, "Grid X", 1), chart2D.getAxisX().isPaintGrid());
            jMenu.add(jCheckBoxMenuItem);
        }
        if (this.m_showAxisYGridMenu) {
            jCheckBoxMenuItem = bl ? new PropertyChangeCheckBoxMenuItem(chart2D, new AxisActionSetGrid(chart2D, "Grid Y", 2), chart2D.getAxisY().isPaintGrid(), BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJCheckBoxMenuItem(new AxisActionSetGrid(chart2D, "Grid Y", 2), chart2D.getAxisX().isPaintGrid());
            jMenu.add(jCheckBoxMenuItem);
        }
        return jMenu;
    }

    public JMenuItem createChartHighlightMenu(ChartPanel chartPanel, boolean bl) {
        Chart2D chart2D = chartPanel.getChart();
        JMenu jMenu = bl ? new PropertyChangeMenu(chart2D, "Highlighting", BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenu("Highlighting");
        boolean bl2 = chart2D.isEnabledPointHighlighting();
        JMenuItem jMenuItem = bl ? new PropertyChangeCheckBoxMenuItem(chart2D, new Chart2DActionEnableHighlighting(chart2D, "Enable"), bl2, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(new Chart2DActionEnableHighlighting(chart2D, "Enable"), bl2);
        jMenu.add(jMenuItem);
        if (this.m_showChartHighlighterMenu) {
            jMenu.add(this.createChartTraceHighlighterMenu(chartPanel, bl));
        }
        return jMenu;
    }

    public JMenu createChartMenu(ChartPanel chartPanel, boolean bl) {
        JMenuItem jMenuItem;
        Chart2D chart2D = chartPanel.getChart();
        JMenu jMenu = bl ? new PropertyChangeMenu(chartPanel, "Chart", BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenu("Chart");
        if (this.m_showChartBackgroundMenu) {
            jMenu.add(this.createBackgroundColorMenu(chartPanel, bl));
        }
        if (this.m_showChartForegroundMenu) {
            jMenu.add(this.createForegroundColorMenu(chartPanel, bl));
        }
        if (this.m_showAntialiasingMenu) {
            jMenuItem = bl ? new PropertyChangeCheckBoxMenuItem(chart2D, new Chart2DActionEnableAntialiasing(chart2D, "Antialiasing"), chart2D.isUseAntialiasing(), BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJCheckBoxMenuItem(new Chart2DActionEnableAntialiasing(chart2D, "Antialiasing"), chart2D.isUseAntialiasing());
            jMenuItem.setToolTipText("Antialiasing causes smoother edges but costs performance. ");
            jMenu.add(jMenuItem);
        }
        if (this.m_showGridMenu) {
            jMenu.add(this.createChartGridMenu(chartPanel, bl));
        }
        if (this.m_showToolTipMenu) {
            jMenu.add(this.createChartToolTipMenu(chartPanel, bl));
        }
        if (this.m_showHighlightMenu) {
            jMenu.add(this.createChartHighlightMenu(chartPanel, bl));
        }
        if (this.m_showAxisXMenu || this.m_showAxisYMenu) {
            JMenuItem jMenuItem2;
            JMenu jMenu2 = bl ? new PropertyChangeMenu(chart2D, "Axis", BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenu("Axis");
            if (this.m_showAxisXMenu) {
                jMenuItem2 = this.createAxisMenuItem(chart2D.getAxisX(), 1, bl);
                jMenu2.add(jMenuItem2);
            }
            if (this.m_showAxisYMenu) {
                jMenuItem2 = this.createAxisMenuItem(chart2D.getAxisY(), 2, bl);
                jMenu2.add(jMenuItem2);
            }
            jMenu.add(jMenu2);
        }
        if (this.m_showSaveMenu) {
            jMenuItem = this.createSaveMenu(chartPanel, bl);
            jMenu.add(jMenuItem);
        }
        if (this.m_showPrintMenu) {
            jMenuItem = bl ? new PropertyChangeMenuItem(chart2D, Chart2DActionPrintSingleton.getInstance(chart2D, "Print chart"), BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenuItem(Chart2DActionPrintSingleton.getInstance(chart2D, "Print chart"));
            jMenu.add(jMenuItem);
        }
        if (this.m_showAnnotationMenu) {
            jMenuItem = this.createAnnoationsMenu(chartPanel, bl);
            jMenu.add(jMenuItem);
        }
        if (chart2D instanceof ZoomableChart && this.m_showZoomOutMenu) {
            jMenuItem = bl ? new PropertyChangeMenuItem(chart2D, new ZoomableChartZoomOutAction((ZoomableChart)chart2D, "Zoom Out"), BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenuItem(new ZoomableChartZoomOutAction((ZoomableChart)chart2D, "Zoom Out"));
            jMenu.add(jMenuItem);
        }
        return jMenu;
    }

    public JMenuBar createChartMenuBar(ChartPanel chartPanel, boolean bl) {
        JMenu jMenu = this.createChartMenu(chartPanel, bl);
        JMenuBar jMenuBar = bl ? new PropertyChangeJMenuBar(chartPanel, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenuBar();
        jMenuBar.add(jMenu);
        return jMenuBar;
    }

    public void createChartPopupMenu(ChartPanel chartPanel, boolean bl) {
        JPopupMenu jPopupMenu = bl ? new PropertyChangePopupMenu(chartPanel.getChart(), BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JPopupMenu();
        JMenu jMenu = this.createChartMenu(chartPanel, bl);
        for (Component component : jMenu.getMenuComponents()) {
            jMenu.remove(component);
            jPopupMenu.add(component);
        }
        PopupListener popupListener = new PopupListener(jPopupMenu);
        chartPanel.getChart().addMouseListener(popupListener);
    }

    public JMenu createChartSetToolTipTypeMenu(ChartPanel chartPanel, boolean bl) {
        Chart2D chart2D = chartPanel.getChart();
        JMenu jMenu = bl ? new PropertyChangeMenu(chart2D, "Type", BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenu("Type");
        IToolTipType iToolTipType = chart2D.getToolTipType();
        ButtonGroup buttonGroup = new ButtonGroup();
        Chart2D.ToolTipType toolTipType = Chart2D.ToolTipType.NONE;
        boolean bl2 = iToolTipType.getClass() == toolTipType.getClass();
        JMenuItem jMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chart2D, new ChartActionSetToolTipType(chart2D, toolTipType.getDescription(), toolTipType), bl2, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJCheckBoxMenuItem(new ChartActionSetToolTipType(chart2D, toolTipType.getDescription(), toolTipType), bl2);
        buttonGroup.add(jMenuItem);
        jMenu.add(jMenuItem);
        toolTipType = Chart2D.ToolTipType.VALUE_SNAP_TO_TRACEPOINTS;
        bl2 = iToolTipType.getClass() == toolTipType.getClass();
        jMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chart2D, new ChartActionSetToolTipType(chart2D, toolTipType.getDescription(), toolTipType), bl2, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJCheckBoxMenuItem(new ChartActionSetToolTipType(chart2D, toolTipType.getDescription(), toolTipType), bl2);
        buttonGroup.add(jMenuItem);
        jMenu.add(jMenuItem);
        toolTipType = Chart2D.ToolTipType.DATAVALUES;
        bl2 = iToolTipType.getClass() == toolTipType.getClass();
        jMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chart2D, new ChartActionSetToolTipType(chart2D, toolTipType.getDescription(), toolTipType), bl2, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJCheckBoxMenuItem(new ChartActionSetToolTipType(chart2D, toolTipType.getDescription(), toolTipType), bl2);
        buttonGroup.add(jMenuItem);
        jMenu.add(jMenuItem);
        toolTipType = Chart2D.ToolTipType.PIXEL;
        bl2 = iToolTipType.getClass() == toolTipType.getClass();
        jMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chart2D, new ChartActionSetToolTipType(chart2D, toolTipType.getDescription(), toolTipType), bl2, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJCheckBoxMenuItem(new ChartActionSetToolTipType(chart2D, toolTipType.getDescription(), toolTipType), bl2);
        buttonGroup.add(jMenuItem);
        jMenu.add(jMenuItem);
        return jMenu;
    }

    public JMenuItem createChartToolTipMenu(ChartPanel chartPanel, boolean bl) {
        Chart2D chart2D = chartPanel.getChart();
        JMenu jMenu = bl ? new PropertyChangeMenu(chart2D, "Tool tips", BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenu("Tool tips");
        if (this.m_showToolTipTypeMenu) {
            jMenu.add(this.createChartSetToolTipTypeMenu(chartPanel, bl));
        }
        return jMenu;
    }

    public JMenu createChartTraceHighlighterMenu(ChartPanel chartPanel, boolean bl) {
        Chart2D chart2D = chartPanel.getChart();
        JMenu jMenu = bl ? new PropertyChangeMenu(chart2D, "Highlighter", BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenu("Highlighter");
        for (ITrace2D iTrace2D : chart2D.getTraces()) {
            JMenu jMenu2 = bl ? new PropertyChangeMenu(chart2D, iTrace2D.getName(), BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenu(iTrace2D.getName());
            jMenu.add(jMenu2);
            List<JMenuItem> list = this.createTraceHighlighterItems(iTrace2D, bl);
            for (JMenuItem jMenuItem : list) {
                jMenu2.add(jMenuItem);
            }
        }
        return jMenu;
    }

    public JMenu createErrorBarWizardMenu(Chart2D chart2D, ITrace2D iTrace2D, boolean bl) {
        JMenu jMenu = bl ? new PropertyChangeMenu(chart2D, "error bar policies", new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(iTrace2D)) : new JMenu("error bar policies");
        JMenu jMenu2 = bl ? new PropertyChangeMenu(chart2D, "+", new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(iTrace2D)) : new JMenu("+");
        jMenu.add(jMenu2);
        JMenu jMenu3 = bl ? new PropertyChangeMenu(chart2D, "-", new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(iTrace2D)) : new JMenu("-");
        jMenu.add(jMenu3);
        JMenu jMenu4 = bl ? new PropertyChangeMenu(chart2D, "edit", new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(iTrace2D)) : new JMenu("edit");
        jMenu.add(jMenu4);
        LinkedList<JMenu> linkedList = new LinkedList<JMenu>();
        linkedList.add(jMenu4);
        linkedList.add(jMenu3);
        LinkedList<JMenu> linkedList2 = new LinkedList<JMenu>();
        linkedList2.add(jMenu2);
        TreeSet<AErrorBarPolicyConfigurable> treeSet = new TreeSet<AErrorBarPolicyConfigurable>();
        treeSet.add(new ErrorBarPolicyRelative(0.02, 0.02));
        treeSet.add(new ErrorBarPolicyAbsoluteSummation(4.0, 4.0));
        Set<IErrorBarPolicy<?>> set = iTrace2D.getErrorBarPolicies();
        for (IErrorBarPolicy<?> iterator2 : set) {
            JMenuItem jMenuItem = bl ? new PropertyChangeMenuItem(chart2D, new ErrorBarPolicyMultiAction(iTrace2D, iterator2.getClass().getName(), iterator2, jMenu2, jMenu3, jMenu4), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(iTrace2D)) : new JMenuItem(new ErrorBarPolicyMultiAction(iTrace2D, iterator2.getClass().getName(), iterator2, jMenu2, jMenu3, jMenu4));
            jMenu4.add(jMenuItem);
        }
        TreeSet treeSet2 = new TreeSet(treeSet);
        for (IErrorBarPolicy<?> iErrorBarPolicy : set) {
            treeSet2.remove(iErrorBarPolicy);
        }
        Iterator iterator = treeSet2.iterator();
        while (iterator.hasNext()) {
            IErrorBarPolicy iErrorBarPolicy = (IErrorBarPolicy)iterator.next();
            if (bl) {
                jMenu2.add(new PropertyChangeMenuItem(chart2D, new ErrorBarPolicyMultiAction(iTrace2D, iErrorBarPolicy.getClass().getName(), iErrorBarPolicy, jMenu2, jMenu3, jMenu4), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(iTrace2D)));
                continue;
            }
            jMenu2.add(new JMenuItem(new ErrorBarPolicyMultiAction(iTrace2D, iErrorBarPolicy.getClass().getName(), iErrorBarPolicy, jMenu2, jMenu3, jMenu4)));
        }
        for (IErrorBarPolicy<?> iErrorBarPolicy : set) {
            if (bl) {
                jMenu3.add(new PropertyChangeMenuItem(chart2D, new ErrorBarPolicyMultiAction(iTrace2D, iErrorBarPolicy.getClass().getName(), iErrorBarPolicy, jMenu2, jMenu3, jMenu4), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(iTrace2D)));
                continue;
            }
            jMenu3.add(new JMenuItem(new ErrorBarPolicyMultiAction(iTrace2D, iErrorBarPolicy.getClass().getName(), iErrorBarPolicy, jMenu2, jMenu3, jMenu4)));
        }
        return jMenu;
    }

    public JMenuItem createForegroundColorMenu(ChartPanel chartPanel, boolean bl) {
        Chart2D chart2D = chartPanel.getChart();
        Color color = chart2D.getForeground();
        boolean bl2 = true;
        ButtonGroup buttonGroup = new ButtonGroup();
        JMenu jMenu = bl ? new PropertyChangeMenu(chart2D, "Foreground color", BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenu("Foreground color");
        boolean bl3 = color.equals(Color.WHITE);
        bl2 &= !bl3;
        JRadioButtonMenuItem jRadioButtonMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chart2D, new JComponentActionSetForeground(chart2D, "White", Color.WHITE), bl3, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(new JComponentActionSetForeground(chart2D, "White", Color.WHITE), bl3);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        bl3 = color.equals(Color.GRAY);
        bl2 &= !bl3;
        jRadioButtonMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chart2D, new JComponentActionSetForeground(chartPanel.getChart(), "Gray", Color.GRAY), bl3, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(new JComponentActionSetForeground(chart2D, "Gray", Color.GRAY), bl3);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        bl3 = color.equals(Color.LIGHT_GRAY);
        bl2 &= !bl3;
        jRadioButtonMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chart2D, new JComponentActionSetForeground(chartPanel.getChart(), "Light gray", Color.LIGHT_GRAY), bl3, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(new JComponentActionSetForeground(chart2D, "Light gray", Color.LIGHT_GRAY), bl3);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        bl3 = color.equals(Color.BLACK);
        boolean bl4 = !bl3;
        jRadioButtonMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chart2D, new JComponentActionSetForeground(chart2D, "Black", Color.BLACK), bl3, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(new JComponentActionSetForeground(chart2D, "Black", Color.BLACK), bl3);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chartPanel.getChart(), JComponentActionSetCustomForegroundSingleton.getInstance(chartPanel.getChart(), "Custom Color"), bl2, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(JComponentActionSetCustomForegroundSingleton.getInstance(chartPanel.getChart(), "Custom Color"), bl2 &= bl4);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        return jMenu;
    }

    public JMenu createGridColorMenu(ChartPanel chartPanel, boolean bl) {
        Chart2D chart2D = chartPanel.getChart();
        Color color = chart2D.getGridColor();
        boolean bl2 = true;
        ButtonGroup buttonGroup = new ButtonGroup();
        JMenu jMenu = bl ? new PropertyChangeMenu(chart2D, "Grid color", BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenu("Grid color");
        boolean bl3 = color.equals(Color.GRAY);
        bl2 &= !bl3;
        JRadioButtonMenuItem jRadioButtonMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chart2D, new Chart2DActionSetGridColor(chart2D, "Gray", Color.GRAY), bl3, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(new Chart2DActionSetGridColor(chart2D, "Gray", Color.GRAY), bl3);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        bl3 = color.equals(Color.LIGHT_GRAY);
        bl2 &= !bl3;
        jRadioButtonMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chart2D, new Chart2DActionSetGridColor(chart2D, "Light gray", Color.LIGHT_GRAY), bl3, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(new Chart2DActionSetGridColor(chart2D, "Light gray", Color.LIGHT_GRAY), bl3);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        bl3 = color.equals(Color.BLACK);
        bl2 &= !bl3;
        jRadioButtonMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chart2D, new Chart2DActionSetGridColor(chart2D, "Black", Color.BLACK), bl3, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(new Chart2DActionSetGridColor(chart2D, "Black", Color.BLACK), bl3);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        bl3 = color.equals(Color.WHITE);
        boolean bl4 = !bl3;
        jRadioButtonMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chart2D, new Chart2DActionSetGridColor(chart2D, "White", Color.WHITE), bl3, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(new Chart2DActionSetGridColor(chart2D, "White", Color.WHITE), bl3);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chart2D, Chart2DActionSetCustomGridColorSingleton.getInstance(chart2D, "Custom"), bl2, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(Chart2DActionSetCustomGridColorSingleton.getInstance(chart2D, "Custom"), bl2 &= bl4);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        return jMenu;
    }

    public JMenu createSaveMenu(ChartPanel chartPanel, boolean bl) {
        JMenuItem jMenuItem;
        JMenu jMenu;
        Chart2D chart2D = chartPanel.getChart();
        Action action = Chart2DActionSaveEpsSingletonApacheFop.getInstance(chart2D, "Save eps");
        if (bl) {
            jMenu = new PropertyChangeMenu(chart2D, "Save", BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance());
            jMenuItem = new PropertyChangeMenuItem(chart2D, Chart2DActionSaveImageSingleton.getInstance(chart2D, "Save image"), BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance());
            jMenu.add(jMenuItem);
            if (this.m_showSaveEpsMenu) {
                jMenuItem = new PropertyChangeMenuItem(chart2D, action, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance());
            }
        } else {
            jMenu = new JMenu("Save");
            jMenuItem = new JMenuItem(Chart2DActionSaveImageSingleton.getInstance(chart2D, "Save image"));
            jMenu.add(jMenuItem);
            if (this.m_showSaveEpsMenu) {
                jMenuItem = new JMenuItem(action);
            }
        }
        if (!Chart2DActionSaveEpsSingletonApacheFop.EPS_SUPPORTED) {
            jMenuItem.setToolTipText("This is disabled as xmlgraphics-commons-<version>.jar is missing on the classpath.");
        }
        jMenu.add(jMenuItem);
        return jMenu;
    }

    public JMenu createTraceColorMenu(Chart2D chart2D, ITrace2D iTrace2D, JComponent jComponent, boolean bl) {
        JMenu jMenu = bl ? new PropertyChangeMenu(chart2D, "Color", new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(iTrace2D)) : new JMenu("Color");
        JMenuItem jMenuItem = bl ? new PropertyChangeMenuItem(chart2D, new Trace2DActionSetColor(iTrace2D, "Red", Color.RED), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(iTrace2D)) : new JMenuItem(new Trace2DActionSetColor(iTrace2D, "Red", Color.RED));
        jMenu.add(jMenuItem);
        jMenuItem = bl ? new PropertyChangeMenuItem(chart2D, new Trace2DActionSetColor(iTrace2D, "Green", Color.GREEN), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(iTrace2D)) : new JMenuItem(new Trace2DActionSetColor(iTrace2D, "Green", Color.GREEN));
        jMenu.add(jMenuItem);
        jMenuItem = bl ? new PropertyChangeMenuItem(chart2D, new Trace2DActionSetColor(iTrace2D, "Blue", Color.BLUE), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(iTrace2D)) : new JMenuItem(new Trace2DActionSetColor(iTrace2D, "Blue", Color.BLUE));
        jMenu.add(jMenuItem);
        jMenuItem = bl ? new PropertyChangeMenuItem(chart2D, new Trace2DActionSetColor(iTrace2D, "Gray", Color.GRAY), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(iTrace2D)) : new JMenuItem(new Trace2DActionSetColor(iTrace2D, "Gray", Color.GRAY));
        jMenu.add(jMenuItem);
        jMenuItem = bl ? new PropertyChangeMenuItem(chart2D, new Trace2DActionSetColor(iTrace2D, "Magenta", Color.MAGENTA), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(iTrace2D)) : new JMenuItem(new Trace2DActionSetColor(iTrace2D, "Magenta", Color.MAGENTA));
        jMenu.add(jMenuItem);
        jMenuItem = bl ? new PropertyChangeMenuItem(chart2D, new Trace2DActionSetColor(iTrace2D, "Pink", Color.PINK), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(iTrace2D)) : new JMenuItem(new Trace2DActionSetColor(iTrace2D, "Pink", Color.PINK));
        jMenu.add(jMenuItem);
        jMenuItem = bl ? new PropertyChangeMenuItem(chart2D, new Trace2DActionSetColor(iTrace2D, "Black", Color.BLACK), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(iTrace2D)) : new JMenuItem(new Trace2DActionSetColor(iTrace2D, "Black", Color.BLACK));
        jMenu.add(jMenuItem);
        jMenuItem = bl ? new PropertyChangeMenuItem(chart2D, new Trace2DActionSetCustomColor(iTrace2D, "Custom", jComponent), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(iTrace2D)) : new JMenuItem(new Trace2DActionSetCustomColor(iTrace2D, "Custom", jComponent));
        jMenu.add(jMenuItem);
        return jMenu;
    }

    public JLabel createTraceContextMenuLabel(Chart2D chart2D, ITrace2D iTrace2D, boolean bl) {
        String string = iTrace2D.getLabel();
        TraceJLabel traceJLabel = null;
        if (!StringUtil.isEmpty(string)) {
            JMenuItem jMenuItem;
            traceJLabel = new TraceJLabel(iTrace2D);
            PropertyChangePopupMenu propertyChangePopupMenu = new PropertyChangePopupMenu(chart2D, new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(iTrace2D));
            Color color = chart2D.getBackground();
            traceJLabel.setBackground(color);
            traceJLabel.setForeground(iTrace2D.getColor());
            if (this.m_showTraceVisibleMenu) {
                jMenuItem = bl ? new PropertyChangeCheckBoxMenuItem(chart2D, new Trace2DActionSetVisible(iTrace2D, "Visible"), iTrace2D.isVisible(), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(iTrace2D)) : new SelectionAdaptJCheckBoxMenuItem(new Trace2DActionSetVisible(iTrace2D, "Visible"), iTrace2D.isVisible());
                propertyChangePopupMenu.add(jMenuItem);
            }
            if (this.m_showTraceNameMenu) {
                jMenuItem = bl ? new PropertyChangeMenuItem(chart2D, new Trace2DActionSetName(iTrace2D, "Name", chart2D), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(iTrace2D)) : new JMenuItem(new Trace2DActionSetName(iTrace2D, "Name", chart2D));
                propertyChangePopupMenu.add(jMenuItem);
            }
            if (this.m_showPhysicalUnitsMenu) {
                jMenuItem = bl ? new PropertyChangeMenuItem(chart2D, new Trace2DActionSetPhysicalUnits(iTrace2D, "Physical Units", chart2D), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(iTrace2D)) : new JMenuItem(new Trace2DActionSetPhysicalUnits(iTrace2D, "Physical Units", chart2D));
                propertyChangePopupMenu.add(jMenuItem);
            }
            if (this.m_showTraceColorMenu) {
                propertyChangePopupMenu.add(this.createTraceColorMenu(chart2D, iTrace2D, traceJLabel, bl));
            }
            if (this.m_showTraceZindexMenu) {
                propertyChangePopupMenu.add(this.createTraceZindexMenu(chart2D, iTrace2D, bl));
            }
            if (this.m_showTraceStrokeMenu) {
                propertyChangePopupMenu.add(this.createTraceStrokesMenu(chart2D, iTrace2D, bl));
            }
            if (this.m_showTracePainterMenu) {
                propertyChangePopupMenu.add(this.createTracePainterMenu(chart2D, iTrace2D, bl));
            }
            if (this.m_showTraceHighlighterMenu) {
                propertyChangePopupMenu.add(this.createTraceHighlighterMenu(iTrace2D, bl));
            }
            if (this.m_showRemoveTraceMenu) {
                jMenuItem = bl ? new PropertyChangeMenuItem(chart2D, new Trace2DActionRemove(iTrace2D, "Remove"), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(iTrace2D)) : new JMenuItem(new Trace2DActionRemove(iTrace2D, "Remove"));
                propertyChangePopupMenu.add(jMenuItem);
            }
            if (this.m_showErrorBarWizardMenu) {
                propertyChangePopupMenu.add(this.createErrorBarWizardMenu(chart2D, iTrace2D, bl));
            }
            traceJLabel.addMouseListener(new PopupListener(propertyChangePopupMenu));
            iTrace2D.addPropertyChangeListener("ITrace2D.PROPERTY_COLOR", traceJLabel);
            iTrace2D.addPropertyChangeListener("ITrace2D.PROPERTY_NAME", traceJLabel);
            iTrace2D.addPropertyChangeListener("ITrace2D.PROPERTY_PHYSICALUNITS", traceJLabel);
        }
        return traceJLabel;
    }

    private List<JMenuItem> createTraceHighlighterItems(ITrace2D iTrace2D, boolean bl) {
        LinkedList<JMenuItem> linkedList = new LinkedList<JMenuItem>();
        PointPainterDisc pointPainterDisc = new PointPainterDisc(20);
        pointPainterDisc.setColorFill(new Color(255, 254, 233, 136));
        pointPainterDisc.setTransparencyFill(200);
        pointPainterDisc.setColor(Color.BLACK);
        pointPainterDisc.setTransparency(255);
        pointPainterDisc.setStroke(new BasicStroke(3.0f));
        IPointPainter[] iPointPainterArray = new IPointPainter[]{new PointPainterDisc(10), new PointPainterDisc(20), pointPainterDisc};
        String[] stringArray = new String[]{"Small disc", "Big disc", "Big disc filled yellow"};
        for (int i = 0; i < iPointPainterArray.length; ++i) {
            IPointPainter iPointPainter = iPointPainterArray[i];
            JCheckBoxMenuItem jCheckBoxMenuItem = bl ? new PropertyChangeCheckBoxMenuItem(iTrace2D.getRenderer(), new Trace2DActionAddRemoveHighlighter(iTrace2D, stringArray[i], iPointPainter), false, new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(iTrace2D)) : new SelectionAdaptJCheckBoxMenuItem(new Trace2DActionAddRemoveHighlighter(iTrace2D, stringArray[i], iPointPainter), false);
            linkedList.add(jCheckBoxMenuItem);
        }
        return linkedList;
    }

    private JMenuItem createTraceHighlighterMenu(ITrace2D iTrace2D, boolean bl) {
        JMenu jMenu = bl ? new PropertyChangeMenu(iTrace2D.getRenderer(), "Highlighting", new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(iTrace2D)) : new JMenu("Highlighting");
        List<JMenuItem> list = this.createTraceHighlighterItems(iTrace2D, bl);
        for (JMenuItem jMenuItem : list) {
            ((Container)jMenu).add(jMenuItem);
        }
        return jMenu;
    }

    public JMenu createTracePainterMenu(Chart2D chart2D, ITrace2D iTrace2D, boolean bl) {
        JMenu jMenu = bl ? new PropertyChangeMenu(chart2D, "renderer", new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(iTrace2D)) : new JMenu("renderer");
        ATracePainter aTracePainter = new TracePainterDisc(4);
        OrderingCheckBoxMenuItem orderingCheckBoxMenuItem = bl ? new OrderingCheckBoxPropertyChangeMenuItem(chart2D, new Trace2DActionAddRemoveTracePainter(iTrace2D, "discs", aTracePainter), jMenu, iTrace2D.containsTracePainter(aTracePainter), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(iTrace2D)) : new OrderingCheckBoxMenuItem(new Trace2DActionAddRemoveTracePainter(iTrace2D, "discs", aTracePainter), jMenu, iTrace2D.containsTracePainter(aTracePainter));
        jMenu.add(orderingCheckBoxMenuItem);
        aTracePainter = new TracePainterPolyline();
        orderingCheckBoxMenuItem = bl ? new OrderingCheckBoxPropertyChangeMenuItem(chart2D, new Trace2DActionAddRemoveTracePainter(iTrace2D, "line", aTracePainter), jMenu, iTrace2D.containsTracePainter(aTracePainter), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(iTrace2D)) : new OrderingCheckBoxMenuItem(new Trace2DActionAddRemoveTracePainter(iTrace2D, "line", aTracePainter), jMenu, iTrace2D.containsTracePainter(aTracePainter));
        jMenu.add(orderingCheckBoxMenuItem);
        aTracePainter = new TracePainterFill(chart2D);
        orderingCheckBoxMenuItem = bl ? new OrderingCheckBoxPropertyChangeMenuItem(chart2D, new Trace2DActionAddRemoveTracePainter(iTrace2D, "fill", aTracePainter), jMenu, iTrace2D.containsTracePainter(aTracePainter), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(iTrace2D)) : new OrderingCheckBoxMenuItem(new Trace2DActionAddRemoveTracePainter(iTrace2D, "fill", aTracePainter), jMenu, iTrace2D.containsTracePainter(aTracePainter));
        jMenu.add(orderingCheckBoxMenuItem);
        aTracePainter = new TracePainterVerticalBar(chart2D);
        orderingCheckBoxMenuItem = bl ? new OrderingCheckBoxPropertyChangeMenuItem(chart2D, new Trace2DActionAddRemoveTracePainter(iTrace2D, "bar", aTracePainter), jMenu, iTrace2D.containsTracePainter(aTracePainter), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(iTrace2D)) : new OrderingCheckBoxMenuItem(new Trace2DActionAddRemoveTracePainter(iTrace2D, "bar", aTracePainter), jMenu, iTrace2D.containsTracePainter(aTracePainter));
        jMenu.add(orderingCheckBoxMenuItem);
        if (iTrace2D.getTracePainters().contains(aTracePainter)) {
            orderingCheckBoxMenuItem.setSelected(true);
        }
        return jMenu;
    }

    public JMenu createTraceStrokesMenu(Chart2D chart2D, ITrace2D iTrace2D, boolean bl) {
        JMenu jMenu = bl ? new PropertyChangeMenu(chart2D, "Stroke", new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(iTrace2D)) : new JMenu("Stroke");
        for (int i = 0; i < this.m_strokes.length; ++i) {
            JMenuItem jMenuItem = bl ? new PropertyChangeMenuItem(chart2D, new Trace2DActionSetStroke(iTrace2D, this.m_strokeNames[i], this.m_strokes[i]), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(iTrace2D)) : new JMenuItem(new Trace2DActionSetStroke(iTrace2D, this.m_strokeNames[i], this.m_strokes[i]));
            jMenu.add(jMenuItem);
        }
        return jMenu;
    }

    public JMenu createTraceZindexMenu(Chart2D chart2D, ITrace2D iTrace2D, boolean bl) {
        JMenu jMenu = bl ? new PropertyChangeMenu(chart2D, "layer", new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(iTrace2D)) : new JMenu("layer");
        JMenuItem jMenuItem = bl ? new PropertyChangeMenuItem(chart2D, new Trace2DActionSetZindex(iTrace2D, "bring to front", 0), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(iTrace2D)) : new JMenuItem(new Trace2DActionSetZindex(iTrace2D, "bring to front", 0));
        jMenu.add(jMenuItem);
        jMenuItem = bl ? new PropertyChangeMenuItem(chart2D, new Trace2DActionSetZindex(iTrace2D, "send to back", 100), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(iTrace2D)) : new JMenuItem(new Trace2DActionSetZindex(iTrace2D, "send to back", 100));
        jMenu.add(jMenuItem);
        jMenuItem = bl ? new PropertyChangeMenuItem(chart2D, new Trace2DActionZindexDecrease(iTrace2D, "forward", 2), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(iTrace2D)) : new JMenuItem(new Trace2DActionZindexDecrease(iTrace2D, "forward", 2));
        jMenu.add(jMenuItem);
        jMenuItem = bl ? new PropertyChangeMenuItem(chart2D, new Trace2DActionZindexIncrease(iTrace2D, "backwards", 2), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(iTrace2D)) : new JMenuItem(new Trace2DActionZindexIncrease(iTrace2D, "backwards", 2));
        jMenu.add(jMenuItem);
        return jMenu;
    }

    public final boolean isShowAnnotationMenu() {
        return this.m_showAnnotationMenu;
    }

    public boolean isShowAntialiasingMenu() {
        return this.m_showAntialiasingMenu;
    }

    public boolean isShowAxisFormatterMenu() {
        return this.m_showAxisFormatterMenu;
    }

    public final boolean isShowAxisXGridMenu() {
        return this.m_showAxisXGridMenu;
    }

    public final boolean isShowAxisXMenu() {
        return this.m_showAxisXMenu;
    }

    public final boolean isShowAxisXRangePolicyMenu() {
        return this.m_showAxisXRangePolicyMenu;
    }

    public final boolean isShowAxisXTitleMenu() {
        return this.m_showAxisXTitleMenu;
    }

    public final boolean isShowAxisXTypeMenu() {
        return this.m_showAxisXTypeMenu;
    }

    public final boolean isShowAxisYGridMenu() {
        return this.m_showAxisYGridMenu;
    }

    public final boolean isShowAxisYMenu() {
        return this.m_showAxisYMenu;
    }

    public final boolean isShowAxisYRangePolicyMenu() {
        return this.m_showAxisYRangePolicyMenu;
    }

    public final boolean isShowAxisYTitleMenu() {
        return this.m_showAxisYTitleMenu;
    }

    public final boolean isShowAxisYTypeMenu() {
        return this.m_showAxisYTypeMenu;
    }

    public final boolean isShowChartBackgroundMenu() {
        return this.m_showChartBackgroundMenu;
    }

    public final boolean isShowChartForegroundMenu() {
        return this.m_showChartForegroundMenu;
    }

    public boolean isShowChartHighlighterMenu() {
        return this.m_showChartHighlighterMenu;
    }

    public final boolean isShowErrorBarWizardMenu() {
        return this.m_showErrorBarWizardMenu;
    }

    public final boolean isShowGridColorMenu() {
        return this.m_showGridColorMenu;
    }

    public boolean isShowGridMenu() {
        return this.m_showGridMenu;
    }

    public boolean isShowHighlightMenu() {
        return this.m_showHighlightMenu;
    }

    public final boolean isShowPhysicalUnitsMenu() {
        return this.m_showPhysicalUnitsMenu;
    }

    public final boolean isShowPrintMenu() {
        return this.m_showPrintMenu;
    }

    public final boolean isShowRemoveTraceMenu() {
        return this.m_showRemoveTraceMenu;
    }

    public final boolean isShowSaveEpsMenu() {
        return this.m_showSaveEpsMenu;
    }

    public final boolean isShowSaveMenu() {
        return this.m_showSaveMenu;
    }

    public boolean isShowToolTipMenu() {
        return this.m_showToolTipMenu;
    }

    public boolean isShowToolTipTypeMenu() {
        return this.m_showToolTipTypeMenu;
    }

    public final boolean isShowTraceColorMenu() {
        return this.m_showTraceColorMenu;
    }

    public boolean isShowTraceHighlighterMenu() {
        return this.m_showTraceHighlighterMenu;
    }

    public final boolean isShowTraceNameMenu() {
        return this.m_showTraceNameMenu;
    }

    public final boolean isShowTracePainterMenu() {
        return this.m_showTracePainterMenu;
    }

    public final boolean isShowTraceStrokeMenu() {
        return this.m_showTraceStrokeMenu;
    }

    public final boolean isShowTraceVisibleMenu() {
        return this.m_showTraceVisibleMenu;
    }

    public final boolean isShowTraceZindexMenu() {
        return this.m_showTraceZindexMenu;
    }

    public final boolean isShowZoomOutMenu() {
        return this.m_showZoomOutMenu;
    }

    public final boolean isZoomOutMenu() {
        return this.m_showZoomOutMenu;
    }

    public final void setShowAnnotationMenu(boolean bl) {
        this.m_showAnnotationMenu = bl;
    }

    public void setShowAntialiasingMenu(boolean bl) {
        this.m_showAntialiasingMenu = bl;
    }

    public void setShowAxisFormatterMenu(boolean bl) {
        this.m_showAxisFormatterMenu = bl;
    }

    public final void setShowAxisXGridMenu(boolean bl) {
        this.m_showAxisXGridMenu = bl;
    }

    public final void setShowAxisXMenu(boolean bl) {
        this.m_showAxisXMenu = bl;
    }

    public final void setShowAxisXRangePolicyMenu(boolean bl) {
        this.m_showAxisXRangePolicyMenu = bl;
    }

    public final void setShowAxisXTitleMenu(boolean bl) {
        this.m_showAxisXTitleMenu = bl;
    }

    public final void setShowAxisXTypeMenu(boolean bl) {
        this.m_showAxisXTypeMenu = bl;
    }

    public final void setShowAxisYGridMenu(boolean bl) {
        this.m_showAxisYGridMenu = bl;
    }

    public final void setShowAxisYMenu(boolean bl) {
        this.m_showAxisYMenu = bl;
    }

    public final void setShowAxisYRangePolicyMenu(boolean bl) {
        this.m_showAxisYRangePolicyMenu = bl;
    }

    public final void setShowAxisYTitleMenu(boolean bl) {
        this.m_showAxisYTitleMenu = bl;
    }

    public final void setShowAxisYTypeMenu(boolean bl) {
        this.m_showAxisYTypeMenu = bl;
    }

    public final void setShowChartBackgroundMenu(boolean bl) {
        this.m_showChartBackgroundMenu = bl;
    }

    public final void setShowChartForegroundMenu(boolean bl) {
        this.m_showChartForegroundMenu = bl;
    }

    public void setShowChartHighlighterMenu(boolean bl) {
        this.m_showChartHighlighterMenu = bl;
    }

    public final void setShowErrorBarWizardMenu(boolean bl) {
        this.m_showErrorBarWizardMenu = bl;
    }

    public final void setShowGridColorMenu(boolean bl) {
        this.m_showGridColorMenu = bl;
    }

    public void setShowGridMenu(boolean bl) {
        this.m_showGridMenu = bl;
    }

    public void setShowHighlightMenu(boolean bl) {
        this.m_showHighlightMenu = bl;
    }

    public final void setShowPhysicalUnitsMenu(boolean bl) {
        this.m_showPhysicalUnitsMenu = bl;
    }

    public final void setShowPrintMenu(boolean bl) {
        this.m_showPrintMenu = bl;
    }

    public final void setShowRemoveTraceMenu(boolean bl) {
        this.m_showRemoveTraceMenu = bl;
    }

    public final void setShowSaveEpsMenu(boolean bl) {
        this.m_showSaveEpsMenu = bl;
    }

    public final void setShowSaveMenu(boolean bl) {
        this.m_showSaveMenu = bl;
    }

    public void setShowTooltipEnableMenu(boolean bl) {
        this.m_showToolTipTypeMenu = bl;
    }

    public void setShowToolTipMenu(boolean bl) {
        this.m_showToolTipMenu = bl;
    }

    public final void setShowTraceColorMenu(boolean bl) {
        this.m_showTraceColorMenu = bl;
    }

    public void setShowTraceHighlighterMenu(boolean bl) {
        this.m_showTraceHighlighterMenu = bl;
    }

    public final void setShowTraceNameMenu(boolean bl) {
        this.m_showTraceNameMenu = bl;
    }

    public final void setShowTracePainterMenu(boolean bl) {
        this.m_showTracePainterMenu = bl;
    }

    public final void setShowTraceStrokeMenu(boolean bl) {
        this.m_showTraceStrokeMenu = bl;
    }

    public final void setShowTraceVisibleMenu(boolean bl) {
        this.m_showTraceVisibleMenu = bl;
    }

    public final void setShowTraceZindexMenu(boolean bl) {
        this.m_showTraceZindexMenu = bl;
    }

    public final void setShowZoomOutMenu(boolean bl) {
        this.m_showZoomOutMenu = bl;
    }

    public final void setZoomOutMenu(boolean bl) {
        this.m_showZoomOutMenu = bl;
    }

    final class TraceJLabel
    extends JLabel
    implements PropertyChangeListener {
        private static final long serialVersionUID = 3617290112636172342L;

        public TraceJLabel(ITrace2D iTrace2D) {
            super(iTrace2D.getLabel());
            new BasicPropertyAdaptSupport(this, iTrace2D.getRenderer(), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(iTrace2D));
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("ITrace2D.PROPERTY_COLOR")) {
                Color color;
                Color color2 = (Color)propertyChangeEvent.getNewValue();
                if (color2.equals(color = this.getBackground())) {
                    this.setBackground(this.getForeground());
                }
                this.setForeground(color2);
            } else if (string.equals("background")) {
                Color color;
                Color color3 = (Color)propertyChangeEvent.getNewValue();
                if (color3.equals(color = this.getForeground())) {
                    this.setForeground(this.getBackground());
                }
                this.setBackground(color3);
            } else if (string.equals("font")) {
                Font font = (Font)propertyChangeEvent.getNewValue();
                this.setFont(font);
            } else if (string.equals("ITrace2D.PROPERTY_NAME")) {
                ITrace2D iTrace2D = (ITrace2D)propertyChangeEvent.getSource();
                this.setText(iTrace2D.getLabel());
            } else if (string.equals("ITrace2D.PROPERTY_PHYSICALUNITS")) {
                ITrace2D iTrace2D = (ITrace2D)propertyChangeEvent.getSource();
                this.setText(iTrace2D.getLabel());
            }
        }
    }

    public static class SelectionPropertyAdaptSupport
    implements PropertyChangeListener {
        protected WeakReference<AbstractButton> m_delegate;

        public SelectionPropertyAdaptSupport(AbstractButton abstractButton) {
            this.m_delegate = new WeakReference<AbstractButton>(abstractButton);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            AbstractButton abstractButton = (AbstractButton)this.m_delegate.get();
            if (abstractButton != null) {
                if (string.equals("")) {
                    boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                    abstractButton.setSelected(bl);
                    abstractButton.invalidate();
                    abstractButton.repaint();
                }
            } else {
                ((Component)propertyChangeEvent.getSource()).removePropertyChangeListener(this);
            }
        }
    }

    private static class SelectionAdaptJRadioButtonMenuItem
    extends JRadioButtonMenuItem {
        private static final long serialVersionUID = 6949450166704804365L;

        public SelectionAdaptJRadioButtonMenuItem(Action action, boolean bl) {
            super(action);
        }

        public void setAction(Action action) {
            if (action != null) {
                super.setAction(action);
                action.addPropertyChangeListener(new SelectionPropertyAdaptSupport(this));
            }
        }
    }

    private static class SelectionAdaptJCheckBoxMenuItem
    extends JCheckBoxMenuItem {
        private static final long serialVersionUID = 5737559379056167605L;

        public SelectionAdaptJCheckBoxMenuItem(Action action, boolean bl) {
            super(action);
            this.setSelected(bl);
        }

        public void setAction(Action action) {
            if (action != null) {
                super.setAction(action);
                action.addPropertyChangeListener(new SelectionPropertyAdaptSupport(this));
            }
        }
    }

    private static class PropertyChangePopupMenu
    extends JPopupMenu {
        private static final long serialVersionUID = 3617013061525780016L;

        public PropertyChangePopupMenu(JComponent jComponent, BasicPropertyAdaptSupport.IRemoveAsListenerFromComponentCondition iRemoveAsListenerFromComponentCondition) {
            new BasicPropertyAdaptSupport(this, jComponent, iRemoveAsListenerFromComponentCondition);
        }
    }

    public static class PropertyChangeMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 3690196534012752439L;
        private WeakReference<JComponent> m_component;

        public PropertyChangeMenuItem(JComponent jComponent, Action action, BasicPropertyAdaptSupport.IRemoveAsListenerFromComponentCondition iRemoveAsListenerFromComponentCondition) {
            super(action);
            new BasicPropertyAdaptSupport(this, jComponent, iRemoveAsListenerFromComponentCondition);
            this.m_component = new WeakReference<JComponent>(jComponent);
        }

        public JComponent getUIAdaptee() {
            return (JComponent)this.m_component.get();
        }
    }

    private static class PropertyChangeMenu
    extends JMenu {
        private static final long serialVersionUID = 3256437027795973685L;

        public PropertyChangeMenu(JComponent jComponent, String string, BasicPropertyAdaptSupport.IRemoveAsListenerFromComponentCondition iRemoveAsListenerFromComponentCondition) {
            super(string);
            this.setOpaque(true);
            new BasicPropertyAdaptSupport(this, jComponent, iRemoveAsListenerFromComponentCondition);
        }
    }

    private static class PropertyChangeJRadioButtonMenuItem
    extends JRadioButtonMenuItem {
        private static final long serialVersionUID = 3933408706693522564L;

        public PropertyChangeJRadioButtonMenuItem(JComponent jComponent, Action action, boolean bl, BasicPropertyAdaptSupport.IRemoveAsListenerFromComponentCondition iRemoveAsListenerFromComponentCondition) {
            super(action);
            this.setSelected(bl);
            new BasicPropertyAdaptSupport(this, jComponent, iRemoveAsListenerFromComponentCondition);
        }

        public void setAction(Action action) {
            if (action != null) {
                super.setAction(action);
                action.addPropertyChangeListener(new SelectionPropertyAdaptSupport(this));
            }
        }
    }

    private static class PropertyChangeJMenuBar
    extends JMenuBar {
        private static final long serialVersionUID = -332246962640911539L;

        public PropertyChangeJMenuBar(JComponent jComponent, BasicPropertyAdaptSupport.IRemoveAsListenerFromComponentCondition iRemoveAsListenerFromComponentCondition) {
            new BasicPropertyAdaptSupport(this, jComponent, iRemoveAsListenerFromComponentCondition);
        }
    }

    public static class PropertyChangeCheckBoxMenuItem
    extends JCheckBoxMenuItem {
        public static final String PROPERTY_SELECTED = "";
        private static final long serialVersionUID = 3690196534012752439L;

        public PropertyChangeCheckBoxMenuItem(JComponent jComponent, Action action, boolean bl, BasicPropertyAdaptSupport.IRemoveAsListenerFromComponentCondition iRemoveAsListenerFromComponentCondition) {
            super(action);
            this.setState(bl);
            new BasicPropertyAdaptSupport(this, jComponent, iRemoveAsListenerFromComponentCondition);
        }

        protected PropertyChangeCheckBoxMenuItem(JComponent jComponent, boolean bl, BasicPropertyAdaptSupport.IRemoveAsListenerFromComponentCondition iRemoveAsListenerFromComponentCondition) {
            this(jComponent, null, bl, iRemoveAsListenerFromComponentCondition);
        }

        public void setAction(Action action) {
            if (action != null) {
                super.setAction(action);
                action.addPropertyChangeListener(new SelectionPropertyAdaptSupport(this));
            }
        }
    }

    private static class OrderingCheckBoxPropertyChangeMenuItem
    extends OrderingCheckBoxMenuItem {
        private static final long serialVersionUID = 3889088574130596540L;

        public OrderingCheckBoxPropertyChangeMenuItem(JComponent jComponent, Action action, JMenu jMenu, boolean bl, BasicPropertyAdaptSupport.IRemoveAsListenerFromComponentCondition iRemoveAsListenerFromComponentCondition) {
            super(action, jMenu, bl);
            new BasicPropertyAdaptSupport(this, jComponent, iRemoveAsListenerFromComponentCondition);
        }
    }

    private static class OrderingCheckBoxMenuItem
    extends JCheckBoxMenuItem {
        private static final long serialVersionUID = 3834870273894857017L;
        protected JMenu m_menu;

        public OrderingCheckBoxMenuItem(Action action, JMenu jMenu, boolean bl) {
            this.setSelected(bl);
            this.m_menu = jMenu;
            if (action != null) {
                action.addPropertyChangeListener(new SelectionPropertyAdaptSupport(this));
            }
            super.setAction(new JMenuOrderingAction(action));
        }

        private final class JMenuOrderingAction
        extends AbstractAction {
            private static final long serialVersionUID = 3835159462649672505L;
            private Action m_action;

            protected JMenuOrderingAction(Action action) {
                this.m_action = action;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.m_action.actionPerformed(actionEvent);
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                boolean bl = jCheckBoxMenuItem.getState();
                if (bl) {
                    OrderingCheckBoxMenuItem.this.m_menu.remove(OrderingCheckBoxMenuItem.this);
                    OrderingCheckBoxMenuItem.this.m_menu.add((Component)OrderingCheckBoxMenuItem.this, 0);
                } else {
                    OrderingCheckBoxMenuItem.this.m_menu.remove(OrderingCheckBoxMenuItem.this);
                    OrderingCheckBoxMenuItem.this.m_menu.add(OrderingCheckBoxMenuItem.this);
                }
            }

            public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                this.m_action.addPropertyChangeListener(propertyChangeListener);
            }

            public boolean equals(Object object) {
                return this.m_action.equals(object);
            }

            public Object getValue(String string) {
                return this.m_action.getValue(string);
            }

            public int hashCode() {
                return this.m_action.hashCode();
            }

            public boolean isEnabled() {
                return this.m_action.isEnabled();
            }

            public void putValue(String string, Object object) {
                this.m_action.putValue(string, object);
            }

            public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                this.m_action.removePropertyChangeListener(propertyChangeListener);
            }

            public void setEnabled(boolean bl) {
                this.m_action.setEnabled(bl);
            }

            public String toString() {
                return this.m_action.toString();
            }
        }
    }

    public static class BasicPropertyAdaptSupport
    implements PropertyChangeListener {
        private final IRemoveAsListenerFromComponentCondition m_stopListeningControl;
        private Component m_adaptee;
        protected WeakReference<Component> m_delegate;

        public BasicPropertyAdaptSupport(Component component, Component component2, IRemoveAsListenerFromComponentCondition iRemoveAsListenerFromComponentCondition) {
            this.m_delegate = new WeakReference<Component>(component);
            this.m_adaptee = component2;
            this.m_stopListeningControl = iRemoveAsListenerFromComponentCondition;
            component.setFont(component2.getFont());
            component.setBackground(component2.getBackground());
            component.setForeground(component2.getForeground());
            this.startListening();
        }

        protected void finalize() throws Throwable {
            super.finalize();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            Object t = this.m_delegate.get();
            if (t != null) {
                Component component = (Component)t;
                if (string.equals("foreground")) {
                    Color color;
                    Color color2 = (Color)propertyChangeEvent.getNewValue();
                    if (!color2.equals(color = component.getForeground())) {
                        component.setForeground(color2);
                    }
                    component.setBackground(color2);
                    component.repaint();
                } else if (string.equals("font")) {
                    Font font = (Font)propertyChangeEvent.getNewValue();
                    component.setFont(font);
                } else if (string.equals("background")) {
                    Color color;
                    Color color3 = (Color)propertyChangeEvent.getNewValue();
                    if (!color3.equals(color = component.getBackground())) {
                        component.setBackground(color3);
                    }
                } else if (this.m_stopListeningControl.isRemoveMeAsListenerComponentEvent(propertyChangeEvent)) {
                    this.stopListening();
                }
            } else {
                this.stopListening();
            }
        }

        private void startListening() {
            this.m_adaptee.addPropertyChangeListener("foreground", this);
            this.m_adaptee.addPropertyChangeListener("background", this);
            this.m_adaptee.addPropertyChangeListener("font", this);
            for (String string : this.m_stopListeningControl.getPropertyChangePropertiesToListenForRemovalOn()) {
                this.m_adaptee.addPropertyChangeListener(string, this);
            }
        }

        private void stopListening() {
            this.m_adaptee.removePropertyChangeListener("font", this);
            this.m_adaptee.removePropertyChangeListener("background", this);
            this.m_adaptee.removePropertyChangeListener("foreground", this);
            for (String string : this.m_stopListeningControl.getPropertyChangePropertiesToListenForRemovalOn()) {
                this.m_adaptee.removePropertyChangeListener(string, this);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class RemoveAsListenerFromComponentNever
        implements IRemoveAsListenerFromComponentCondition {
            private static IRemoveAsListenerFromComponentCondition INSTANCE;

            public static IRemoveAsListenerFromComponentCondition getInstance() {
                if (INSTANCE == null) {
                    INSTANCE = new RemoveAsListenerFromComponentNever();
                }
                return INSTANCE;
            }

            private RemoveAsListenerFromComponentNever() {
            }

            @Override
            public Set<String> getPropertyChangePropertiesToListenForRemovalOn() {
                return Collections.emptySet();
            }

            @Override
            public boolean isRemoveMeAsListenerComponentEvent(PropertyChangeEvent propertyChangeEvent) {
                return false;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class RemoveAsListenerFromComponentIfTraceIsDropped
        implements IRemoveAsListenerFromComponentCondition {
            private static final Set<String> PROPERTIES_SENT_BY_CHART2D_TO_REMOVE_BASICPROPERTYADAPTSUPPORT_AS_LISTENER_ON_CHART = new TreeSet<String>();
            private final ITrace2D m_traceToWatchForRemoval;

            public RemoveAsListenerFromComponentIfTraceIsDropped(ITrace2D iTrace2D) {
                this.m_traceToWatchForRemoval = iTrace2D;
            }

            @Override
            public Set<String> getPropertyChangePropertiesToListenForRemovalOn() {
                return PROPERTIES_SENT_BY_CHART2D_TO_REMOVE_BASICPROPERTYADAPTSUPPORT_AS_LISTENER_ON_CHART;
            }

            @Override
            public boolean isRemoveMeAsListenerComponentEvent(PropertyChangeEvent propertyChangeEvent) {
                ITrace2D iTrace2D;
                boolean bl = false;
                String string = propertyChangeEvent.getPropertyName();
                if (PROPERTIES_SENT_BY_CHART2D_TO_REMOVE_BASICPROPERTYADAPTSUPPORT_AS_LISTENER_ON_CHART.contains(string) && (iTrace2D = (ITrace2D)propertyChangeEvent.getOldValue()) == this.m_traceToWatchForRemoval) {
                    bl = true;
                }
                return bl;
            }

            static {
                PROPERTIES_SENT_BY_CHART2D_TO_REMOVE_BASICPROPERTYADAPTSUPPORT_AS_LISTENER_ON_CHART.add("IAxis.PROPERTY_ADD_REMOVE_TRACE");
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface IRemoveAsListenerFromComponentCondition {
            public boolean isRemoveMeAsListenerComponentEvent(PropertyChangeEvent var1);

            public Set<String> getPropertyChangePropertiesToListenForRemovalOn();
        }
    }
}

