/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.axistitlepainters;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.IAxis;
import info.monitorenter.gui.chart.IAxisTitlePainter;
import info.monitorenter.util.StringUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxisTitlePainterDefault
implements IAxisTitlePainter {
    private static final long serialVersionUID = -8076180259242501703L;

    @Override
    public int getHeight(IAxis<?> iAxis, Graphics graphics) {
        int n = 0;
        IAxis.AxisTitle axisTitle = iAxis.getAxisTitle();
        String string = axisTitle.getTitle();
        if (!StringUtil.isEmpty(string)) {
            Rectangle2D rectangle2D = graphics.getFontMetrics().getStringBounds(string, graphics);
            int n2 = iAxis.getDimension();
            switch (n2) {
                case 1: {
                    n = (int)rectangle2D.getHeight();
                    break;
                }
                case 2: {
                    boolean bl = graphics instanceof Graphics2D;
                    if (bl) {
                        n = (int)rectangle2D.getWidth();
                        break;
                    }
                    n = (int)rectangle2D.getHeight();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Given axis.getDimension() is neither Chart2D.X nor Chart2D.Y!");
                }
            }
        }
        return n;
    }

    @Override
    public int getWidth(IAxis<?> iAxis, Graphics graphics) {
        int n = 0;
        IAxis.AxisTitle axisTitle = iAxis.getAxisTitle();
        String string = axisTitle.getTitle();
        if (!StringUtil.isEmpty(string)) {
            Font font = graphics.getFont();
            Font font2 = axisTitle.getTitleFont();
            if (font2 != null) {
                graphics.setFont(font2);
            }
            Rectangle2D rectangle2D = graphics.getFontMetrics().getStringBounds(string, graphics);
            int n2 = iAxis.getDimension();
            switch (n2) {
                case 1: {
                    n = (int)rectangle2D.getWidth();
                    break;
                }
                case 2: {
                    boolean bl = graphics instanceof Graphics2D;
                    if (bl) {
                        n = (int)rectangle2D.getHeight();
                        break;
                    }
                    n = (int)rectangle2D.getWidth();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Given axis.getDimension() is neither Chart2D.X nor Chart2D.Y!");
                }
            }
            if (font2 != null) {
                graphics.setFont(font);
            }
        }
        return n;
    }

    @Override
    public void paintTitle(IAxis<?> iAxis, Graphics graphics) {
        IAxis.AxisTitle axisTitle = iAxis.getAxisTitle();
        String string = axisTitle.getTitle();
        Font font = axisTitle.getTitleFont();
        Font font2 = graphics.getFont();
        Color color = axisTitle.getTitleColor();
        Color color2 = graphics.getColor();
        if (font != null) {
            graphics.setFont(font);
        }
        if (color != color2 && color != null) {
            graphics.setColor(color);
        }
        Rectangle2D rectangle2D = graphics.getFontMetrics().getStringBounds(string, graphics);
        Chart2D chart2D = iAxis.getAccessor().getChart();
        int n = iAxis.getDimension();
        int n2 = iAxis.getAxisPosition();
        block0 : switch (n) {
            case 1: {
                switch (n2) {
                    case 32: {
                        int n3 = chart2D.getXChartStart();
                        int n4 = chart2D.getXChartEnd();
                        double d = rectangle2D.getWidth();
                        int n5 = (int)((double)(n4 - n3) / 2.0 - d / 2.0);
                        graphics.drawString(string, n5, iAxis.getPixelYBottom() - 4);
                        break block0;
                    }
                    case 16: {
                        int n6 = chart2D.getXChartStart();
                        int n7 = chart2D.getXChartEnd();
                        double d = rectangle2D.getWidth();
                        int n8 = (int)((double)(n7 - n6) / 2.0 - d / 2.0);
                        graphics.drawString(string, n8, iAxis.getPixelYTop() + chart2D.getFontMetrics(chart2D.getFont()).getHeight());
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (n2) {
                    case 4: {
                        boolean bl = graphics instanceof Graphics2D;
                        if (bl) {
                            int n9;
                            double d;
                            int n10;
                            Graphics2D graphics2D = (Graphics2D)graphics;
                            int n11 = chart2D.getYChartStart();
                            int n12 = (int)((double)(n11 - (n10 = chart2D.getYChartEnd())) / 2.0 + (d = rectangle2D.getWidth()) / 2.0);
                            if (n12 <= 0) {
                                System.err.println("titleStartY below or equal to zero: " + n12);
                            }
                            if ((n9 = iAxis.getPixelXLeft() + chart2D.getFontMetrics(chart2D.getFont()).getHeight()) <= 0) {
                                System.err.println("titleStartX below or equal to zero: " + n9);
                            }
                            AffineTransform affineTransform = graphics2D.getTransform();
                            AffineTransform affineTransform2 = graphics2D.getDeviceConfiguration().getDefaultTransform();
                            affineTransform2.translate(n9, n12);
                            affineTransform2.rotate(-1.5707963267948966);
                            graphics2D.setTransform(affineTransform2);
                            graphics2D.drawString(string, 0, 0);
                            graphics2D.setTransform(affineTransform);
                            break block0;
                        }
                        int n13 = chart2D.getYChartStart();
                        int n14 = chart2D.getYChartEnd();
                        double d = rectangle2D.getWidth();
                        int n15 = (int)((double)(n13 - n14) / 2.0 + d / 2.0);
                        int n16 = iAxis.getPixelXLeft() + chart2D.getFontMetrics(chart2D.getFont()).getHeight();
                        graphics.drawString(string, n16, n15);
                        break block0;
                    }
                    case 8: {
                        boolean bl = graphics instanceof Graphics2D;
                        if (bl) {
                            Graphics2D graphics2D = (Graphics2D)graphics;
                            int n17 = chart2D.getYChartStart();
                            int n18 = chart2D.getYChartEnd();
                            double d = rectangle2D.getWidth();
                            int n19 = (int)((double)(n17 - n18) / 2.0 + d / 2.0);
                            int n20 = chart2D.getFontMetrics(chart2D.getFont()).charWidth('0');
                            int n21 = chart2D.getAxisTickPainter().getMajorTickLength();
                            AffineTransform affineTransform = graphics2D.getTransform();
                            AffineTransform affineTransform3 = graphics2D.getDeviceConfiguration().getDefaultTransform();
                            affineTransform3.translate(chart2D.getXChartEnd() + (n21 += iAxis.getFormatter().getMaxAmountChars() * n20), n19);
                            affineTransform3.rotate(-1.5707963267948966);
                            graphics2D.setTransform(affineTransform3);
                            graphics2D.drawString(string, 0, 0);
                            graphics2D.setTransform(affineTransform);
                            break block0;
                        }
                        int n22 = chart2D.getYChartStart();
                        int n23 = chart2D.getYChartEnd();
                        double d = rectangle2D.getWidth();
                        int n24 = (int)((double)(n22 - n23) / 2.0 + d / 2.0);
                        int n25 = chart2D.getFontMetrics(chart2D.getFont()).charWidth('0');
                        int n26 = chart2D.getAxisTickPainter().getMajorTickLength();
                        int n27 = (n26 += iAxis.getFormatter().getMaxAmountChars() * n25) + chart2D.getXChartEnd();
                        graphics.drawString(string, n27, n24);
                        break block0;
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Given axis.getDimension() is neither Chart2D.X nor Chart2D.Y!");
            }
        }
        if (font != null) {
            graphics.setFont(font2);
        }
        if (color != color2 && color != null) {
            graphics.setColor(color2);
        }
    }
}

