/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.axis.scalepolicy;

import info.monitorenter.gui.chart.IAxis;
import info.monitorenter.gui.chart.IAxisScalePolicy;
import info.monitorenter.gui.chart.LabeledValue;
import info.monitorenter.gui.chart.axis.AAxisTransformation;
import info.monitorenter.util.Range;
import java.awt.Graphics;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxisScalePolicyTransformation
implements IAxisScalePolicy {
    @Override
    public List<LabeledValue> getScaleValues(Graphics graphics, IAxis<?> iAxis) {
        AAxisTransformation aAxisTransformation = (AAxisTransformation)iAxis;
        LinkedList<LabeledValue> linkedList = new LinkedList<LabeledValue>();
        Range range = iAxis.getRange();
        double d = range.getMin();
        double d2 = range.getMax();
        d = aAxisTransformation.transform(d);
        d2 = aAxisTransformation.transform(d2);
        double d3 = d2 - d;
        double d4 = 0.0;
        double d5 = aAxisTransformation.untransform(0.0);
        while (d5 <= iAxis.getMax()) {
            if (d5 >= iAxis.getMin()) {
                LabeledValue labeledValue = new LabeledValue();
                labeledValue.setValue(d5);
                labeledValue.setLabel(iAxis.getFormatter().format(labeledValue.getValue()));
                labeledValue.setMajorTick(true);
                labeledValue.setValue((aAxisTransformation.transform(labeledValue.getValue()) - d) / d3);
                linkedList.add(labeledValue);
            }
            d5 = aAxisTransformation.untransform(d4 += 1.0);
        }
        return linkedList;
    }

    @Override
    public void initPaintIteration(IAxis<?> iAxis) {
    }
}

