/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.axis.scalepolicy;

import info.monitorenter.gui.chart.IAxis;
import info.monitorenter.gui.chart.IAxisScalePolicy;
import info.monitorenter.gui.chart.LabeledValue;
import info.monitorenter.util.Range;
import java.awt.Graphics;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxisScalePolicyManualTicks
implements IAxisScalePolicy {
    protected LabeledValue createLabeledValue(double d, double d2, IAxis<?> iAxis) {
        LabeledValue labeledValue = new LabeledValue();
        labeledValue.setValue(d);
        if (d % d2 == 0.0) {
            labeledValue.setMajorTick(true);
        } else {
            labeledValue.setMajorTick(false);
        }
        labeledValue.setLabel(iAxis.getFormatter().format(labeledValue.getValue()));
        labeledValue.setValue(iAxis.getFormatter().parse(labeledValue.getLabel()).doubleValue());
        return labeledValue;
    }

    protected List<LabeledValue> getLabels(IAxis<?> iAxis) {
        LinkedList<LabeledValue> linkedList = new LinkedList<LabeledValue>();
        double d = iAxis.getMinorTickSpacing();
        double d2 = iAxis.getMajorTickSpacing();
        if (d > 0.0) {
            LabeledValue labeledValue;
            double d3;
            Range range = iAxis.getRange();
            double d4 = range.getMin();
            double d5 = range.getMax();
            String string = "";
            double d6 = d5 - d4;
            if (iAxis.isStartMajorTick()) {
                d3 = (double)((int)(d4 / d2)) * d2;
                if (d3 < d4) {
                    d3 += d2;
                }
            } else {
                d3 = (double)((int)(d4 / d)) * d;
            }
            String string2 = "start";
            int n = 0;
            while (d3 <= d5 && n < 100) {
                if (n == 99) {
                    // empty if block
                }
                if (string.equals(string2)) {
                    // empty if block
                }
                labeledValue = this.createLabeledValue(d3, d2, iAxis);
                string = string2;
                string2 = labeledValue.getLabel();
                d3 = labeledValue.getValue();
                ++n;
                if (d3 <= d5 && d3 >= d4) {
                    linkedList.add(labeledValue);
                } else if (d3 > d5 || d3 < d4) {
                    // empty if block
                }
                d3 += d;
            }
            int n2 = linkedList.size();
            for (int i = 0; i < n2; ++i) {
                labeledValue = (LabeledValue)linkedList.get(i);
                labeledValue.setValue((labeledValue.getValue() - d4) / d6);
            }
        }
        return linkedList;
    }

    @Override
    public List<LabeledValue> getScaleValues(Graphics graphics, IAxis<?> iAxis) {
        return this.getLabels(iAxis);
    }

    @Override
    public void initPaintIteration(IAxis<?> iAxis) {
    }
}

