/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.axis.scalepolicy;

import info.monitorenter.gui.chart.IAxis;
import info.monitorenter.gui.chart.IAxisScalePolicy;
import info.monitorenter.gui.chart.LabeledValue;
import info.monitorenter.util.Range;
import info.monitorenter.util.math.MathUtil;
import java.awt.Graphics;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxisScalePolicyAutomaticBestFit
implements IAxisScalePolicy {
    protected double m_power;

    @Override
    public List<LabeledValue> getScaleValues(Graphics graphics, IAxis<?> iAxis) {
        double d = iAxis.getAccessor().getMinimumValueDistanceForLabels(graphics);
        double d2 = iAxis.getFormatter().getMinimumValueShiftForChange();
        double d3 = Math.max(d, d2);
        return this.getLabels(d3, iAxis);
    }

    @Override
    public void initPaintIteration(IAxis<?> iAxis) {
        double d;
        double d2 = d = iAxis.getMax() - iAxis.getMin();
        if (d == 0.0 || !MathUtil.isDouble(d)) {
            d2 = 1.0;
        }
        double d3 = 0.0;
        if (d2 > 1.0) {
            while (d2 > 50.0) {
                d2 /= 10.0;
                d3 += 1.0;
            }
            d3 = Math.pow(10.0, d3 - 1.0);
        } else {
            while (d2 < 5.0) {
                d2 *= 10.0;
                d3 += 1.0;
            }
            d3 = 1.0 / Math.pow(10.0, d3);
        }
        this.m_power = d3;
    }

    protected List<LabeledValue> getLabels(double d, IAxis<?> iAxis) {
        LinkedList<LabeledValue> linkedList = new LinkedList<LabeledValue>();
        if (d > 0.0) {
            LabeledValue labeledValue;
            Range range = iAxis.getRange();
            double d2 = range.getMin();
            double d3 = range.getMax();
            String string = "";
            double d4 = d3 - d2;
            double d5 = this.roundToTicks(d, false, false, iAxis).getValue();
            String string2 = "start";
            int n = 0;
            boolean bl = false;
            for (double d6 = Math.ceil(d2 / d5) * d5; d6 <= d3 && n < 100; d6 += d) {
                if (n == 99) {
                    // empty if block
                }
                if (string.equals(string2)) {
                    // empty if block
                }
                labeledValue = this.roundToTicks(d6, false, !bl && iAxis.isStartMajorTick(), iAxis);
                string = string2;
                string2 = labeledValue.getLabel();
                d6 = labeledValue.getValue();
                ++n;
                if (!bl && iAxis.isStartMajorTick() && !labeledValue.isMajorTick()) continue;
                bl = true;
                if (d6 <= d3 && d6 >= d2) {
                    linkedList.add(labeledValue);
                    continue;
                }
                if (!(d6 > d3) && !(d6 < d2)) continue;
            }
            int n2 = linkedList.size();
            for (int i = 0; i < n2; ++i) {
                labeledValue = (LabeledValue)linkedList.get(i);
                labeledValue.setValue((labeledValue.getValue() - d2) / d4);
            }
        }
        return linkedList;
    }

    protected LabeledValue roundToTicks(double d, boolean bl, boolean bl2, IAxis<?> iAxis) {
        double d2;
        double d3;
        double d4;
        LabeledValue labeledValue = new LabeledValue();
        double d5 = iAxis.getMinorTickSpacing() * this.m_power;
        double d6 = iAxis.getMajorTickSpacing() * this.m_power;
        double d7 = bl ? Math.floor(d / d6) : Math.ceil(d / d6);
        boolean bl3 = d7 == 0.0 && d != 0.0;
        d7 *= d6;
        double d8 = bl ? Math.floor(d / d5) : Math.ceil(d / d5);
        boolean bl4 = d8 == 0.0 && d != 0.0;
        d8 *= d5;
        if (bl3 || bl4) {
            // empty if block
        }
        if (Double.isNaN(d4 = (d3 = Math.abs(d - d8)) / (d2 = Math.abs(d - d7)))) {
            d4 = 1.0;
        }
        if (d2 <= d3 || bl2) {
            labeledValue.setValue(d7);
            labeledValue.setMajorTick(true);
        } else {
            labeledValue.setValue(d8);
            labeledValue.setMajorTick(false);
        }
        labeledValue.setLabel(iAxis.getFormatter().format(labeledValue.getValue()));
        labeledValue.setValue(iAxis.getFormatter().parse(labeledValue.getLabel()).doubleValue());
        return labeledValue;
    }
}

