/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.axis;

import info.monitorenter.gui.chart.IAxisLabelFormatter;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.axis.AAxisTransformation;
import info.monitorenter.gui.chart.axis.scalepolicy.AxisScalePolicyTransformation;
import info.monitorenter.gui.chart.labelformatters.LabelFormatterSimple;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxisLog10<T extends AxisScalePolicyTransformation>
extends AAxisTransformation<T> {
    private static final long serialVersionUID = -1783172443489534956L;

    public AxisLog10() {
        this(new LabelFormatterSimple(), new AxisScalePolicyTransformation());
    }

    public AxisLog10(IAxisLabelFormatter iAxisLabelFormatter, T t) {
        super(iAxisLabelFormatter, t);
    }

    @Override
    public double transform(double d) {
        double d2;
        double d3 = d;
        if (d3 < 1.0) {
            if (this.m_accessor == null) {
                throw new IllegalStateException("Connect this axis (" + this.getAxisTitle().getTitle() + ") to a chart first before doing this operation.");
            }
            Iterator iterator = this.m_accessor.getChart().getTraces().iterator();
            if (!iterator.hasNext()) {
                d3 = 1.0;
            } else {
                while (iterator.hasNext()) {
                    ITrace2D iTrace2D = (ITrace2D)iterator.next();
                    if (!iTrace2D.iterator().hasNext()) continue;
                    throw new IllegalArgumentException(this.getClass().getName() + " must not be used with values < 1!");
                }
                d3 = 1.0;
            }
        }
        if (Double.isInfinite(d2 = Math.log(d3) / Math.log(10.0))) {
            d2 = Double.MAX_VALUE;
        }
        return d2;
    }

    @Override
    public double untransform(double d) {
        return Math.pow(10.0, d);
    }
}

