/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.axis;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.IAxisLabelFormatter;
import info.monitorenter.gui.chart.IAxisScalePolicy;
import info.monitorenter.gui.chart.axis.AAxis;
import info.monitorenter.gui.chart.axis.scalepolicy.AxisScalePolicyAutomaticBestFit;
import info.monitorenter.gui.chart.labelformatters.LabelFormatterSimple;
import info.monitorenter.util.Range;
import info.monitorenter.util.math.MathUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxisLinear<T extends IAxisScalePolicy>
extends AAxis<T> {
    private static final long serialVersionUID = 4725336592625669661L;

    public AxisLinear() {
        this(new LabelFormatterSimple(), new AxisScalePolicyAutomaticBestFit());
    }

    public AxisLinear(IAxisLabelFormatter iAxisLabelFormatter) {
        this(iAxisLabelFormatter, new AxisScalePolicyAutomaticBestFit());
    }

    public AxisLinear(IAxisLabelFormatter iAxisLabelFormatter, T t) {
        super(iAxisLabelFormatter, t);
    }

    @Override
    protected AAxis.AChart2DDataAccessor createAccessor(Chart2D chart2D, int n, int n2) {
        AAxis.AChart2DDataAccessor aChart2DDataAccessor;
        if (n == 1) {
            if ((n2 & 0x30) == 0) {
                throw new IllegalArgumentException("X axis only valid with top or bottom position.");
            }
            this.setAxisPosition(n2);
            aChart2DDataAccessor = new AAxis.XDataAccessor(this, chart2D);
        } else if (n == 2) {
            if ((n2 & 0xC) == 0) {
                throw new IllegalArgumentException("Y axis only valid with left or right position.");
            }
            this.setAxisPosition(n2);
            aChart2DDataAccessor = new AAxis.YDataAccessor(this, chart2D);
        } else {
            throw new IllegalArgumentException("Dimension has to be Chart2D.X or Chart2D.Y!");
        }
        return aChart2DDataAccessor;
    }

    @Override
    public double getScaledValue(double d) {
        Range range = this.getRange();
        double d2 = range.getExtent();
        double d3 = (d - range.getMin()) / d2;
        if (!MathUtil.isDouble(d3)) {
            d3 = 0.0;
        }
        return d3;
    }
}

