/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.axis;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.IAxis;
import info.monitorenter.gui.chart.IAxisLabelFormatter;
import info.monitorenter.gui.chart.IAxisScalePolicy;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.ITracePoint2D;
import info.monitorenter.gui.chart.LabeledValue;
import info.monitorenter.gui.chart.axis.AAxis;
import info.monitorenter.util.Range;
import info.monitorenter.util.math.MathUtil;
import java.awt.Graphics;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxisInverse<T extends IAxisScalePolicy>
extends AAxis<T> {
    private static final long serialVersionUID = -1688970969107347292L;

    public AxisInverse() {
    }

    public AxisInverse(IAxisLabelFormatter iAxisLabelFormatter, T t) {
        super(iAxisLabelFormatter, t);
    }

    @Override
    protected AAxis.AChart2DDataAccessor createAccessor(Chart2D chart2D, int n, int n2) {
        AAxis.AChart2DDataAccessor aChart2DDataAccessor;
        if (n == 1) {
            if ((n2 & 0x30) == 0) {
                throw new IllegalArgumentException("X axis only valid with top or bottom position.");
            }
            this.setAxisPosition(n2);
            aChart2DDataAccessor = new XDataInverseAccessor(chart2D);
        } else if (n == 2) {
            if ((n2 & 0xC) == 0) {
                throw new IllegalArgumentException("Y axis only valid with left or right position.");
            }
            this.setAxisPosition(n2);
            aChart2DDataAccessor = new YDataInverseAccessor(chart2D);
        } else {
            throw new IllegalArgumentException("Dimension has to be Chart2D.X or Chart2D.Y!");
        }
        return aChart2DDataAccessor;
    }

    @Override
    public IAxisScalePolicy setAxisScalePolicy(T t) {
        return super.setAxisScalePolicy(new IAxisScalePolicy((IAxisScalePolicy)t){
            final /* synthetic */ IAxisScalePolicy val$axisScalePolicy;
            {
                this.val$axisScalePolicy = iAxisScalePolicy;
            }

            public void initPaintIteration(IAxis iAxis) {
                this.val$axisScalePolicy.initPaintIteration(iAxis);
            }

            public List<LabeledValue> getScaleValues(Graphics graphics, IAxis iAxis) {
                List<LabeledValue> list = this.val$axisScalePolicy.getScaleValues(graphics, iAxis);
                for (LabeledValue labeledValue : list) {
                    labeledValue.setValue(1.0 - labeledValue.getValue());
                }
                return list;
            }
        });
    }

    @Override
    public double getScaledValue(double d) {
        Range range = this.getRange();
        double d2 = range.getExtent();
        double d3 = 1.0 - (d - range.getMin()) / d2;
        if (!MathUtil.isDouble(d3)) {
            d3 = 0.0;
        }
        return d3;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class YDataInverseAccessor
    extends AAxis.YDataAccessor {
        private static final long serialVersionUID = -1759763478911933057L;

        public YDataInverseAccessor(Chart2D chart2D) {
            super(AxisInverse.this, chart2D);
        }

        @Override
        protected void scaleTrace(ITrace2D iTrace2D, Range range) {
            if (iTrace2D.isVisible()) {
                double d = range.getExtent();
                Iterator<ITracePoint2D> iterator = iTrace2D.iterator();
                while (iterator.hasNext()) {
                    ITracePoint2D iTracePoint2D = iterator.next();
                    double d2 = iTracePoint2D.getY();
                    double d3 = 1.0 - (d2 - range.getMin()) / d;
                    if (!MathUtil.isDouble(d3)) {
                        d3 = 0.0;
                    }
                    iTracePoint2D.setScaledY(d3);
                }
            }
        }

        @Override
        public double translatePxToValue(int n) {
            double d = 0.0;
            double d2 = this.m_chart.getYChartStart() - n;
            int n2 = this.m_chart.getYChartStart() - this.m_chart.getYChartEnd();
            if (n2 != 0) {
                double d3 = 1.0 - d2 / (double)n2;
                Range range = AxisInverse.this.getRange();
                d = d3 * range.getExtent() + range.getMin();
            }
            return d;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class XDataInverseAccessor
    extends AAxis.XDataAccessor {
        private static final long serialVersionUID = -7789192812199631543L;

        public XDataInverseAccessor(Chart2D chart2D) {
            super(AxisInverse.this, chart2D);
        }

        @Override
        protected void scaleTrace(ITrace2D iTrace2D, Range range) {
            double d = range.getExtent();
            if (iTrace2D.isVisible()) {
                Iterator<ITracePoint2D> iterator = iTrace2D.iterator();
                while (iterator.hasNext()) {
                    ITracePoint2D iTracePoint2D = iterator.next();
                    double d2 = iTracePoint2D.getX();
                    double d3 = 1.0 - (d2 - range.getMin()) / d;
                    if (!MathUtil.isDouble(d3)) {
                        d3 = 0.0;
                    }
                    iTracePoint2D.setScaledX(d3);
                }
            }
        }

        @Override
        public double translatePxToValue(int n) {
            double d = 0.0;
            double d2 = n - this.m_chart.getXChartStart();
            int n2 = this.m_chart.getXChartEnd() - this.m_chart.getXChartStart();
            if (n2 != 0) {
                double d3 = 1.0 - d2 / (double)n2;
                Range range = AxisInverse.this.getRange();
                d = d3 * range.getExtent() + range.getMin();
            }
            return d;
        }
    }
}

