/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.axis;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.IAxisLabelFormatter;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.ITracePoint2D;
import info.monitorenter.gui.chart.axis.AAxis;
import info.monitorenter.gui.chart.axis.scalepolicy.AxisScalePolicyTransformation;
import info.monitorenter.util.Range;
import info.monitorenter.util.math.MathUtil;
import java.awt.event.MouseEvent;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AAxisTransformation<T extends AxisScalePolicyTransformation>
extends AAxis<T> {
    private static final int OUTPUT_ERROR_THRESHHOLD = 30000;
    private static final long serialVersionUID = -4665444421196939779L;
    protected long m_outputErrorTstamp = 0L;

    public AAxisTransformation() {
    }

    public AAxisTransformation(IAxisLabelFormatter iAxisLabelFormatter, T t) {
        super(iAxisLabelFormatter, t);
    }

    @Override
    protected AAxis.AChart2DDataAccessor createAccessor(Chart2D chart2D, int n, int n2) {
        AAxis.AChart2DDataAccessor aChart2DDataAccessor;
        if (n == 1) {
            if ((n2 & 0x30) == 0) {
                throw new IllegalArgumentException("X axis only valid with top or bottom position.");
            }
            this.setAxisPosition(n2);
            aChart2DDataAccessor = new XDataAccessor(chart2D);
        } else if (n == 2) {
            if ((n2 & 0xC) == 0) {
                throw new IllegalArgumentException("Y axis only valid with left or right position.");
            }
            this.setAxisPosition(n2);
            aChart2DDataAccessor = new YDataAccessor(chart2D);
        } else {
            throw new IllegalArgumentException("Dimension has to be Chart2D.X or Chart2D.Y!");
        }
        return aChart2DDataAccessor;
    }

    public double getMaxTransformed() {
        double d = 1.0;
        try {
            d = this.transform(super.getMax());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return d;
    }

    public double getMinTransformed() {
        double d = 0.0;
        try {
            d = this.transform(super.getMin());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return d;
    }

    @Override
    public final double getScaledValue(double d) {
        double d2;
        Range range = new Range(this.getMinTransformed(), this.getMaxTransformed());
        try {
            d2 = this.transform(d) - range.getMin();
            double d3 = range.getExtent();
            if (!MathUtil.isDouble(d2 /= d3)) {
                d2 = 0.0;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            long l = System.currentTimeMillis();
            if (l - this.m_outputErrorTstamp > 30000L) {
                System.out.println(illegalArgumentException.getLocalizedMessage());
                this.m_outputErrorTstamp = l;
            }
            d2 = 0.0;
        }
        return d2;
    }

    @Override
    public void scaleTrace(ITrace2D iTrace2D) {
        Range range = new Range(this.getMinTransformed(), this.getMaxTransformed());
        this.m_accessor.scaleTrace(iTrace2D, range);
    }

    public abstract double transform(double var1) throws IllegalArgumentException;

    @Override
    public final double translateMousePosition(MouseEvent mouseEvent) throws IllegalArgumentException {
        return this.untransform(this.getAccessor().translateMousePosition(mouseEvent));
    }

    @Override
    public double translatePxToValue(int n) {
        return this.untransform(this.m_accessor.translatePxToValue(n));
    }

    public abstract double untransform(double var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class YDataAccessor
    extends AAxis.YDataAccessor {
        private static final long serialVersionUID = 3043923189624836455L;

        public YDataAccessor(Chart2D chart2D) {
            super(chart2D);
        }

        @Override
        protected void scaleTrace(ITrace2D iTrace2D, Range range) {
            if (iTrace2D.isVisible()) {
                double d = range.getExtent();
                Iterator<ITracePoint2D> iterator = iTrace2D.iterator();
                while (iterator.hasNext()) {
                    double d2;
                    ITracePoint2D iTracePoint2D = iterator.next();
                    double d3 = iTracePoint2D.getY();
                    try {
                        d2 = AAxisTransformation.this.transform(d3) - range.getMin();
                        if (!MathUtil.isDouble(d2 /= d)) {
                            d2 = 0.0;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        long l = System.currentTimeMillis();
                        if (l - AAxisTransformation.this.m_outputErrorTstamp > 30000L) {
                            System.out.println(illegalArgumentException.getLocalizedMessage());
                            AAxisTransformation.this.m_outputErrorTstamp = l;
                        }
                        d2 = 0.0;
                    }
                    iTracePoint2D.setScaledY(d2);
                }
            }
        }

        @Override
        public double translatePxToValue(int n) {
            double d = 0.0;
            double d2 = this.m_chart.getYChartStart() - n;
            int n2 = this.m_chart.getYChartStart() - this.m_chart.getYChartEnd();
            if (n2 != 0) {
                double d3 = d2 / (double)n2;
                Range range = new Range(AAxisTransformation.this.getMinTransformed(), AAxisTransformation.this.getMaxTransformed());
                d = d3 * range.getExtent() + range.getMin();
            }
            return d;
        }

        @Override
        public final int translateValueToPx(double d) {
            double d2;
            int n = 0;
            Range range = AAxisTransformation.this.getRange();
            double d3 = range.getExtent();
            double d4 = d;
            try {
                d2 = AAxisTransformation.this.transform(d4) - range.getMin();
                if (!MathUtil.isDouble(d2 /= d3)) {
                    d2 = 0.0;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                long l = System.currentTimeMillis();
                if (l - AAxisTransformation.this.m_outputErrorTstamp > 30000L) {
                    System.out.println(illegalArgumentException.getLocalizedMessage());
                    AAxisTransformation.this.m_outputErrorTstamp = l;
                }
                d2 = 0.0;
            }
            Chart2D chart2D = this.getChart();
            int n2 = this.getPixelRange();
            n = (int)Math.round((double)chart2D.getYChartStart() - d2 * (double)n2);
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class XDataAccessor
    extends AAxis.XDataAccessor {
        private static final long serialVersionUID = 8775312615991487847L;

        public XDataAccessor(Chart2D chart2D) {
            super(chart2D);
        }

        @Override
        protected void scaleTrace(ITrace2D iTrace2D, Range range) {
            if (iTrace2D.isVisible()) {
                Iterator<ITracePoint2D> iterator = iTrace2D.iterator();
                double d = range.getExtent();
                iterator = iTrace2D.iterator();
                while (iterator.hasNext()) {
                    double d2;
                    ITracePoint2D iTracePoint2D = iterator.next();
                    double d3 = iTracePoint2D.getX();
                    try {
                        d2 = AAxisTransformation.this.transform(d3) - range.getMin();
                        if (!MathUtil.isDouble(d2 /= d)) {
                            d2 = 0.0;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        long l = System.currentTimeMillis();
                        if (l - AAxisTransformation.this.m_outputErrorTstamp > 30000L) {
                            System.out.println(illegalArgumentException.getLocalizedMessage());
                            AAxisTransformation.this.m_outputErrorTstamp = l;
                        }
                        d2 = 0.0;
                    }
                    iTracePoint2D.setScaledX(d2);
                }
            }
        }

        @Override
        public double translatePxToValue(int n) {
            double d = 0.0;
            double d2 = n - this.m_chart.getXChartStart();
            int n2 = this.m_chart.getXChartEnd() - this.m_chart.getXChartStart();
            if (n2 != 0) {
                double d3 = d2 / (double)n2;
                Range range = new Range(AAxisTransformation.this.getMinTransformed(), AAxisTransformation.this.getMaxTransformed());
                d = d3 * range.getExtent() + range.getMin();
            }
            return d;
        }

        @Override
        public final int translateValueToPx(double d) {
            double d2;
            Range range = new Range(AAxisTransformation.this.getMinTransformed(), AAxisTransformation.this.getMaxTransformed());
            double d3 = range.getExtent();
            double d4 = d;
            try {
                d2 = AAxisTransformation.this.transform(d4) - range.getMin();
                if (!MathUtil.isDouble(d2 /= d3)) {
                    d2 = 0.0;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                long l = System.currentTimeMillis();
                if (l - AAxisTransformation.this.m_outputErrorTstamp > 30000L) {
                    System.out.println(illegalArgumentException.getLocalizedMessage());
                    AAxisTransformation.this.m_outputErrorTstamp = l;
                }
                d2 = 0.0;
            }
            Chart2D chart2D = this.getChart();
            int n = this.getPixelRange();
            int n2 = (int)Math.round((double)chart2D.getXChartStart() + d2 * (double)n);
            return n2;
        }
    }
}

