/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.axis;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.IAxis;
import info.monitorenter.gui.chart.IAxisLabelFormatter;
import info.monitorenter.gui.chart.IAxisScalePolicy;
import info.monitorenter.gui.chart.IAxisTickPainter;
import info.monitorenter.gui.chart.IAxisTitlePainter;
import info.monitorenter.gui.chart.IRangePolicy;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.ITracePoint2D;
import info.monitorenter.gui.chart.LabeledValue;
import info.monitorenter.gui.chart.axis.scalepolicy.AxisScalePolicyAutomaticBestFit;
import info.monitorenter.gui.chart.labelformatters.LabelFormatterAutoUnits;
import info.monitorenter.gui.chart.labelformatters.LabelFormatterSimple;
import info.monitorenter.gui.chart.rangepolicies.RangePolicyUnbounded;
import info.monitorenter.util.Range;
import info.monitorenter.util.StringUtil;
import info.monitorenter.util.math.MathUtil;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AAxis<T extends IAxisScalePolicy>
implements IAxis<T>,
PropertyChangeListener {
    private IAxisScalePolicy m_axisScalePolicy;
    public static final boolean DEBUG = false;
    private static SortedMap<String, IPropertyChangeReactor> propertyReactors = new TreeMap<String, IPropertyChangeReactor>();
    private static final long serialVersionUID = -3615740476406530580L;
    protected AChart2DDataAccessor m_accessor;
    private int m_axisPosition = -1;
    private IAxis.AxisTitle m_axisTitle;
    protected IAxisLabelFormatter m_formatter;
    protected double m_majorTickSpacing = 5.0;
    protected double m_max;
    protected double m_min;
    protected double m_minorTickSpacing = 1.0;
    protected boolean m_needsFullRescale = false;
    private boolean m_paintGrid = false;
    private boolean m_paintScale = true;
    private int m_pixelXLeft;
    private int m_pixelXRight;
    private int m_pixelYBottom;
    private int m_pixelYTop;
    private final PropertyChangeSupport m_propertyChangeSupport;
    protected IRangePolicy m_rangePolicy;
    private final Range m_rangePreviousScaling = new Range(0.0, 0.0);
    private final Range m_reusedRange = new Range(0.0, 0.0);
    private boolean m_startMajorTick = false;
    private final Set<ITrace2D> m_traces = new CopyOnWriteArraySet<ITrace2D>();
    private boolean m_visible = true;

    @Override
    public IAxisScalePolicy getAxisScalePolicy() {
        return this.m_axisScalePolicy;
    }

    @Override
    public IAxisScalePolicy setAxisScalePolicy(T t) {
        IAxisScalePolicy iAxisScalePolicy = this.m_axisScalePolicy;
        this.m_axisScalePolicy = t;
        this.m_propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(this, "IAxis.PROPERTY_AXIS_SCALE_POLICY_CHANGED", iAxisScalePolicy, this.m_axisScalePolicy));
        return iAxisScalePolicy;
    }

    @Override
    public String getDimensionString() {
        String string = null;
        if (this.m_accessor != null) {
            string = this.m_accessor.toString();
        }
        return string;
    }

    public AAxis() {
        this(new LabelFormatterAutoUnits(new LabelFormatterSimple()), new AxisScalePolicyAutomaticBestFit());
    }

    public AAxis(IAxisLabelFormatter iAxisLabelFormatter, T t) {
        this.m_propertyChangeSupport = new PropertyChangeSupport(this);
        this.setAxisTitle(new IAxis.AxisTitle(null));
        this.m_rangePolicy = new RangePolicyUnbounded(Range.RANGE_UNBOUNDED);
        this.setFormatter(iAxisLabelFormatter);
        this.setAxisScalePolicy(t);
    }

    @Override
    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.m_propertyChangeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addTrace(ITrace2D iTrace2D) {
        boolean bl = false;
        Chart2D chart2D = this.getAccessor().getChart();
        synchronized (chart2D) {
            ITrace2D iTrace2D2 = iTrace2D;
            synchronized (iTrace2D2) {
                if (this.m_traces.contains(iTrace2D)) {
                    throw new IllegalArgumentException("Trace " + iTrace2D.getName() + " is already contaied in this axis " + this.getAxisTitle() + ". Review your code. ");
                }
                bl = this.m_traces.add(iTrace2D);
                if (bl) {
                    double d;
                    this.listen2Trace(iTrace2D);
                    double d2 = this.getAccessor().getMaxValue(iTrace2D);
                    if (d2 > this.m_max) {
                        this.m_max = d2;
                    }
                    if ((d = this.getAccessor().getMinValue(iTrace2D)) < this.m_min) {
                        this.m_min = d;
                    }
                    if (this.getTraces().size() == 1) {
                        this.m_min = d;
                        this.m_max = d2;
                    }
                    iTrace2D.setRenderer(this.m_accessor.getChart());
                    this.scaleTrace(iTrace2D);
                }
            }
        }
        this.m_propertyChangeSupport.firePropertyChange("IAxis.PROPERTY_ADD_REMOVE_TRACE", null, iTrace2D);
        return bl;
    }

    protected abstract AChart2DDataAccessor createAccessor(Chart2D var1, int var2, int var3);

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AAxis aAxis = (AAxis)object;
        if (this.m_accessor == null ? aAxis.m_accessor != null : !this.m_accessor.equals(aAxis.m_accessor)) {
            return false;
        }
        if (this.m_axisPosition != aAxis.m_axisPosition) {
            return false;
        }
        if (this.m_axisTitle == null ? aAxis.m_axisTitle != null : !this.m_axisTitle.equals(aAxis.m_axisTitle)) {
            return false;
        }
        if (this.m_formatter == null ? aAxis.m_formatter != null : !this.m_formatter.equals(aAxis.m_formatter)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m_majorTickSpacing) != Double.doubleToLongBits(aAxis.m_majorTickSpacing)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m_max) != Double.doubleToLongBits(aAxis.m_max)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m_min) != Double.doubleToLongBits(aAxis.m_min)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m_minorTickSpacing) != Double.doubleToLongBits(aAxis.m_minorTickSpacing)) {
            return false;
        }
        if (this.m_needsFullRescale != aAxis.m_needsFullRescale) {
            return false;
        }
        if (this.m_paintGrid != aAxis.m_paintGrid) {
            return false;
        }
        if (this.m_paintScale != aAxis.m_paintScale) {
            return false;
        }
        if (this.m_pixelXLeft != aAxis.m_pixelXLeft) {
            return false;
        }
        if (this.m_pixelXRight != aAxis.m_pixelXRight) {
            return false;
        }
        if (this.m_pixelYBottom != aAxis.m_pixelYBottom) {
            return false;
        }
        if (this.m_pixelYTop != aAxis.m_pixelYTop) {
            return false;
        }
        if (this.m_propertyChangeSupport == null ? aAxis.m_propertyChangeSupport != null : !this.m_propertyChangeSupport.equals(aAxis.m_propertyChangeSupport)) {
            return false;
        }
        if (this.m_rangePolicy == null ? aAxis.m_rangePolicy != null : !this.m_rangePolicy.equals(aAxis.m_rangePolicy)) {
            return false;
        }
        if (this.m_rangePreviousScaling == null ? aAxis.m_rangePreviousScaling != null : !this.m_rangePreviousScaling.equals(aAxis.m_rangePreviousScaling)) {
            return false;
        }
        if (this.m_reusedRange == null ? aAxis.m_reusedRange != null : !this.m_reusedRange.equals(aAxis.m_reusedRange)) {
            return false;
        }
        if (this.m_startMajorTick != aAxis.m_startMajorTick) {
            return false;
        }
        if (this.m_traces == null ? aAxis.m_traces != null : !this.m_traces.equals(aAxis.m_traces)) {
            return false;
        }
        return this.m_visible == aAxis.m_visible;
    }

    protected final double findMax() {
        double d = -1.7976931348623157E308;
        for (ITrace2D iTrace2D : this.getTraces()) {
            double d2;
            if (!iTrace2D.isVisible() || !((d2 = this.getAccessor().getMaxValue(iTrace2D)) > d)) continue;
            d = d2;
        }
        if (d == -1.7976931348623157E308) {
            d = 10.0;
        }
        return d;
    }

    protected final double findMin() {
        double d = Double.MAX_VALUE;
        for (ITrace2D iTrace2D : this.getTraces()) {
            double d2;
            if (!iTrace2D.isVisible() || !((d2 = this.getAccessor().getMinValue(iTrace2D)) < d)) continue;
            d = d2;
        }
        if (d == Double.MAX_VALUE) {
            d = 0.0;
        }
        return d;
    }

    @Override
    public AChart2DDataAccessor getAccessor() {
        return this.m_accessor;
    }

    @Override
    public int getAxisPosition() {
        return this.m_axisPosition;
    }

    @Override
    public IAxis.AxisTitle getAxisTitle() {
        return this.m_axisTitle;
    }

    @Override
    public int getDimension() {
        int n = -1;
        if (this.m_accessor != null) {
            n = this.m_accessor.getDimension();
        }
        return n;
    }

    @Override
    public final IAxisLabelFormatter getFormatter() {
        return this.m_formatter;
    }

    @Override
    public final int getHeight(Graphics graphics) {
        return this.getAccessor().getHeight(graphics);
    }

    @Override
    public double getMajorTickSpacing() {
        return this.m_majorTickSpacing;
    }

    @Override
    public double getMax() {
        return this.getRangePolicy().getMax(this.m_min, this.m_max);
    }

    @Override
    public double getMaxValue() {
        return this.m_max;
    }

    @Override
    public double getMin() {
        return this.getRangePolicy().getMin(this.m_min, this.m_max);
    }

    @Override
    public double getMinorTickSpacing() {
        return this.m_minorTickSpacing;
    }

    @Override
    public double getMinValue() {
        return this.m_min;
    }

    @Override
    public final int getPixelXLeft() {
        return this.m_pixelXLeft;
    }

    @Override
    public final int getPixelXRight() {
        return this.m_pixelXRight;
    }

    @Override
    public final int getPixelYBottom() {
        return this.m_pixelYBottom;
    }

    @Override
    public final int getPixelYTop() {
        return this.m_pixelYTop;
    }

    @Override
    public PropertyChangeListener[] getPropertyChangeListeners(String string) {
        return this.m_propertyChangeSupport.getPropertyChangeListeners(string);
    }

    @Override
    public final Range getRange() {
        double d;
        double d2 = this.getMin();
        if (d2 == (d = this.getMax())) {
            d += 10.0;
        }
        this.m_reusedRange.setMax(d);
        this.m_reusedRange.setMin(d2);
        return this.m_reusedRange;
    }

    @Override
    public IRangePolicy getRangePolicy() {
        return this.m_rangePolicy;
    }

    @Override
    @Deprecated
    public final String getTitle() {
        return this.getAxisTitle().getTitle();
    }

    @Override
    @Deprecated
    public final IAxisTitlePainter getTitlePainter() {
        return this.getAxisTitle().getTitlePainter();
    }

    @Override
    public Set<ITrace2D> getTraces() {
        return this.m_traces;
    }

    protected final double getValueDistanceForPixel(int n) {
        return this.m_accessor.getValueDistanceForPixel(n);
    }

    @Override
    public final int getWidth(Graphics graphics) {
        return this.getAccessor().getWidth(graphics);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.m_accessor == null ? 0 : this.m_accessor.hashCode());
        n = 31 * n + this.m_axisPosition;
        n = 31 * n + (this.m_axisTitle == null ? 0 : this.m_axisTitle.hashCode());
        n = 31 * n + (this.m_formatter == null ? 0 : this.m_formatter.hashCode());
        long l = Double.doubleToLongBits(this.m_majorTickSpacing);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.m_max);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.m_min);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.m_minorTickSpacing);
        n = 31 * n + (int)(l ^ l >>> 32);
        n = 31 * n + (this.m_needsFullRescale ? 1231 : 1237);
        n = 31 * n + (this.m_paintGrid ? 1231 : 1237);
        n = 31 * n + (this.m_paintScale ? 1231 : 1237);
        n = 31 * n + this.m_pixelXLeft;
        n = 31 * n + this.m_pixelXRight;
        n = 31 * n + this.m_pixelYBottom;
        n = 31 * n + this.m_pixelYTop;
        n = 31 * n + (this.m_propertyChangeSupport == null ? 0 : this.m_propertyChangeSupport.hashCode());
        n = 31 * n + (this.m_rangePolicy == null ? 0 : this.m_rangePolicy.hashCode());
        n = 31 * n + (this.m_rangePreviousScaling == null ? 0 : this.m_rangePreviousScaling.hashCode());
        n = 31 * n + (this.m_reusedRange == null ? 0 : this.m_reusedRange.hashCode());
        n = 31 * n + (this.m_startMajorTick ? 1231 : 1237);
        n = 31 * n + (this.m_traces == null ? 0 : this.m_traces.hashCode());
        n = 31 * n + (this.m_visible ? 1231 : 1237);
        return n;
    }

    @Override
    public final boolean hasTrace(ITrace2D iTrace2D) {
        boolean bl = false;
        bl = this.m_traces.contains(iTrace2D);
        return bl;
    }

    @Override
    public void initPaintIteration() {
        this.m_formatter.initPaintIteration();
        this.m_axisScalePolicy.initPaintIteration(this);
    }

    @Override
    public final boolean isDirtyScaling() {
        boolean bl = this.m_needsFullRescale;
        if (!bl) {
            Range range = this.getRange();
            bl |= !range.equals(this.m_rangePreviousScaling);
        }
        return bl;
    }

    @Override
    public final boolean isPaintGrid() {
        return this.m_paintGrid;
    }

    @Override
    public final boolean isPaintScale() {
        return this.m_paintScale;
    }

    @Override
    public boolean isStartMajorTick() {
        return this.m_startMajorTick;
    }

    @Override
    public boolean isVisible() {
        return this.m_visible;
    }

    private void listen2Trace(ITrace2D iTrace2D) {
        if (this.getAccessor().getDimension() == 1) {
            iTrace2D.addPropertyChangeListener("ITrace2D.PROPERTY_MAX_X", this);
            iTrace2D.addPropertyChangeListener("ITrace2D.PROPERTY_MIN_X", this);
        } else {
            iTrace2D.addPropertyChangeListener("ITrace2D.PROPERTY_MAX_Y", this);
            iTrace2D.addPropertyChangeListener("ITrace2D.PROPERTY_MIN_Y", this);
        }
        iTrace2D.addPropertyChangeListener("ITrace2D.PROPERTY_COLOR", this);
        iTrace2D.addPropertyChangeListener("ITrace2D.PROPERTY_STROKE", this);
        iTrace2D.addPropertyChangeListener("ITrace2D.PROPERTY_VISIBLE", this);
        iTrace2D.addPropertyChangeListener("ITrace2D.PROPERTY_ZINDEX", this);
        iTrace2D.addPropertyChangeListener("ITrace2D.PROPERTY_PAINTERS", this);
        iTrace2D.addPropertyChangeListener("ITrace2D.PROPERTY_ERRORBARPOLICY", this);
        iTrace2D.addPropertyChangeListener("ITrace2D.PROPERTY_ERRORBARPOLICY_CONFIGURATION", this);
        iTrace2D.addPropertyChangeListener("ITrace2D.PROPERTY_ZINDEX", this);
        iTrace2D.addPropertyChangeListener("ITrace2D.PROPERTY_NAME", this);
        iTrace2D.addPropertyChangeListener("ITrace2D.PROPERTY_TRACEPOINT", this);
        iTrace2D.addPropertyChangeListener("ITrace2D.PROPERTY_POINT_CHANGED", this);
    }

    private void listenToAxisTitle(IAxis.AxisTitle axisTitle) {
        axisTitle.addPropertyChangeListener("IAxis.AxisTitle.PROPERTY_TITLE", this);
        axisTitle.addPropertyChangeListener("IAxis.AxisTitle.PROPERTY_TITLEFONT", this);
        axisTitle.addPropertyChangeListener("IAxis.AxisTitle.PROPERTY_TITLEPAINTER", this);
    }

    @Override
    public void paint(Graphics graphics) {
        if (!this.m_visible) {
            return;
        }
        switch (this.getDimension() | this.getAxisPosition()) {
            case 33: {
                this.paintAxisXBottom(graphics);
                break;
            }
            case 17: {
                this.paintAxisXTop(graphics);
                break;
            }
            case 6: {
                this.paintAxisYLeft(graphics);
                break;
            }
            case 10: {
                this.paintAxisYRight(graphics);
                break;
            }
            default: {
                throw new IllegalStateException("No valid Chart position found for this axis: " + this);
            }
        }
    }

    private void paintAxisXBottom(Graphics graphics) {
        Chart2D chart2D = this.getAccessor().getChart();
        int n = 0;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = fontMetrics.getHeight();
        int n3 = chart2D.getXChartStart();
        int n4 = chart2D.getXChartEnd();
        int n5 = chart2D.getYChartEnd();
        int n6 = n4 - n3;
        int n7 = this.getPixelYTop();
        graphics.drawLine(n3, n7, n4, n7);
        this.paintTitle(graphics);
        if (this.isPaintScale() || this.isPaintGrid()) {
            IAxisTickPainter iAxisTickPainter = chart2D.getAxisTickPainter();
            n = 0;
            List<LabeledValue> list = this.m_axisScalePolicy.getScaleValues(graphics, this);
            for (LabeledValue labeledValue : list) {
                n = n3 + (int)(labeledValue.getValue() * (double)n6);
                if (this.isPaintScale()) {
                    iAxisTickPainter.paintXTick(n, n7, labeledValue.isMajorTick(), true, graphics);
                    iAxisTickPainter.paintXLabel(n, n7 + n2, labeledValue.getLabel(), graphics);
                }
                if (!this.isPaintGrid() || n == n3) continue;
                graphics.setColor(chart2D.getGridColor());
                graphics.drawLine(n, n7 - 1, n, n5);
                graphics.setColor(chart2D.getForeground());
            }
        }
        graphics.drawString(this.getFormatter().getUnit().getUnitName(), n4, n7 + 4 + fontMetrics.getHeight() * 2);
    }

    private void paintAxisXTop(Graphics graphics) {
        Chart2D chart2D = this.getAccessor().getChart();
        int n = 0;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = chart2D.getXChartStart();
        int n3 = chart2D.getXChartEnd();
        int n4 = chart2D.getYChartStart();
        int n5 = n3 - n2;
        int n6 = this.getPixelYBottom();
        graphics.drawLine(n2, n6, n3, n6);
        this.paintTitle(graphics);
        if (this.isPaintScale() || this.isPaintGrid()) {
            n = 0;
            IAxisTickPainter iAxisTickPainter = chart2D.getAxisTickPainter();
            int n7 = iAxisTickPainter.getMajorTickLength();
            List<LabeledValue> list = this.m_axisScalePolicy.getScaleValues(graphics, this);
            for (LabeledValue labeledValue : list) {
                n = n2 + (int)(labeledValue.getValue() * (double)n5);
                if (this.isPaintScale()) {
                    iAxisTickPainter.paintXTick(n, n6, labeledValue.isMajorTick(), false, graphics);
                    iAxisTickPainter.paintXLabel(n, n6 - n7, labeledValue.getLabel(), graphics);
                }
                if (!this.isPaintGrid() || n == n2) continue;
                graphics.setColor(chart2D.getGridColor());
                graphics.drawLine(n, n6 + 1, n, n4);
                graphics.setColor(chart2D.getForeground());
            }
            graphics.drawString(this.getFormatter().getUnit().getUnitName(), n3, n6 - 4 - fontMetrics.getHeight());
        }
    }

    private void paintAxisYLeft(Graphics graphics) {
        Chart2D chart2D = this.getAccessor().getChart();
        int n = 0;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = chart2D.getXChartStart();
        int n3 = chart2D.getXChartEnd();
        int n4 = chart2D.getYChartStart();
        int n5 = chart2D.getYChartEnd();
        int n6 = n4 - n5;
        int n7 = this.getPixelXRight();
        graphics.drawLine(n7, n4, n7, n5);
        this.paintTitle(graphics);
        if (this.isPaintScale() || this.isPaintGrid()) {
            IAxisTickPainter iAxisTickPainter = chart2D.getAxisTickPainter();
            int n8 = iAxisTickPainter.getMajorTickLength();
            List<LabeledValue> list = this.m_axisScalePolicy.getScaleValues(graphics, this);
            for (LabeledValue labeledValue : list) {
                n = n4 - (int)(labeledValue.getValue() * (double)n6);
                if (this.isPaintScale()) {
                    iAxisTickPainter.paintYTick(n7, n, labeledValue.isMajorTick(), true, graphics);
                    iAxisTickPainter.paintYLabel(n7 - n8 - fontMetrics.stringWidth(labeledValue.getLabel()), n, labeledValue.getLabel(), graphics);
                }
                if (!this.isPaintGrid() || n == n4) continue;
                graphics.setColor(chart2D.getGridColor());
                graphics.drawLine(n2 + 1, n, n3, n);
                graphics.setColor(chart2D.getForeground());
            }
            String string = this.getFormatter().getUnit().getUnitName();
            graphics.drawString(string, 4, n5);
        }
    }

    private void paintAxisYRight(Graphics graphics) {
        Chart2D chart2D = this.getAccessor().getChart();
        int n = 0;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = chart2D.getXChartStart();
        int n3 = chart2D.getXChartEnd();
        int n4 = chart2D.getYChartStart();
        int n5 = chart2D.getYChartEnd();
        int n6 = n4 - n5;
        int n7 = this.getPixelXLeft();
        graphics.drawLine(n7, n4, n7, n5);
        this.paintTitle(graphics);
        if (this.isPaintScale() || this.isPaintGrid()) {
            IAxisTickPainter iAxisTickPainter = chart2D.getAxisTickPainter();
            List<LabeledValue> list = this.m_axisScalePolicy.getScaleValues(graphics, this);
            int n8 = iAxisTickPainter.getMajorTickLength() + 4;
            for (LabeledValue labeledValue : list) {
                n = n4 - (int)(labeledValue.getValue() * (double)n6);
                if (this.isPaintScale()) {
                    iAxisTickPainter.paintYTick(n7, n, labeledValue.isMajorTick(), false, graphics);
                    iAxisTickPainter.paintYLabel(n7 + n8, n, labeledValue.getLabel(), graphics);
                }
                if (!this.isPaintGrid() || n == n4) continue;
                graphics.setColor(chart2D.getGridColor());
                graphics.drawLine(n2 + 1, n, n3, n);
                graphics.setColor(chart2D.getForeground());
            }
            String string = this.getFormatter().getUnit().getUnitName();
            graphics.drawString(string, (int)chart2D.getSize().getWidth() - fontMetrics.charsWidth(string.toCharArray(), 0, string.length()) - 4, n5);
        }
    }

    @Override
    public int paintTitle(Graphics graphics) {
        int n = 0;
        IAxis.AxisTitle axisTitle = this.getAxisTitle();
        String string = axisTitle.getTitle();
        if (!StringUtil.isEmpty(string)) {
            IAxisTitlePainter iAxisTitlePainter = axisTitle.getTitlePainter();
            iAxisTitlePainter.paintTitle(this, graphics);
            int n2 = this.getDimension();
            switch (n2) {
                case 1: {
                    n = iAxisTitlePainter.getHeight(this, graphics);
                    break;
                }
                case 2: {
                    n = iAxisTitlePainter.getWidth(this, graphics);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Given axis.getDimension() is neither Chart2D.X nor Chart2D.Y!");
                }
            }
        }
        return n;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        IPropertyChangeReactor iPropertyChangeReactor = (IPropertyChangeReactor)propertyReactors.get(string);
        if (iPropertyChangeReactor != null) {
            iPropertyChangeReactor.propertyChange(propertyChangeEvent, this);
        }
    }

    @Override
    public final Set<ITrace2D> removeAllTraces() {
        TreeSet<ITrace2D> treeSet = new TreeSet<ITrace2D>();
        treeSet.addAll(this.m_traces);
        for (ITrace2D iTrace2D : treeSet) {
            this.removeTrace(iTrace2D);
        }
        return treeSet;
    }

    @Override
    public IAxis.AxisTitle removeAxisTitle() {
        IAxis.AxisTitle axisTitle = this.m_axisTitle;
        this.unListenToAxisTitle(this.m_axisTitle);
        this.m_axisTitle = null;
        return axisTitle;
    }

    @Override
    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.m_propertyChangeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    @Override
    public boolean removeTrace(ITrace2D iTrace2D) {
        boolean bl = this.m_traces.remove(iTrace2D);
        if (bl) {
            this.unlisten2Trace(iTrace2D);
            this.m_max = this.findMax();
            this.m_min = this.findMin();
            this.m_propertyChangeSupport.firePropertyChange("IAxis.PROPERTY_ADD_REMOVE_TRACE", iTrace2D, null);
        }
        return bl;
    }

    protected final void scalePoint(ITracePoint2D iTracePoint2D) {
        int n = this.getAccessor().getDimension();
        if (n == 1) {
            iTracePoint2D.setScaledX(this.getScaledValue(iTracePoint2D.getX()));
        } else if (n == 2) {
            iTracePoint2D.setScaledY(this.getScaledValue(iTracePoint2D.getY()));
        }
    }

    @Override
    public void scale() {
        for (ITrace2D iTrace2D : this.m_traces) {
            this.scaleTrace(iTrace2D);
        }
        this.m_rangePreviousScaling.mimic(this.getRange());
        this.m_needsFullRescale = false;
    }

    @Override
    public void scaleTrace(ITrace2D iTrace2D) {
        Range range = this.getRange();
        this.m_accessor.scaleTrace(iTrace2D, range);
    }

    protected final void setAccessor(AChart2DDataAccessor aChart2DDataAccessor) {
        this.m_accessor = aChart2DDataAccessor;
    }

    protected final synchronized void setAxisPosition(int n) {
        this.m_axisPosition = n;
    }

    @Override
    public void setAxisTitle(IAxis.AxisTitle axisTitle) {
        this.unListenToAxisTitle(this.m_axisTitle);
        this.m_axisTitle = axisTitle;
        this.listenToAxisTitle(this.m_axisTitle);
    }

    public void setChart(Chart2D chart2D, int n, int n2) {
        this.m_accessor = this.createAccessor(chart2D, n, n2);
        this.m_needsFullRescale = true;
    }

    @Override
    public void setFormatter(IAxisLabelFormatter iAxisLabelFormatter) {
        if (this.getAccessor() != null) {
            this.removePropertyChangeListener("IAxis.PROPERTY_LABELFORMATTER", this.getAccessor().getChart());
            this.addPropertyChangeListener("IAxis.PROPERTY_LABELFORMATTER", this.getAccessor().getChart());
            if (this.m_formatter != null) {
                this.m_formatter.removePropertyChangeListener("IAxisLabelFormatter.PROPERTY_FORMATCHANGE", this);
            }
            iAxisLabelFormatter.addPropertyChangeListener("IAxisLabelFormatter.PROPERTY_FORMATCHANGE", this);
        }
        IAxisLabelFormatter iAxisLabelFormatter2 = this.m_formatter;
        this.m_formatter = iAxisLabelFormatter;
        this.m_formatter.setAxis(this);
        this.m_propertyChangeSupport.firePropertyChange("IAxis.PROPERTY_LABELFORMATTER", iAxisLabelFormatter2, this.m_formatter);
    }

    @Override
    public void setMajorTickSpacing(double d) {
        this.m_majorTickSpacing = d;
    }

    @Override
    public void setMinorTickSpacing(double d) {
        this.m_minorTickSpacing = d;
    }

    @Override
    public final void setPaintGrid(boolean bl) {
        boolean bl2 = this.m_paintGrid;
        this.m_paintGrid = bl;
        if (bl2 != bl) {
            this.m_propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(this, "IAxis.PROPERTY_PAINTGRID", new Boolean(bl2), this.m_paintGrid));
        }
    }

    @Override
    public final void setPaintScale(boolean bl) {
        boolean bl2 = this.m_paintScale;
        this.m_paintScale = bl;
        if (bl2 != this.m_paintScale) {
            this.m_propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(this, "IAxis.PROPERTY_PAINTSCALE", new Boolean(bl2), this.m_paintGrid));
        }
    }

    @Override
    public final void setPixelXLeft(int n) {
        this.m_pixelXLeft = n;
    }

    @Override
    public final void setPixelXRight(int n) {
        this.m_pixelXRight = n;
    }

    @Override
    public final void setPixelYBottom(int n) {
        this.m_pixelYBottom = n;
    }

    @Override
    public final void setPixelYTop(int n) {
        this.m_pixelYTop = n;
    }

    @Override
    public final void setRange(Range range) {
        this.getRangePolicy().setRange(range);
    }

    protected final void ensureInitialized() {
        if (this.m_accessor == null) {
            throw new IllegalStateException("Add this axis to a chart first before this operation (undebuggable deadlocks might occur else)");
        }
    }

    @Override
    public void setRangePolicy(IRangePolicy iRangePolicy) {
        this.ensureInitialized();
        IRangePolicy iRangePolicy2 = this.getRangePolicy();
        double d = 0.0;
        double d2 = 0.0;
        if (iRangePolicy2 != null) {
            d = this.getMax();
            d2 = this.getMin();
            iRangePolicy2.removePropertyChangeListener(this.m_accessor.m_chart, "IRangePolicy.PROPERTY_RANGE");
            iRangePolicy2.removePropertyChangeListener(this.m_accessor.m_chart, "IRangePolicy.PROPERTY_RANGE");
            iRangePolicy2.removePropertyChangeListener(this.m_accessor.m_chart, "IRangePolicy.PROPERTY_RANGE");
        }
        this.m_rangePolicy = iRangePolicy;
        this.m_rangePolicy.addPropertyChangeListener("IRangePolicy.PROPERTY_RANGE", this.m_accessor.m_chart);
        this.m_rangePolicy.addPropertyChangeListener("IRangePolicy.PROPERTY_RANGE", this.m_accessor.m_chart);
        this.m_rangePolicy.addPropertyChangeListener("IRangePolicy.PROPERTY_RANGE", this.m_accessor.m_chart);
        if (d != 0.0 && d2 != 0.0 && (d != this.getMax() || d2 != this.getMin())) {
            this.m_accessor.m_chart.propertyChange(new PropertyChangeEvent(iRangePolicy, "IRangePolicy.PROPERTY_RANGE", new Range(d2, d), this.m_rangePolicy.getRange()));
        }
        this.m_propertyChangeSupport.firePropertyChange("IAxis.PROPERTY_RANGEPOLICY", iRangePolicy2, iRangePolicy);
    }

    @Override
    public void setStartMajorTick(boolean bl) {
        this.m_startMajorTick = bl;
    }

    @Override
    @Deprecated
    public final String setTitle(String string) {
        String string2 = this.getAxisTitle().setTitle(string);
        return string2;
    }

    @Override
    @Deprecated
    public final IAxisTitlePainter setTitlePainter(IAxisTitlePainter iAxisTitlePainter) {
        IAxisTitlePainter iAxisTitlePainter2 = this.getAxisTitle().setTitlePainter(iAxisTitlePainter);
        return iAxisTitlePainter2;
    }

    @Override
    public void setVisible(boolean bl) {
        this.m_visible = bl;
    }

    public double translateMousePosition(MouseEvent mouseEvent) throws IllegalArgumentException {
        return this.getAccessor().translateMousePosition(mouseEvent);
    }

    @Override
    public double translatePxToValue(int n) {
        return this.m_accessor.translatePxToValue(n);
    }

    @Override
    public final int translateValueToPx(double d) {
        return this.m_accessor.translateValueToPx(d);
    }

    private void unlisten2Trace(ITrace2D iTrace2D) {
        if (this.getAccessor().getDimension() == 1) {
            iTrace2D.removePropertyChangeListener("ITrace2D.PROPERTY_MAX_X", this);
            iTrace2D.removePropertyChangeListener("ITrace2D.PROPERTY_MIN_X", this);
        } else {
            iTrace2D.removePropertyChangeListener("ITrace2D.PROPERTY_MAX_Y", this);
            iTrace2D.removePropertyChangeListener("ITrace2D.PROPERTY_MIN_Y", this);
        }
        iTrace2D.removePropertyChangeListener("ITrace2D.PROPERTY_COLOR", this);
        iTrace2D.removePropertyChangeListener("ITrace2D.PROPERTY_STROKE", this);
        iTrace2D.removePropertyChangeListener("ITrace2D.PROPERTY_VISIBLE", this);
        iTrace2D.removePropertyChangeListener("ITrace2D.PROPERTY_ZINDEX", this);
        iTrace2D.removePropertyChangeListener("ITrace2D.PROPERTY_PAINTERS", this);
        iTrace2D.removePropertyChangeListener("ITrace2D.PROPERTY_ERRORBARPOLICY", this);
        iTrace2D.removePropertyChangeListener("ITrace2D.PROPERTY_ERRORBARPOLICY_CONFIGURATION", this);
        iTrace2D.removePropertyChangeListener("ITrace2D.PROPERTY_ZINDEX", this);
        iTrace2D.removePropertyChangeListener("ITrace2D.PROPERTY_NAME", this);
        iTrace2D.removePropertyChangeListener("ITrace2D.PROPERTY_TRACEPOINT", this);
        iTrace2D.removePropertyChangeListener("ITrace2D.PROPERTY_POINT_CHANGED", this);
    }

    private void unListenToAxisTitle(IAxis.AxisTitle axisTitle) {
        if (axisTitle != null) {
            axisTitle.removePropertyChangeListener("IAxis.AxisTitle.PROPERTY_TITLE", this);
            axisTitle.removePropertyChangeListener("IAxis.AxisTitle.PROPERTY_TITLEFONT", this);
            axisTitle.removePropertyChangeListener("IAxis.AxisTitle.PROPERTY_TITLEPAINTER", this);
        }
    }

    static {
        PropertyChangeRepainter propertyChangeRepainter = new PropertyChangeRepainter();
        propertyReactors.put("ITrace2D.PROPERTY_STROKE", propertyChangeRepainter);
        propertyReactors.put("ITrace2D.PROPERTY_STROKE", propertyChangeRepainter);
        propertyReactors.put("ITrace2D.PROPERTY_PAINTERS", propertyChangeRepainter);
        propertyReactors.put("ITrace2D.PROPERTY_COLOR", propertyChangeRepainter);
        propertyReactors.put("ITrace2D.PROPERTY_NAME", propertyChangeRepainter);
        propertyReactors.put("ITrace2D.PROPERTY_ERRORBARPOLICY", propertyChangeRepainter);
        propertyReactors.put("ITrace2D.PROPERTY_ERRORBARPOLICY_CONFIGURATION", propertyChangeRepainter);
        propertyReactors.put("ITrace2D.PROPERTY_ZINDEX", propertyChangeRepainter);
        propertyReactors.put("IAxis.PROPERTY_LABELFORMATTER", propertyChangeRepainter);
        propertyReactors.put("IAxisLabelFormatter.PROPERTY_FORMATCHANGE", propertyChangeRepainter);
        propertyReactors.put("IAxis.AxisTitle.PROPERTY_TITLEFONT", propertyChangeRepainter);
        propertyReactors.put("IAxis.AxisTitle.PROPERTY_TITLE", propertyChangeRepainter);
        propertyReactors.put("IAxis.AxisTitle.PROPERTY_TITLEPAINTER", propertyChangeRepainter);
        propertyReactors.put("ITrace2D.PROPERTY_MAX_X", new APropertyChangeReactorSynced(){

            @Override
            protected boolean propertyChangeSynced(PropertyChangeEvent propertyChangeEvent, AAxis<?> aAxis) {
                boolean bl = false;
                AChart2DDataAccessor aChart2DDataAccessor = aAxis.getAccessor();
                if (aChart2DDataAccessor.getDimension() == 1) {
                    double d = (Double)propertyChangeEvent.getNewValue();
                    if (d > aAxis.m_max) {
                        ITrace2D iTrace2D = (ITrace2D)propertyChangeEvent.getSource();
                        if (iTrace2D.isVisible()) {
                            aAxis.m_max = d;
                            aAxis.m_needsFullRescale = true;
                            bl = true;
                        }
                    } else if (d < aAxis.m_max) {
                        aAxis.m_max = aAxis.findMax();
                        aAxis.m_needsFullRescale = true;
                        bl = true;
                    }
                }
                return bl;
            }
        });
        propertyReactors.put("ITrace2D.PROPERTY_MIN_X", new APropertyChangeReactorSynced(){

            @Override
            protected boolean propertyChangeSynced(PropertyChangeEvent propertyChangeEvent, AAxis<?> aAxis) {
                boolean bl = false;
                if (aAxis.getAccessor().getDimension() == 1) {
                    double d = (Double)propertyChangeEvent.getNewValue();
                    if (d < aAxis.m_min) {
                        ITrace2D iTrace2D = (ITrace2D)propertyChangeEvent.getSource();
                        if (iTrace2D.isVisible()) {
                            aAxis.m_min = d;
                            aAxis.m_needsFullRescale = true;
                            bl = true;
                        }
                    } else if (d > aAxis.m_min) {
                        aAxis.m_min = aAxis.findMin();
                        aAxis.m_needsFullRescale = true;
                        bl = true;
                    }
                }
                return bl;
            }
        });
        propertyReactors.put("ITrace2D.PROPERTY_MAX_Y", new APropertyChangeReactorSynced(){

            @Override
            protected boolean propertyChangeSynced(PropertyChangeEvent propertyChangeEvent, AAxis<?> aAxis) {
                boolean bl = false;
                if (aAxis.getAccessor().getDimension() == 2) {
                    double d = (Double)propertyChangeEvent.getNewValue();
                    if (d > aAxis.m_max) {
                        ITrace2D iTrace2D = (ITrace2D)propertyChangeEvent.getSource();
                        if (iTrace2D.isVisible()) {
                            aAxis.m_max = d;
                            aAxis.m_needsFullRescale = true;
                            bl = true;
                        }
                    } else if (d < aAxis.m_max) {
                        aAxis.m_max = aAxis.findMax();
                        aAxis.m_needsFullRescale = true;
                        bl = true;
                    }
                }
                return bl;
            }
        });
        propertyReactors.put("ITrace2D.PROPERTY_MIN_Y", new APropertyChangeReactorSynced(){

            @Override
            protected boolean propertyChangeSynced(PropertyChangeEvent propertyChangeEvent, AAxis<?> aAxis) {
                boolean bl = false;
                if (aAxis.getAccessor().getDimension() == 2) {
                    double d = (Double)propertyChangeEvent.getNewValue();
                    if (d < aAxis.m_min) {
                        ITrace2D iTrace2D = (ITrace2D)propertyChangeEvent.getSource();
                        if (iTrace2D.isVisible()) {
                            aAxis.m_min = d;
                            aAxis.m_needsFullRescale = true;
                            bl = true;
                        }
                    } else if (d > aAxis.m_min) {
                        aAxis.m_min = aAxis.findMin();
                        aAxis.m_needsFullRescale = true;
                        bl = true;
                    }
                }
                return bl;
            }
        });
        propertyReactors.put("ITrace2D.PROPERTY_TRACEPOINT", new APropertyChangeReactorSynced(){

            @Override
            protected boolean propertyChangeSynced(PropertyChangeEvent propertyChangeEvent, AAxis<?> aAxis) {
                boolean bl = false;
                ITracePoint2D iTracePoint2D = (ITracePoint2D)propertyChangeEvent.getOldValue();
                ITracePoint2D iTracePoint2D2 = (ITracePoint2D)propertyChangeEvent.getNewValue();
                if (iTracePoint2D == null) {
                    aAxis.scalePoint(iTracePoint2D2);
                    bl = true;
                }
                return bl;
            }
        });
        propertyReactors.put("ITrace2D.PROPERTY_VISIBLE", new APropertyChangeReactorSynced(){

            @Override
            protected boolean propertyChangeSynced(PropertyChangeEvent propertyChangeEvent, AAxis<?> aAxis) {
                boolean bl = false;
                aAxis.m_max = aAxis.findMax();
                aAxis.m_min = aAxis.findMin();
                ITrace2D iTrace2D = (ITrace2D)propertyChangeEvent.getSource();
                aAxis.scaleTrace(iTrace2D);
                bl = true;
                return bl;
            }
        });
        propertyReactors.put("ITrace2D.PROPERTY_POINT_CHANGED", new APropertyChangeReactorSynced(){

            @Override
            protected boolean propertyChangeSynced(PropertyChangeEvent propertyChangeEvent, AAxis<?> aAxis) {
                boolean bl = false;
                ITracePoint2D iTracePoint2D = (ITracePoint2D)propertyChangeEvent.getNewValue();
                aAxis.scalePoint(iTracePoint2D);
                bl = true;
                return bl;
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class YDataAccessor
    extends AChart2DDataAccessor {
        private static final long serialVersionUID = -3665759247443586028L;

        public YDataAccessor(Chart2D chart2D) {
            super(chart2D);
        }

        @Override
        public final int getDimension() {
            return 2;
        }

        @Override
        public final int getHeight(Graphics graphics) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = fontMetrics.getHeight();
            return n += 4;
        }

        @Override
        protected final double getMaximumPixelForLabel(Graphics graphics) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = fontMetrics.getHeight();
            return n + 10;
        }

        @Override
        protected double getMaxValue(ITrace2D iTrace2D) {
            return iTrace2D.getMaxY();
        }

        @Override
        public final double getMinimumValueDistanceForLabels(Graphics graphics) {
            double d;
            Dimension dimension = this.m_chart.getSize();
            int n = (int)dimension.getHeight() - 40;
            if (n <= 0) {
                d = 1.0;
            } else {
                double d2 = AAxis.this.getMax() - AAxis.this.getMin();
                if (d2 == 0.0) {
                    d2 = 10.0;
                }
                double d3 = d2 / (double)n;
                d = d3 * this.getMaximumPixelForLabel(graphics);
            }
            return d;
        }

        @Override
        protected double getMinValue(ITrace2D iTrace2D) {
            return iTrace2D.getMinY();
        }

        @Override
        protected final int getPixelRange() {
            return this.m_chart.getYChartStart() - this.m_chart.getYChartEnd();
        }

        @Override
        protected double getValue(ITracePoint2D iTracePoint2D) {
            return iTracePoint2D.getY();
        }

        @Override
        protected final double getValueDistanceForPixel(int n) {
            double d;
            Dimension dimension = this.m_chart.getSize();
            int n2 = (int)dimension.getHeight() - 40;
            if (n2 <= 0) {
                d = -1.0;
            } else {
                double d2 = AAxis.this.getMaxValue() - AAxis.this.getMinValue();
                double d3 = d2 / (double)n2;
                d = d3 * (double)n;
            }
            return d;
        }

        @Override
        public final int getWidth(Graphics graphics) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = fontMetrics.charWidth('0');
            int n2 = n * AAxis.this.getFormatter().getMaxAmountChars();
            n2 += this.getChart().getAxisTickPainter().getMajorTickLength();
            return n2 += AAxis.this.getAxisTitle().getTitlePainter().getWidth(AAxis.this, graphics);
        }

        @Override
        protected void scaleTrace(ITrace2D iTrace2D, Range range) {
            if (iTrace2D.isVisible()) {
                double d = range.getExtent();
                Iterator<ITracePoint2D> iterator = iTrace2D.iterator();
                while (iterator.hasNext()) {
                    ITracePoint2D iTracePoint2D = iterator.next();
                    double d2 = iTracePoint2D.getY();
                    double d3 = (d2 - range.getMin()) / d;
                    if (!MathUtil.isDouble(d3)) {
                        d3 = 0.0;
                    }
                    iTracePoint2D.setScaledY(d3);
                }
            }
        }

        public String toString() {
            return "Y";
        }

        @Override
        public double translateMousePosition(MouseEvent mouseEvent) {
            return this.translatePxToValue(mouseEvent.getY());
        }

        @Override
        public double translatePxToValue(int n) {
            double d = 0.0;
            double d2 = this.m_chart.getYChartStart() - n;
            int n2 = this.m_chart.getYChartStart() - this.m_chart.getYChartEnd();
            if (n2 != 0) {
                double d3 = d2 / (double)n2;
                Range range = AAxis.this.getRange();
                d = d3 * range.getExtent() + range.getMin();
            }
            return d;
        }

        @Override
        public int translateValueToPx(double d) {
            int n = 0;
            Range range = AAxis.this.getRange();
            double d2 = (d - range.getMin()) / range.getExtent();
            int n2 = this.getPixelRange();
            if (n2 != 0) {
                n = (int)Math.round((double)this.m_chart.getYChartStart() - d2 * (double)n2);
            }
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class XDataAccessor
    extends AChart2DDataAccessor {
        private static final long serialVersionUID = 1185826702304621485L;

        public XDataAccessor(Chart2D chart2D) {
            super(chart2D);
        }

        @Override
        public int getDimension() {
            return 1;
        }

        @Override
        public int getHeight(Graphics graphics) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = fontMetrics.getHeight();
            n += this.getChart().getAxisTickPainter().getMajorTickLength();
            return n += AAxis.this.getAxisTitle().getTitlePainter().getHeight(AAxis.this, graphics);
        }

        @Override
        protected final double getMaximumPixelForLabel(Graphics graphics) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = fontMetrics.charWidth('0');
            int n2 = AAxis.this.getFormatter().getMaxAmountChars();
            return n * (n2 + 2);
        }

        @Override
        protected double getMaxValue(ITrace2D iTrace2D) {
            return iTrace2D.getMaxX();
        }

        @Override
        public final double getMinimumValueDistanceForLabels(Graphics graphics) {
            double d;
            Dimension dimension = this.m_chart.getSize();
            int n = (int)dimension.getWidth() - 60;
            if (n <= 0) {
                d = 1.0;
            } else {
                double d2 = AAxis.this.getMax() - AAxis.this.getMin();
                if (d2 == 0.0) {
                    d2 = 10.0;
                }
                double d3 = d2 / (double)n;
                d = d3 * this.getMaximumPixelForLabel(graphics);
            }
            return d;
        }

        @Override
        protected double getMinValue(ITrace2D iTrace2D) {
            return iTrace2D.getMinX();
        }

        @Override
        protected int getPixelRange() {
            return this.m_chart.getXChartEnd() - this.m_chart.getXChartStart();
        }

        @Override
        protected double getValue(ITracePoint2D iTracePoint2D) {
            return iTracePoint2D.getX();
        }

        @Override
        protected final double getValueDistanceForPixel(int n) {
            double d;
            Dimension dimension = this.m_chart.getSize();
            int n2 = (int)dimension.getWidth() - 60;
            if (n2 <= 0) {
                d = -1.0;
            } else {
                double d2 = AAxis.this.getMax() - AAxis.this.getMin();
                double d3 = d2 / (double)n2;
                d = d3 * (double)n;
            }
            return d;
        }

        @Override
        public int getWidth(Graphics graphics) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = fontMetrics.charWidth('0');
            int n2 = AAxis.this.getFormatter().getMaxAmountChars() * n;
            return n2;
        }

        @Override
        protected void scaleTrace(ITrace2D iTrace2D, Range range) {
            double d = range.getExtent();
            if (iTrace2D.isVisible()) {
                Iterator<ITracePoint2D> iterator = iTrace2D.iterator();
                while (iterator.hasNext()) {
                    ITracePoint2D iTracePoint2D = iterator.next();
                    double d2 = iTracePoint2D.getX();
                    double d3 = (d2 - range.getMin()) / d;
                    if (!MathUtil.isDouble(d3)) {
                        d3 = 0.0;
                    }
                    iTracePoint2D.setScaledX(d3);
                }
            }
        }

        public String toString() {
            return "X";
        }

        @Override
        public final double translateMousePosition(MouseEvent mouseEvent) {
            return this.translatePxToValue(mouseEvent.getX());
        }

        @Override
        public double translatePxToValue(int n) {
            double d = 0.0;
            double d2 = n - this.m_chart.getXChartStart();
            int n2 = this.m_chart.getXChartEnd() - this.m_chart.getXChartStart();
            if (n2 != 0) {
                double d3 = d2 / (double)n2;
                Range range = AAxis.this.getRange();
                d = d3 * range.getExtent() + range.getMin();
            }
            return d;
        }

        @Override
        public int translateValueToPx(double d) {
            int n = 0;
            Range range = AAxis.this.getRange();
            double d2 = (d - range.getMin()) / range.getExtent();
            int n2 = this.getPixelRange();
            if (n2 != 0) {
                double d3 = d2 * (double)n2 + (double)this.m_chart.getXChartStart();
                n = (int)Math.round(d3);
            }
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PropertyChangeRepainter
    implements IPropertyChangeReactor {
        protected PropertyChangeRepainter() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent, AAxis<?> aAxis) {
            Chart2D chart2D;
            AChart2DDataAccessor aChart2DDataAccessor = aAxis.getAccessor();
            if (aChart2DDataAccessor != null && (chart2D = aChart2DDataAccessor.getChart()) != null) {
                chart2D.setRequestedRepaint(true);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface IPropertyChangeReactor {
        public void propertyChange(PropertyChangeEvent var1, AAxis<?> var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class APropertyChangeReactorSynced
    implements IPropertyChangeReactor {
        protected APropertyChangeReactorSynced() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void propertyChange(PropertyChangeEvent propertyChangeEvent, AAxis<?> aAxis) {
            Chart2D chart2D;
            Chart2D chart2D2 = chart2D = aAxis.getAccessor().getChart();
            synchronized (chart2D2) {
                boolean bl = this.propertyChangeSynced(propertyChangeEvent, aAxis);
                if (bl) {
                    chart2D.setRequestedRepaint(true);
                }
            }
        }

        protected abstract boolean propertyChangeSynced(PropertyChangeEvent var1, AAxis<?> var2);
    }

    public abstract class AChart2DDataAccessor
    implements Serializable {
        private static final long serialVersionUID = 5023422232812082122L;
        protected Chart2D m_chart;

        protected AChart2DDataAccessor(Chart2D chart2D) {
            AAxis.this.setAccessor(this);
            this.m_chart = chart2D;
        }

        public final Chart2D getChart() {
            return this.m_chart;
        }

        public abstract int getDimension();

        public abstract int getHeight(Graphics var1);

        protected abstract double getMaximumPixelForLabel(Graphics var1);

        protected abstract double getMaxValue(ITrace2D var1);

        public abstract double getMinimumValueDistanceForLabels(Graphics var1);

        protected abstract double getMinValue(ITrace2D var1);

        protected abstract int getPixelRange();

        protected abstract double getValue(ITracePoint2D var1);

        protected abstract double getValueDistanceForPixel(int var1);

        public abstract int getWidth(Graphics var1);

        protected abstract void scaleTrace(ITrace2D var1, Range var2);

        public abstract double translateMousePosition(MouseEvent var1);

        public abstract double translatePxToValue(int var1);

        public abstract int translateValueToPx(double var1);
    }
}

