/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.annotations.bubble;

import info.monitorenter.gui.chart.annotations.AAnnotationContentComponent;
import info.monitorenter.gui.chart.views.ChartPanel;
import info.monitorenter.util.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class AnnotationBubble
extends JPanel {
    public static final int PADDING = 8;
    private DragListener m_dragListener;
    private boolean m_outlineDragMode = true;
    private static final long serialVersionUID = -3668420139916533725L;
    protected ChartPanel m_chartPanel;
    protected AAnnotationContentComponent m_content;
    protected JComponent m_titleBar;

    public AnnotationBubble(ChartPanel chartPanel, AAnnotationContentComponent aAnnotationContentComponent, boolean bl, boolean bl2) {
        this.m_chartPanel = chartPanel;
        this.m_content = aAnnotationContentComponent;
        this.setBackground(new Color(255, 254, 233, 136));
        this.m_dragListener = new DragListener();
        this.setLayout(new BoxLayout(this, 1));
        if (bl2) {
            this.m_titleBar = new AnnotationTitleBar();
            this.add(this.m_titleBar);
        }
        this.calculateSize();
        if (bl) {
            aAnnotationContentComponent.addMouseMotionListener(this.m_dragListener);
            aAnnotationContentComponent.addMouseListener(this.m_dragListener);
            aAnnotationContentComponent.setBackground(this.getBackground());
        }
        this.add(aAnnotationContentComponent);
        this.add(Box.createVerticalStrut(8));
    }

    private void calculateSize() {
        Dimension dimension = this.m_content.getPreferredSize();
        double d = dimension.getWidth() + 4.0;
        double d2 = dimension.getHeight() + 4.0;
        if (this.m_titleBar != null) {
            d2 += this.m_titleBar.getPreferredSize().getHeight();
        }
        this.setSize(new Dimension((int)d, (int)d2));
    }

    public boolean isDragged() {
        boolean bl = null != this.m_dragListener.m_lastDragPosition;
        return bl;
    }

    public final boolean isOutlineDragMode() {
        return this.m_outlineDragMode;
    }

    public final void paint(Graphics graphics) {
        super.paint(graphics);
    }

    protected void paintComponent(Graphics graphics) {
        Color color = graphics.getColor();
        graphics.setColor(Color.BLACK);
        Dimension dimension = this.getSize();
        graphics.drawRoundRect(0, 0, dimension.width - 1, dimension.height - 1, 10, 10);
        if (!this.isDragged() || !this.isOutlineDragMode()) {
            graphics.setColor(this.getBackground());
            graphics.fillRoundRect(1, 1, dimension.width - 2, dimension.height - 2, 8, 8);
        }
        graphics.setColor(color);
    }

    public final void setOutlineDragMode(boolean bl) {
        this.m_outlineDragMode = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransparency(double d) {
        assert (d >= 0.0 && d < 1.0);
        Color color = this.getBackground();
        AnnotationBubble annotationBubble = this;
        synchronized (annotationBubble) {
            if (d != 0.0) {
                int n = (int)d * 255;
                if (color.getAlpha() != n) {
                    this.setBackground(new Color(color.getRed(), color.getGreen(), color.getBlue(), n));
                }
            } else if (color.getAlpha() > 0) {
                this.setBackground(new Color(color.getRed(), color.getGreen(), color.getBlue()));
            }
        }
    }

    public class DragListener
    implements MouseMotionListener,
    MouseListener {
        protected Point m_lastDragPosition;

        protected DragListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.m_lastDragPosition != null) {
                Point point = UIUtil.getLocationOnScreen(mouseEvent);
                double d = point.getX() - this.m_lastDragPosition.getX();
                double d2 = point.getY() - this.m_lastDragPosition.getY();
                Point point2 = AnnotationBubble.this.getLocation();
                point2.x = (int)((double)point2.x + d);
                point2.y = (int)((double)point2.y + d2);
                AnnotationBubble.this.setLocation(point2);
                this.m_lastDragPosition = point;
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.m_lastDragPosition = UIUtil.getLocationOnScreen(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.m_lastDragPosition = null;
            AnnotationBubble.this.repaint();
        }
    }

    public class AnnotationTitleBar
    extends JPanel {
        private static final long serialVersionUID = 4182197132940971837L;
        private JButton m_closeButton;

        public AnnotationTitleBar() {
            this.setOpaque(true);
            this.setBackground(AnnotationBubble.this.getBackground());
            DragListener dragListener = AnnotationBubble.this.m_dragListener;
            this.addMouseListener(dragListener);
            this.addMouseMotionListener(dragListener);
            AbstractAction abstractAction = new AbstractAction(){
                private static final long serialVersionUID = 800535446184152788L;

                public void actionPerformed(ActionEvent actionEvent) {
                    AnnotationBubble.this.setVisible(false);
                    AnnotationBubble.this.m_chartPanel.remove(AnnotationBubble.this);
                }
            };
            Icon icon = UIManager.getIcon("InternalFrame.closeIcon");
            abstractAction.putValue("SmallIcon", icon);
            this.m_closeButton = new JButton(abstractAction);
            this.m_closeButton.setContentAreaFilled(false);
            this.m_closeButton.setBorderPainted(false);
            this.m_closeButton.setFocusable(false);
            this.setLayout(new BoxLayout(this, 0));
            this.add(Box.createHorizontalGlue());
            this.add(this.m_closeButton);
        }

        public Dimension getPreferredSize() {
            Dimension dimension = null;
            if (this.isPreferredSizeSet()) {
                dimension = super.getPreferredSize();
            } else {
                Dimension dimension2 = this.m_closeButton.getPreferredSize();
                Font font = this.getFont();
                FontMetrics fontMetrics = this.getFontMetrics(font);
                int n = fontMetrics.getHeight();
                int n2 = (int)dimension2.getHeight();
                int n3 = Math.max(n, n2);
                dimension = new Dimension((int)dimension2.getWidth(), n3);
            }
            return dimension;
        }

        public final void paint(Graphics graphics) {
            super.paint(graphics);
        }

        protected final void paintBorder(Graphics graphics) {
            super.paintBorder(graphics);
        }

        protected final void paintChildren(Graphics graphics) {
            super.paintChildren(graphics);
        }

        protected void paintComponent(Graphics graphics) {
            Color color = graphics.getColor();
            graphics.setColor(Color.BLACK);
            Dimension dimension = this.getSize();
            graphics.drawRoundRect(0, 0, dimension.width - 1, dimension.height + 10, 10, 10);
            if (!AnnotationBubble.this.isDragged() || !AnnotationBubble.this.isOutlineDragMode()) {
                graphics.setColor(this.getBackground());
                graphics.fillRoundRect(1, 1, dimension.width - 2, dimension.height + 10, 10, 10);
            }
            graphics.setColor(color);
        }
    }
}

