/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.annotations;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.ITracePoint2D;
import info.monitorenter.gui.chart.annotations.AAnnotationContentComponent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JTextField;

public final class AnnotationContentComponentDataValues
extends AAnnotationContentComponent {
    private static final int PADDING = 8;
    private static final long serialVersionUID = 5288884368670766243L;
    private JTextField m_textfield = new JTextField();

    public AnnotationContentComponentDataValues(ITracePoint2D iTracePoint2D) {
        super(iTracePoint2D);
        this.m_textfield.setEditable(false);
        this.setLayout(new BoxLayout(this, 0));
        this.add(Box.createHorizontalStrut(8));
        this.add(this.m_textfield);
        this.add(Box.createHorizontalStrut(8));
        this.updateDataValueTextField();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.m_textfield.getPreferredSize();
        dimension.height += 16;
        dimension.width += 16;
        return dimension;
    }

    public void paintAnnotation(Graphics graphics, Chart2D chart2D, ITrace2D iTrace2D, ITracePoint2D iTracePoint2D) {
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.m_textfield != null) {
            this.m_textfield.setBackground(color);
        }
    }

    private void updateDataValueTextField() {
        ITracePoint2D iTracePoint2D = this.getAnnotatedPoint();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(").append(iTracePoint2D.getX()).append(", ").append(iTracePoint2D.getY()).append(')');
        String string = stringBuilder.toString();
        FontMetrics fontMetrics = this.getFontMetrics(this.m_textfield.getFont());
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.getHeight();
        this.m_textfield.setText(stringBuilder.toString());
    }
}

