/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.IAxis;
import info.monitorenter.gui.chart.IRangePolicy;
import info.monitorenter.gui.chart.rangepolicies.RangePolicyFixedViewport;
import info.monitorenter.gui.chart.rangepolicies.RangePolicyUnbounded;
import info.monitorenter.util.Range;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZoomableChart
extends Chart2D
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 8799808716942023907L;
    private int m_lastPressedButton;
    private Point2D m_startPoint;
    private IRangePolicy m_zoomAllRangePolicy = new RangePolicyUnbounded();
    private Rectangle2D m_zoomArea;

    public ZoomableChart() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.m_lastPressedButton != 1) {
            return;
        }
        if (mouseEvent.getY() >= 20 && mouseEvent.getY() <= this.getYChartStart() && mouseEvent.getX() >= 20 && mouseEvent.getX() <= this.getXChartEnd()) {
            double d;
            double d2;
            double d3;
            double d4;
            if ((double)mouseEvent.getX() > this.m_startPoint.getX()) {
                d4 = this.m_startPoint.getX();
                d3 = mouseEvent.getX();
            } else {
                d4 = mouseEvent.getX();
                d3 = this.m_startPoint.getX();
            }
            if (d4 < (double)this.getXChartStart()) {
                d4 = this.getXChartStart();
            }
            if (d3 > (double)(this.getWidth() - 20)) {
                d3 = this.getWidth() - 20;
            }
            if ((double)mouseEvent.getY() > this.m_startPoint.getY()) {
                d2 = this.m_startPoint.getY();
                d = mouseEvent.getY();
            } else {
                d2 = mouseEvent.getY();
                d = this.m_startPoint.getY();
            }
            if (d2 > (double)this.getYChartStart()) {
                d2 = this.getYChartStart();
            }
            if (d > (double)(this.getHeight() - 20)) {
                d = this.getHeight() - 20;
            }
            double d5 = d3 - d4;
            double d6 = d - d2;
            this.m_zoomArea = new Rectangle2D.Double(d4, d2, d5, d6);
            this.setRequestedRepaint(true);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.m_startPoint = new Point2D.Double(mouseEvent.getX(), mouseEvent.getY());
        this.m_lastPressedButton = mouseEvent.getButton();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.m_zoomArea != null) {
            double d = this.m_zoomArea.getX();
            double d2 = this.m_zoomArea.getX() + this.m_zoomArea.getWidth();
            double d3 = this.m_zoomArea.getY();
            double d4 = this.m_zoomArea.getY() + this.m_zoomArea.getHeight();
            if (d2 - d < 20.0 || d4 - d3 < 20.0) {
                this.m_zoomArea = null;
                this.setRequestedRepaint(true);
                return;
            }
            List<IAxis<?>> list = this.getAxes();
            for (IAxis<?> iAxis : list) {
                if (32 == iAxis.getAxisPosition() || 16 == iAxis.getAxisPosition()) {
                    this.zoom(iAxis, d, d2);
                }
                if (4 != iAxis.getAxisPosition() && 8 != iAxis.getAxisPosition()) continue;
                this.zoom(iAxis, d3, d4);
            }
        }
    }

    @Override
    protected synchronized void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.m_zoomArea != null) {
            graphics2D.draw(this.m_zoomArea);
            graphics2D.setPaint(new Color(255, 255, 0, 100));
            graphics2D.fill(this.m_zoomArea);
        }
    }

    public void zoom(double d, double d2) {
        this.m_zoomArea = null;
        IAxis<?> iAxis = this.getAxisX();
        RangePolicyFixedViewport rangePolicyFixedViewport = new RangePolicyFixedViewport(new Range(d, d2));
        iAxis.setRangePolicy(rangePolicyFixedViewport);
    }

    public void zoom(IAxis<?> iAxis, double d, double d2) {
        this.m_zoomArea = null;
        double d3 = iAxis.translatePxToValue((int)d);
        double d4 = iAxis.translatePxToValue((int)d2);
        RangePolicyFixedViewport rangePolicyFixedViewport = new RangePolicyFixedViewport(new Range(d3, d4));
        iAxis.setRangePolicy(rangePolicyFixedViewport);
    }

    public void zoom(double d, double d2, double d3, double d4) {
        this.m_zoomArea = null;
        IAxis<?> iAxis = this.getAxisX();
        RangePolicyFixedViewport rangePolicyFixedViewport = new RangePolicyFixedViewport(new Range(d, d2));
        iAxis.setRangePolicy(rangePolicyFixedViewport);
        IAxis<?> iAxis2 = this.getAxisY();
        RangePolicyFixedViewport rangePolicyFixedViewport2 = new RangePolicyFixedViewport(new Range(d3, d4));
        iAxis2.setRangePolicy(rangePolicyFixedViewport2);
    }

    public void zoomAll() {
        List<IAxis<?>> list = this.getAxes();
        for (IAxis<?> iAxis : list) {
            iAxis.setRangePolicy(this.m_zoomAllRangePolicy);
        }
    }
}

