/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.ICodeBlock;
import info.monitorenter.gui.chart.IPointPainter;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.ITracePoint2D;
import java.awt.geom.Point2D;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TracePoint2D
extends Point2D.Double
implements ITracePoint2D {
    private static final long serialVersionUID = 3618980079204512309L;
    private Set<IPointPainter<?>> m_additionalPointPainters = new LinkedHashSet();
    private ITrace2D m_listener;
    private double m_scaledX;
    private double m_scaledY;
    private double m_x;
    private double m_y;

    protected TracePoint2D() {
    }

    public TracePoint2D(double d, double d2) {
        this.m_x = d;
        this.m_y = d2;
    }

    @Override
    public final boolean addAdditionalPointPainter(final IPointPainter<?> iPointPainter) {
        Boolean bl = this.doSynchronized(new ICodeBlock<Boolean>(){

            @Override
            public Boolean execute() {
                boolean bl = TracePoint2D.this.m_additionalPointPainters.add(iPointPainter);
                if (bl && TracePoint2D.this.m_listener != null) {
                    TracePoint2D.this.m_listener.firePointChanged(TracePoint2D.this, 4);
                }
                return bl;
            }
        });
        return bl;
    }

    @Override
    public Object clone() {
        TracePoint2D tracePoint2D = (TracePoint2D)super.clone();
        tracePoint2D.m_x = this.m_x;
        tracePoint2D.m_y = this.m_y;
        tracePoint2D.m_scaledX = this.m_scaledX;
        tracePoint2D.m_scaledY = this.m_scaledY;
        tracePoint2D.m_additionalPointPainters = new LinkedHashSet(this.m_additionalPointPainters);
        return tracePoint2D;
    }

    @Override
    public int compareTo(ITracePoint2D iTracePoint2D) {
        double d = iTracePoint2D.getX();
        int n = this.m_x < d ? -1 : (this.m_x == d ? 0 : 1);
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TracePoint2D tracePoint2D = (TracePoint2D)object;
        if (Double.doubleToLongBits(this.m_x) != Double.doubleToLongBits(tracePoint2D.m_x)) {
            return false;
        }
        return Double.doubleToLongBits(this.m_y) == Double.doubleToLongBits(tracePoint2D.m_y);
    }

    @Override
    public final Set<IPointPainter<?>> getAdditionalPointPainters() {
        return this.m_additionalPointPainters;
    }

    @Override
    public double getEuclidDistance(double d, double d2) {
        double d3 = Math.abs(this.m_scaledX - d);
        double d4 = Math.abs(this.m_scaledY - d2);
        double d5 = Math.sqrt(Math.pow(d3, 2.0) + Math.pow(d4, 2.0));
        return d5;
    }

    @Override
    public ITrace2D getListener() {
        return this.m_listener;
    }

    @Override
    public double getManhattanDistance(double d, double d2) {
        double d3 = Math.abs(this.m_scaledX - d) + Math.abs(this.m_scaledY - d2);
        return d3;
    }

    @Override
    public double getManhattanDistance(ITracePoint2D iTracePoint2D) {
        return this.getManhattanDistance(iTracePoint2D.getX(), iTracePoint2D.getY());
    }

    @Override
    public final double getScaledX() {
        return this.m_scaledX;
    }

    @Override
    public final double getScaledY() {
        return this.m_scaledY;
    }

    @Override
    public double getX() {
        return this.m_x;
    }

    @Override
    public double getY() {
        return this.m_y;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        long l = Double.doubleToLongBits(this.m_x);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.m_y);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    @Override
    public void setListener(ITrace2D iTrace2D) {
        this.m_listener = iTrace2D;
    }

    @Override
    public void setLocation(final double d, final double d2) {
        this.doSynchronized(new ICodeBlock<Object>(){

            @Override
            public Object execute() {
                TracePoint2D.this.m_x = d;
                TracePoint2D.this.m_y = d2;
                if (TracePoint2D.this.m_listener != null) {
                    TracePoint2D.this.m_listener.firePointChanged(TracePoint2D.this, 4);
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T doSynchronized(ICodeBlock<T> iCodeBlock) {
        T t;
        if (this.m_listener != null) {
            Chart2D chart2D = this.m_listener.getRenderer();
            if (chart2D != null) {
                Chart2D chart2D2 = chart2D;
                synchronized (chart2D2) {
                    ITrace2D iTrace2D = this.m_listener;
                    synchronized (iTrace2D) {
                        t = iCodeBlock.execute();
                    }
                }
            }
            ITrace2D iTrace2D = this.m_listener;
            synchronized (iTrace2D) {
                t = iCodeBlock.execute();
            }
        }
        t = iCodeBlock.execute();
        return t;
    }

    @Override
    public final void setScaledX(double d) {
        this.m_scaledX = d;
    }

    @Override
    public final void setScaledY(double d) {
        this.m_scaledY = d;
    }

    @Override
    public String toString() {
        return "TracePoint2D[" + this.m_x + ", " + this.m_y + "]";
    }

    @Override
    public boolean removeAdditionalPointPainter(final IPointPainter<?> iPointPainter) {
        Boolean bl = this.doSynchronized(new ICodeBlock<Boolean>(){

            @Override
            public Boolean execute() {
                boolean bl = TracePoint2D.this.m_additionalPointPainters.remove(iPointPainter);
                if (bl && TracePoint2D.this != null) {
                    TracePoint2D.this.m_listener.firePointChanged(TracePoint2D.this, 4);
                }
                return bl;
            }
        });
        return bl;
    }

    @Override
    public Set<IPointPainter<?>> removeAllAdditionalPointPainters() {
        return (Set)this.doSynchronized(new ICodeBlock<Set<IPointPainter<?>>>(){

            @Override
            public Set<IPointPainter<?>> execute() {
                Set set = TracePoint2D.this.m_additionalPointPainters;
                TracePoint2D.this.m_additionalPointPainters = new LinkedHashSet();
                if (TracePoint2D.this != null) {
                    TracePoint2D.this.m_listener.firePointChanged(TracePoint2D.this, 4);
                }
                return set;
            }
        });
    }
}

