/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart;

import info.monitorenter.gui.chart.IAxis;
import info.monitorenter.gui.chart.IAxisLabelFormatter;
import info.monitorenter.gui.chart.IAxisTickPainter;
import info.monitorenter.gui.chart.IErrorBarPolicy;
import info.monitorenter.gui.chart.IPointFinder;
import info.monitorenter.gui.chart.IPointPainter;
import info.monitorenter.gui.chart.IRangePolicy;
import info.monitorenter.gui.chart.IToolTipType;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.ITracePainter;
import info.monitorenter.gui.chart.ITracePoint2D;
import info.monitorenter.gui.chart.ITracePointProvider;
import info.monitorenter.gui.chart.TracePointProviderDefault;
import info.monitorenter.gui.chart.axis.AAxis;
import info.monitorenter.gui.chart.axis.AxisLinear;
import info.monitorenter.gui.chart.axistickpainters.AxisTickPainterDefault;
import info.monitorenter.gui.chart.events.Chart2DActionPrintSingleton;
import info.monitorenter.util.Range;
import info.monitorenter.util.StringUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Chart2D
extends JPanel
implements PropertyChangeListener,
Iterable<ITrace2D>,
Printable {
    public static final String[] AXIX_CONSTANT_NAMES = new String[]{"dummy", "X", "Y", "X,Y"};
    public static final int CHART_POSITION_BOTTOM = 32;
    public static final int CHART_POSITION_LEFT = 4;
    public static final int CHART_POSITION_RIGHT = 8;
    public static final int CHART_POSITION_TOP = 16;
    public static final boolean DEBUG_SCALING = false;
    public static final boolean DEBUG_HIGHLIGHTING = false;
    public static final boolean DEBUG_THREADING = false;
    public static final String PROPERTY_ANTIALIASING_ENABLED = "Chart2D.PROPERTY_ANTIALIASING_ENABLED";
    public static final String PROPERTY_AXIS_X = "Chart2D.PROPERTY_AXIS_X";
    public static final String PROPERTY_AXIS_X_BOTTOM_REPLACE = "Chart2D.PROPERTY_AXIS_X_BOTTOM_REPLACE";
    public static final String PROPERTY_AXIS_X_TOP_REPLACE = "Chart2D.PROPERTY_AXIS_X_TOP_REPLACE";
    public static final String PROPERTY_AXIS_Y = "Chart2D.PROPERTY_AXIS_Y";
    public static final String PROPERTY_AXIS_Y_LEFT_REPLACE = "Chart2D.PROPERTY_AXIS_Y_LEFT_REPLACE";
    public static final String PROPERTY_AXIS_Y_RIGHT_REPLACE = "Chart2D.PROPERTY_AXIS_Y_RIGHT_REPLACE";
    public static final String PROPERTY_BACKGROUND_COLOR = "background";
    public static final String PROPERTY_FONT = "font";
    public static final String PROPERTY_FOREGROUND_COLOR = "foreground";
    public static final String PROPERTY_GRID_COLOR = "Chart2D.PROPERTY_GRID_COLOR";
    public static final String PROPERTY_ADD_REMOVE_TRACE = "IAxis.PROPERTY_ADD_REMOVE_TRACE";
    public static final String PROPERTY_PAINTLABELS = "Chart2D.PROPERTY_PAINTLABELS";
    public static final String PROPERTY_POINT_HIGHLIGHTING_ENABLED = "Chart2D.PROPERTY_POINT_HIGHLIGHTING_ENABLED";
    public static final String PROPERTY_POINTFINDER = "Chart2D.POINTFINDER";
    public static final String PROPERTY_TOOLTIP_TYPE = "Chart2D.PROPERTY_TOOLTIP_TYPE";
    private static final long serialVersionUID = 3978425840633852978L;
    public static final int X = 1;
    public static final int X_Y = 3;
    public static final int Y = 2;
    private List<IAxis<?>> m_axesXBottom;
    private List<IAxis<?>> m_axesXTop;
    private List<IAxis<?>> m_axesYLeft;
    private List<IAxis<?>> m_axesYRight;
    private IAxisTickPainter m_axisTickPainter;
    private Color m_gridcolor = Color.lightGray;
    protected int m_minPaintLatency = 50;
    private AAxis<?> m_mouseTranslationXAxis;
    private AAxis<?> m_mouseTranslationYAxis;
    private transient PageFormat m_pageFormat;
    private boolean m_paintLabels = true;
    private IPointFinder m_pointFinder = PointFinder.EUCLID;
    private final PointHighlighter m_pointHighlightListener = new PointHighlighter();
    private Timer m_repainter;
    private boolean m_requestedRepaint;
    private boolean m_synchronizedXStart = false;
    private Chart2D m_synchronizedXStartChart;
    private IToolTipType m_toolTip = ToolTipType.NONE;
    private int m_traceHighlighterCount = 0;
    private ITracePointProvider m_tracePointProvider;
    private boolean m_useAntialiasing = false;
    private int m_xChartEnd;
    private int m_xChartStart;
    private int m_yChartEnd;
    private int m_yChartStart;

    public Chart2D() {
        this.m_axesXBottom = new LinkedList();
        this.m_axesXTop = new LinkedList();
        this.m_axesYLeft = new LinkedList();
        this.m_axesYRight = new LinkedList();
        this.setTracePointProvider(new TracePointProviderDefault());
        AxisLinear axisLinear = new AxisLinear();
        this.setAxisXBottom(axisLinear, 0);
        axisLinear.getAxisTitle().setTitle("X");
        AxisLinear axisLinear2 = new AxisLinear();
        this.setAxisYLeft(axisLinear2, 0);
        axisLinear2.getAxisTitle().setTitle("Y");
        this.setAxisTickPainter(new AxisTickPainterDefault());
        Font font = this.getFont();
        if (font != null) {
            this.setFont(new Font(font.getFontName(), font.getStyle(), 10));
        }
        this.getBackground();
        this.setBackground(Color.white);
        this.setToolTipType(ToolTipType.NONE);
        this.setRequestedRepaint(true);
        this.setCursor(Cursor.getPredefinedCursor(1));
        this.m_repainter = new Timer(this.m_minPaintLatency, new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                Chart2D chart2D = Chart2D.this;
                synchronized (chart2D) {
                    if (Chart2D.this.isRequestedRepaint()) {
                        Chart2D.this.repaint(Chart2D.this.m_minPaintLatency);
                        Chart2D.this.setRequestedRepaint(false);
                    }
                }
            }
        });
        Timer.setLogTimers(false);
        this.m_repainter.setRepeats(true);
        this.m_repainter.setCoalesce(true);
        this.m_repainter.start();
    }

    public void addAxisXBottom(AAxis<?> aAxis) {
        this.ensureUniqueAxis(aAxis);
        this.m_axesXBottom.add(aAxis);
        aAxis.setChart(this, 1, 32);
        this.listenToAxis(aAxis);
        this.firePropertyChange(PROPERTY_AXIS_X, null, aAxis);
        this.setRequestedRepaint(true);
    }

    public void addAxisXTop(AAxis<?> aAxis) {
        this.ensureUniqueAxis(aAxis);
        this.m_axesXTop.add(aAxis);
        aAxis.setChart(this, 1, 16);
        this.listenToAxis(aAxis);
        this.firePropertyChange(PROPERTY_AXIS_X, null, aAxis);
        this.setRequestedRepaint(true);
    }

    public void addAxisYLeft(AAxis<?> aAxis) {
        this.ensureUniqueAxis(aAxis);
        this.m_axesYLeft.add(aAxis);
        aAxis.setChart(this, 2, 4);
        this.listenToAxis(aAxis);
        this.firePropertyChange(PROPERTY_AXIS_Y, null, aAxis);
        this.setRequestedRepaint(true);
    }

    public void addAxisYRight(AAxis<?> aAxis) {
        this.ensureUniqueAxis(aAxis);
        this.m_axesYRight.add(aAxis);
        aAxis.setChart(this, 2, 8);
        this.listenToAxis(aAxis);
        this.firePropertyChange(PROPERTY_AXIS_Y, null, aAxis);
        this.setRequestedRepaint(true);
    }

    public final void addTrace(ITrace2D iTrace2D) {
        IAxis<?> iAxis = this.m_axesXBottom.get(0);
        IAxis<?> iAxis2 = this.m_axesYLeft.get(0);
        this.addTrace(iTrace2D, iAxis, iAxis2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addTrace(ITrace2D iTrace2D, IAxis<?> iAxis, IAxis<?> iAxis2) {
        if (!this.m_axesXBottom.contains(iAxis) && !this.m_axesXTop.contains(iAxis)) {
            throw new IllegalArgumentException("Given x axis (" + iAxis.getAxisTitle().getTitle() + ") has to be added to this chart first (via setAxisX(AAxis) or addAxisXBottom(AAXis) or addAxisXTop(AAXis)).");
        }
        if (!this.m_axesYLeft.contains(iAxis2) && !this.m_axesYRight.contains(iAxis2)) {
            throw new IllegalArgumentException("Given y axis (" + iAxis2.getAxisTitle().getTitle() + ") has to be added to this chart first (via setAxisY(AAxis) or addAxisYLeft(AAXis) or addAxisYRight(AAXis)).");
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            Chart2D chart2D = this;
            synchronized (chart2D) {
                ITrace2D iTrace2D2 = iTrace2D;
                synchronized (iTrace2D2) {
                    boolean bl = false;
                    bl |= iAxis.addTrace(iTrace2D);
                    if (bl |= iAxis2.addTrace(iTrace2D)) {
                        this.listenToTrace(iTrace2D);
                        int n = iTrace2D.getPointHighlighters().size();
                        this.trackHighlightingEnablement(n);
                        this.firePropertyChange(PROPERTY_ADD_REMOVE_TRACE, null, iTrace2D);
                    }
                }
            }
        }
    }

    private int calculateXChartEnd(Graphics graphics) {
        int n = (int)this.getSize().getWidth();
        int n2 = 0;
        if (this.m_axesYRight.size() > 0) {
            ListIterator<IAxis<?>> listIterator = this.m_axesYRight.listIterator(this.m_axesYRight.size());
            while (listIterator.hasPrevious()) {
                IAxis<?> iAxis = listIterator.previous();
                n2 = iAxis.getWidth(graphics);
                iAxis.setPixelXRight(n);
                if (iAxis.isVisible()) {
                    n -= n2;
                }
                iAxis.setPixelXLeft(n);
            }
            if ((double)n == this.getSize().getWidth()) {
                n -= 20;
            }
        } else {
            int n3;
            Iterator<IAxis<?>> iterator = this.m_axesXBottom.iterator();
            int n4 = 0;
            while (iterator.hasNext()) {
                IAxis<?> iAxis = iterator.next();
                n3 = iAxis.getWidth(graphics);
                if (n3 <= n4) continue;
                n4 = n3;
            }
            for (IAxis<?> iAxis : this.m_axesXTop) {
                n3 = iAxis.getWidth(graphics);
                if (n3 <= n4) continue;
                n4 = n3;
            }
            n -= n4;
        }
        return n;
    }

    private int calculateXChartStart(Graphics graphics) {
        int n = 0;
        ListIterator<IAxis<?>> listIterator = this.m_axesYLeft.listIterator(this.m_axesYLeft.size());
        while (listIterator.hasPrevious()) {
            IAxis<?> iAxis = listIterator.previous();
            iAxis.setPixelXLeft(n);
            if (iAxis.isVisible()) {
                n += iAxis.getWidth(graphics);
            }
            iAxis.setPixelXRight(n);
        }
        return n > 0 ? n : 20;
    }

    private int installXAxisLeftOffset(Graphics graphics, int n) {
        int n2 = n;
        ListIterator<IAxis<?>> listIterator = this.m_axesYLeft.listIterator(this.m_axesYLeft.size());
        while (listIterator.hasPrevious()) {
            IAxis<?> iAxis = listIterator.previous();
            iAxis.setPixelXLeft(n2);
            if (iAxis.isVisible()) {
                n2 += iAxis.getWidth(graphics);
            }
            iAxis.setPixelXRight(n2);
        }
        return n2 > 0 ? n2 : 20;
    }

    private int calculateYChartEnd(Graphics graphics) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (IAxis<?> iAxis : this.m_axesYLeft) {
            n = iAxis.getHeight(graphics);
            if (!iAxis.isVisible() || n <= n3) continue;
            n3 = n;
        }
        for (IAxis<?> iAxis : this.m_axesYRight) {
            n = iAxis.getHeight(graphics);
            if (!iAxis.isVisible() || n <= n3) continue;
            n3 = n;
        }
        ListIterator<IAxis<?>> listIterator = this.m_axesXTop.listIterator(this.m_axesXTop.size());
        int n5 = 0;
        while (listIterator.hasPrevious()) {
            IAxis<?> iAxis;
            iAxis = listIterator.previous();
            iAxis.setPixelYTop(n4);
            n5 = iAxis.getHeight(graphics);
            if (iAxis.isVisible()) {
                n4 += n5;
            }
            iAxis.setPixelYBottom(n4);
        }
        n2 = Math.max(n3, n4);
        return n2 > 0 ? n2 : 20;
    }

    private int calculateYChartStart(Graphics graphics, int n) {
        int n2 = (int)this.getSize().getHeight();
        n2 -= n;
        int n3 = 0;
        for (IAxis<?> iAxis : this.m_axesXBottom) {
            iAxis.setPixelYBottom(n2);
            if (iAxis.isVisible()) {
                n2 -= iAxis.getHeight(graphics);
            }
            iAxis.setPixelYTop(n2);
        }
        if ((double)(n2 -= n3) == this.getSize().getHeight()) {
            n2 -= 20;
        }
        return n2;
    }

    @Override
    public JToolTip createToolTip() {
        JToolTip jToolTip = super.createToolTip();
        return jToolTip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Chart2D chart2D = this;
        synchronized (chart2D) {
            this.m_axesXBottom.clear();
            this.m_axesXBottom = null;
            this.m_axesXTop.clear();
            this.m_axesXTop = null;
            this.m_axesYLeft.clear();
            this.m_axesYLeft = null;
            this.m_axesYRight.clear();
            this.m_axesYRight = null;
            this.m_repainter.stop();
        }
    }

    public boolean enablePointHighlighting(boolean bl) {
        boolean bl2 = this.m_pointHighlightListener.setActive(bl);
        return bl2;
    }

    private void ensureUniqueAxis(IAxis<?> iAxis) {
        if (this.m_axesXBottom.contains(iAxis)) {
            throw new IllegalArgumentException("Given axis (" + iAxis.getAxisTitle().getTitle() + " is already configured as bottom x axis!");
        }
        if (this.m_axesXTop.contains(iAxis)) {
            throw new IllegalArgumentException("Given axis (" + iAxis.getAxisTitle().getTitle() + " is already configured as top x axis!");
        }
        if (this.m_axesYLeft.contains(iAxis)) {
            throw new IllegalArgumentException("Given axis (" + iAxis.getAxisTitle().getTitle() + " is already configured as left y axis!");
        }
        if (this.m_axesYRight.contains(iAxis)) {
            throw new IllegalArgumentException("Given axis (" + iAxis.getAxisTitle().getTitle() + " is already configured as right y axis!");
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.destroy();
    }

    public IAxis<?>[] findAxesOfTrace(ITrace2D iTrace2D) {
        IAxis[] iAxisArray = new IAxis[2];
        Object object = null;
        for (IAxis<?> iAxis : this.m_axesXBottom) {
            if (!iAxis.getTraces().contains(iTrace2D)) continue;
            object = iAxis;
            break;
        }
        if (object == null) {
            for (IAxis<?> iAxis : this.m_axesXTop) {
                if (!iAxis.getTraces().contains(iTrace2D)) continue;
                object = iAxis;
                break;
            }
        }
        Object object2 = null;
        for (IAxis iAxis : this.m_axesYLeft) {
            if (!iAxis.getTraces().contains(iTrace2D)) continue;
            object2 = iAxis;
            break;
        }
        if (object2 == null) {
            for (IAxis iAxis : this.m_axesYRight) {
                if (!iAxis.getTraces().contains(iTrace2D)) continue;
                object2 = iAxis;
                break;
            }
        }
        iAxisArray[0] = object;
        iAxisArray[1] = object2;
        return iAxisArray;
    }

    public final List<IAxis<?>> getAxes() {
        LinkedList linkedList = new LinkedList();
        linkedList.addAll(this.getAxesXBottom());
        linkedList.addAll(this.getAxesXTop());
        linkedList.addAll(this.getAxesYLeft());
        linkedList.addAll(this.getAxesYRight());
        return linkedList;
    }

    public final List<IAxis<?>> getAxesXBottom() {
        return this.m_axesXBottom;
    }

    public final List<IAxis<?>> getAxesXTop() {
        return this.m_axesXTop;
    }

    public final List<IAxis<?>> getAxesYLeft() {
        return this.m_axesYLeft;
    }

    public final List<IAxis<?>> getAxesYRight() {
        return this.m_axesYRight;
    }

    public IAxisTickPainter getAxisTickPainter() {
        return this.m_axisTickPainter;
    }

    public final IAxis<?> getAxisX() {
        return this.m_axesXBottom.get(0);
    }

    public IAxis<?> getAxisX(ITrace2D iTrace2D) {
        IAxis<?> iAxis = null;
        IAxis<?> iAxis22 = null;
        for (IAxis<?> iAxis22 : this.m_axesXBottom) {
            if (!iAxis22.hasTrace(iTrace2D)) continue;
            iAxis = iAxis22;
            break;
        }
        if (iAxis == null) {
            for (IAxis<?> iAxis22 : this.m_axesXTop) {
                if (!iAxis22.hasTrace(iTrace2D)) continue;
                iAxis = iAxis22;
                break;
            }
        }
        return iAxis;
    }

    public final IAxis<?> getAxisY() {
        return this.m_axesYLeft.get(0);
    }

    public IAxis<?> getAxisY(ITrace2D iTrace2D) {
        IAxis<?> iAxis = null;
        IAxis<?> iAxis22 = null;
        for (IAxis<?> iAxis22 : this.m_axesYLeft) {
            if (!iAxis22.hasTrace(iTrace2D)) continue;
            iAxis = iAxis22;
            break;
        }
        if (iAxis == null) {
            for (IAxis<?> iAxis22 : this.m_axesYRight) {
                if (!iAxis22.hasTrace(iTrace2D)) continue;
                iAxis = iAxis22;
                break;
            }
        }
        return iAxis;
    }

    public final Color getGridColor() {
        return this.m_gridcolor;
    }

    @Override
    public int getHeight() {
        Chart2DActionPrintSingleton chart2DActionPrintSingleton;
        int n = -1;
        if (this.m_pageFormat != null && (chart2DActionPrintSingleton = Chart2DActionPrintSingleton.getInstance(this)) != null && chart2DActionPrintSingleton.isPrintWholePage()) {
            int n2 = Toolkit.getDefaultToolkit().getScreenResolution();
            n = (int)this.m_pageFormat.getImageableHeight() * 72 / n2;
        }
        if (n == -1) {
            n = super.getHeight();
        }
        return n;
    }

    public synchronized int getMinPaintLatency() {
        return this.m_minPaintLatency;
    }

    public ITracePoint2D getNearestPointEuclid(int n, int n2) {
        double d;
        ITracePoint2D iTracePoint2D = null;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = this.getXChartEnd() - this.getXChartStart();
        if (d4 != 0.0) {
            d2 = ((double)n - (double)this.getXChartStart()) / d4;
        }
        if ((d = (double)(this.getYChartStart() - this.getYChartEnd())) != 0.0) {
            d3 = 1.0 - ((double)n2 - (double)this.getYChartEnd()) / d;
        }
        SortedSet<ITrace2D> sortedSet = this.getTraces();
        ITrace2D.DistancePoint distancePoint = null;
        for (ITrace2D iTrace2D : sortedSet) {
            ITrace2D.DistancePoint distancePoint2 = iTrace2D.getNearestPointEuclid(d2, d3);
            if (distancePoint == null) {
                distancePoint = distancePoint2;
                continue;
            }
            if (!(distancePoint2.getDistance() < distancePoint.getDistance())) continue;
            distancePoint = distancePoint2;
        }
        if (distancePoint != null) {
            iTracePoint2D = distancePoint.getPoint();
        }
        return iTracePoint2D;
    }

    public ITracePoint2D getNearestPointEuclid(MouseEvent mouseEvent) {
        return this.getNearestPointEuclid(mouseEvent.getX(), mouseEvent.getY());
    }

    public ITracePoint2D getNearestPointManhattan(int n, int n2) {
        double d;
        ITracePoint2D iTracePoint2D = null;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = this.getXChartEnd() - this.getXChartStart();
        if (d4 != 0.0) {
            d2 = ((double)n - (double)this.getXChartStart()) / d4;
        }
        if ((d = (double)(this.getYChartStart() - this.getYChartEnd())) != 0.0) {
            d3 = 1.0 - ((double)n2 - (double)this.getYChartEnd()) / d;
        }
        SortedSet<ITrace2D> sortedSet = this.getTraces();
        ITrace2D.DistancePoint distancePoint = null;
        for (ITrace2D iTrace2D : sortedSet) {
            ITrace2D.DistancePoint distancePoint2 = iTrace2D.getNearestPointManhattan(d2, d3);
            if (distancePoint == null) {
                distancePoint = distancePoint2;
                continue;
            }
            if (!(distancePoint2.getDistance() < distancePoint.getDistance())) continue;
            distancePoint = distancePoint2;
        }
        if (distancePoint != null) {
            iTracePoint2D = distancePoint.getPoint();
        }
        return iTracePoint2D;
    }

    public ITracePoint2D getNearestPointManhattan(MouseEvent mouseEvent) {
        return this.getNearestPointManhattan(mouseEvent.getX(), mouseEvent.getY());
    }

    public IPointFinder getPointFinder() {
        return this.m_pointFinder;
    }

    @Override
    public Dimension getPreferredSize() {
        return super.getPreferredSize();
    }

    @Override
    public Dimension getSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public final synchronized Chart2D getSynchronizedXStartChart() {
        return this.m_synchronizedXStartChart;
    }

    @Override
    public final String getToolTipText(MouseEvent mouseEvent) {
        String string = this.m_toolTip.getToolTipText(this, mouseEvent);
        if (string == null) {
            string = super.getToolTipText(mouseEvent);
        }
        return string;
    }

    public IToolTipType getToolTipType() {
        return this.m_toolTip;
    }

    public ITracePointProvider getTracePointProvider() {
        return this.m_tracePointProvider;
    }

    public final SortedSet<ITrace2D> getTraces() {
        Set<ITrace2D> set;
        TreeSet<ITrace2D> treeSet = new TreeSet<ITrace2D>();
        for (IAxis<?> iAxis : this.m_axesXBottom) {
            set = iAxis.getTraces();
            for (ITrace2D iTrace2D : set) {
                treeSet.add(iTrace2D);
            }
        }
        for (IAxis<?> iAxis : this.m_axesXTop) {
            set = iAxis.getTraces();
            for (ITrace2D iTrace2D : set) {
                treeSet.add(iTrace2D);
            }
        }
        return treeSet;
    }

    @Override
    public int getWidth() {
        Chart2DActionPrintSingleton chart2DActionPrintSingleton;
        int n = -1;
        if (this.m_pageFormat != null && (chart2DActionPrintSingleton = Chart2DActionPrintSingleton.getInstance(this)) != null && chart2DActionPrintSingleton.isPrintWholePage()) {
            int n2 = Toolkit.getDefaultToolkit().getScreenResolution();
            n = (int)this.m_pageFormat.getImageableWidth() * 72 / n2;
        }
        if (n == -1) {
            n = super.getWidth();
        }
        return n;
    }

    public final synchronized int getXAxisWidth() {
        return this.m_xChartEnd - this.m_xChartStart;
    }

    public final synchronized int getXChartEnd() {
        return this.m_xChartEnd;
    }

    public final synchronized int getXChartStart() {
        return this.m_xChartStart;
    }

    public final synchronized int getYChartEnd() {
        return this.m_yChartEnd;
    }

    public synchronized int getYChartStart() {
        return this.m_yChartStart;
    }

    private boolean hasChartIntersection(ITracePoint2D iTracePoint2D, ITracePoint2D iTracePoint2D2) {
        boolean bl = true;
        bl = iTracePoint2D.getScaledX() != iTracePoint2D2.getScaledX() || iTracePoint2D.getScaledY() != iTracePoint2D2.getScaledY();
        return bl;
    }

    private void internalTransferAxisState(IAxis<?> iAxis, AAxis<?> aAxis) {
        Serializable serializable2;
        Set<ITrace2D> set = iAxis.removeAllTraces();
        for (Serializable serializable2 : set) {
            aAxis.addTrace((ITrace2D)serializable2);
        }
        IAxis.AxisTitle axisTitle = iAxis.removeAxisTitle();
        aAxis.setAxisTitle(axisTitle);
        serializable2 = iAxis.getFormatter();
        aAxis.setFormatter((IAxisLabelFormatter)serializable2);
        boolean bl = iAxis.isPaintGrid();
        aAxis.setPaintGrid(bl);
        boolean bl2 = iAxis.isPaintScale();
        aAxis.setPaintScale(bl2);
        boolean bl3 = iAxis.isStartMajorTick();
        aAxis.setStartMajorTick(bl3);
        boolean bl4 = iAxis.isVisible();
        aAxis.setVisible(bl4);
        IRangePolicy iRangePolicy = iAxis.getRangePolicy();
        aAxis.setRangePolicy(iRangePolicy);
        Range range = iAxis.getRange();
        aAxis.setRange(range);
    }

    private ITracePoint2D interpolateVisible(ITracePoint2D iTracePoint2D, ITracePoint2D iTracePoint2D2) {
        ITracePoint2D iTracePoint2D3;
        if (iTracePoint2D == null) {
            iTracePoint2D3 = iTracePoint2D2;
        } else {
            double d = Double.NaN;
            double d2 = Double.NaN;
            boolean bl = false;
            boolean bl2 = false;
            if (iTracePoint2D.getScaledX() > 1.0) {
                d = 1.0;
                d2 = (iTracePoint2D2.getScaledY() - iTracePoint2D.getScaledY()) / (iTracePoint2D2.getScaledX() - iTracePoint2D.getScaledX()) * (1.0 - iTracePoint2D.getScaledX()) + iTracePoint2D.getScaledY();
                bl = true;
                boolean bl3 = bl2 = Double.isNaN(d2) || d2 < 0.0 || d2 > 1.0;
            }
            if (iTracePoint2D.getScaledX() < 0.0 && (!bl || bl2)) {
                d = 0.0;
                d2 = (iTracePoint2D2.getScaledY() - iTracePoint2D.getScaledY()) / (iTracePoint2D2.getScaledX() - iTracePoint2D.getScaledX()) * -iTracePoint2D.getScaledX() + iTracePoint2D.getScaledY();
                bl = true;
                boolean bl4 = bl2 = Double.isNaN(d2) || d2 < 0.0 || d2 > 1.0;
            }
            if (iTracePoint2D.getScaledY() > 1.0 && (!bl || bl2)) {
                d2 = 1.0;
                d = (1.0 - iTracePoint2D.getScaledY()) * (iTracePoint2D2.getScaledX() - iTracePoint2D.getScaledX()) / (iTracePoint2D2.getScaledY() - iTracePoint2D.getScaledY()) + iTracePoint2D.getScaledX();
                bl = true;
                boolean bl5 = bl2 = Double.isNaN(d) || d < 0.0 || d > 1.0;
            }
            if (iTracePoint2D.getScaledY() < 0.0 && (!bl || bl2)) {
                d2 = 0.0;
                d = -iTracePoint2D.getScaledY() * (iTracePoint2D2.getScaledX() - iTracePoint2D.getScaledX()) / (iTracePoint2D2.getScaledY() - iTracePoint2D.getScaledY()) + iTracePoint2D.getScaledX();
                bl = true;
                boolean bl6 = bl2 = Double.isNaN(d) || d < 0.0 || d > 1.0;
            }
            if (bl2) {
                iTracePoint2D3 = iTracePoint2D2;
            } else {
                iTracePoint2D3 = this.m_tracePointProvider.createTracePoint(0.0, 0.0);
                for (IPointPainter<?> iPointPainter : iTracePoint2D.getAdditionalPointPainters()) {
                    iTracePoint2D3.addAdditionalPointPainter(iPointPainter);
                }
                iTracePoint2D3.setScaledX(d);
                iTracePoint2D3.setScaledY(d2);
                iTracePoint2D3.setListener(iTracePoint2D.getListener());
            }
        }
        return iTracePoint2D3;
    }

    public boolean isEnabledPointHighlighting() {
        boolean bl = false;
        for (MouseMotionListener mouseMotionListener : this.getMouseMotionListeners()) {
            if (mouseMotionListener != this.m_pointHighlightListener) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public final boolean isPaintLabels() {
        return this.m_paintLabels;
    }

    protected synchronized boolean isRequestedRepaint() {
        return this.m_requestedRepaint;
    }

    public final boolean isToolTipCoords() {
        return this.m_toolTip == ToolTipType.DATAVALUES;
    }

    public final boolean isUseAntialiasing() {
        return this.m_useAntialiasing;
    }

    public boolean isVisible(ITracePoint2D iTracePoint2D) {
        boolean bl = iTracePoint2D == null ? false : !(Double.isNaN(iTracePoint2D.getScaledX()) || Double.isNaN(iTracePoint2D.getScaledY()) || iTracePoint2D.getScaledX() > 1.0 || iTracePoint2D.getScaledX() < 0.0 || iTracePoint2D.getScaledY() > 1.0 || iTracePoint2D.getScaledY() < 0.0);
        return bl;
    }

    @Override
    public final Iterator<ITrace2D> iterator() {
        return this.getTraces().iterator();
    }

    private void listenToAxis(IAxis<?> iAxis) {
        iAxis.addPropertyChangeListener(PROPERTY_ADD_REMOVE_TRACE, this);
        iAxis.addPropertyChangeListener("IAxis.PROPERTY_LABELFORMATTER", this);
        iAxis.addPropertyChangeListener("IAxis.PROPERTY_PAINTGRID", this);
        iAxis.addPropertyChangeListener("IAxis.PROPERTY_RANGEPOLICY", this);
        iAxis.addPropertyChangeListener("IAxis.PROPERTY_AXIS_SCALE_POLICY_CHANGED", this);
    }

    private void listenToTrace(ITrace2D iTrace2D) {
        iTrace2D.addPropertyChangeListener("ITrace2D.PROPERTY_POINT_HIGHLIGHTERS_CHANGED", this.m_pointHighlightListener);
        iTrace2D.addPropertyChangeListener("ITrace2D.PROPERTY_POINT_HIGHLIGHTERS_CHANGED", this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void negociateXChart(Graphics graphics) {
        if (this.m_synchronizedXStartChart != null) {
            int n = this.calculateXChartStart(graphics);
            int n2 = this.m_synchronizedXStartChart.calculateXChartStart(graphics);
            int n3 = Math.abs(n - n2);
            this.m_xChartStart = Math.max(this.calculateXChartStart(graphics), this.m_synchronizedXStartChart.calculateXChartStart(graphics));
            this.m_xChartEnd = Math.max(this.calculateXChartEnd(graphics), this.m_synchronizedXStartChart.calculateXChartEnd(graphics));
            Chart2D chart2D = this.m_synchronizedXStartChart;
            synchronized (chart2D) {
                this.m_synchronizedXStartChart.m_xChartStart = this.m_xChartStart;
                this.m_synchronizedXStartChart.m_xChartEnd = this.m_xChartEnd;
                if (n > n2) {
                    this.m_synchronizedXStartChart.installXAxisLeftOffset(graphics, n3);
                } else {
                    this.installXAxisLeftOffset(graphics, n3);
                }
            }
        } else if (!this.m_synchronizedXStart) {
            this.m_xChartStart = this.calculateXChartStart(graphics);
            this.m_xChartEnd = this.calculateXChartEnd(graphics);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics graphics) {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.paint(graphics);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void paintComponent(Graphics graphics) {
        Object object;
        super.paintComponent(graphics);
        if (this.m_pageFormat != null) {
            object = (Graphics2D)graphics;
            double d = this.m_pageFormat.getImageableX();
            double d2 = this.m_pageFormat.getImageableY();
            ((Graphics2D)object).translate(d, d2);
        }
        this.updateScaling(false);
        this.negociateXChart(graphics);
        int n = this.paintTraceLabels(graphics);
        this.m_yChartStart = this.calculateYChartStart(graphics, n);
        this.m_yChartEnd = this.calculateYChartEnd(graphics);
        int n2 = this.m_xChartEnd - this.m_xChartStart;
        int n3 = this.m_yChartStart - this.m_yChartEnd;
        this.paintCoordinateSystem(graphics);
        int n4 = 0;
        int n5 = 0;
        ITracePoint2D iTracePoint2D = null;
        ITracePoint2D iTracePoint2D2 = null;
        ITracePoint2D iTracePoint2D3 = null;
        Iterator iterator = this.getTraces().iterator();
        Graphics2D graphics2D = null;
        Stroke stroke = null;
        if (graphics instanceof Graphics2D) {
            graphics2D = (Graphics2D)graphics;
            stroke = graphics2D.getStroke();
            if (this.isUseAntialiasing()) {
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
        }
        int n6 = 0;
        while (iterator.hasNext()) {
            iTracePoint2D = null;
            iTracePoint2D2 = null;
            ++n6;
            object = (ITrace2D)iterator.next();
            if (!object.isVisible()) continue;
            Object object2 = object;
            synchronized (object2) {
                Object object3;
                boolean bl = object.getHasErrorBars();
                if (graphics2D != null) {
                    graphics2D.setStroke(object.getStroke());
                }
                graphics.setColor(object.getColor());
                Set<ITracePainter<?>> set = object.getTracePainters();
                Iterator<ITracePainter<?>> iterator2 = set.iterator();
                ITracePainter<?> iTracePainter32 = null;
                while (iterator2.hasNext()) {
                    iTracePainter32 = iterator2.next();
                    iTracePainter32.startPaintIteration(graphics);
                }
                if (bl) {
                    Object var20_23 = null;
                    object3 = object.getErrorBarPolicies();
                    Iterator<Object> iterator3 = object3.iterator();
                    while (iterator3.hasNext()) {
                        IErrorBarPolicy iErrorBarPolicy = (IErrorBarPolicy)iterator3.next();
                        iErrorBarPolicy.startPaintIteration(graphics);
                    }
                }
                object3 = object.iterator();
                boolean bl2 = false;
                boolean bl3 = false;
                while (object3.hasNext()) {
                    boolean bl4;
                    boolean bl5;
                    iTracePoint2D = iTracePoint2D2;
                    int n7 = n4;
                    int n8 = n5;
                    iTracePoint2D2 = (ITracePoint2D)object3.next();
                    bl2 = this.isVisible(iTracePoint2D2);
                    bl3 = this.isVisible(iTracePoint2D);
                    boolean bl6 = bl5 = Double.isNaN(iTracePoint2D2.getX()) || Double.isNaN(iTracePoint2D2.getY());
                    if (iTracePoint2D == null) {
                        bl4 = false;
                    } else {
                        boolean bl7 = bl4 = Double.isNaN(iTracePoint2D.getX()) || Double.isNaN(iTracePoint2D.getY());
                    }
                    if (bl5 || bl4) {
                        if (!bl4 && bl5) {
                            for (ITracePainter<?> iTracePainter : object.getTracePainters()) {
                                iTracePainter.discontinue(graphics2D);
                            }
                        }
                        if (bl5) continue;
                        n4 = this.m_xChartStart + (int)Math.round(iTracePoint2D2.getScaledX() * (double)n2);
                        n5 = this.m_yChartStart - (int)Math.round(iTracePoint2D2.getScaledY() * (double)n3);
                        continue;
                    }
                    if (!bl2 && !bl3) {
                        iTracePoint2D3 = (ITracePoint2D)iTracePoint2D2.clone();
                        int n9 = n4;
                        int n10 = n5;
                        iTracePoint2D = this.interpolateVisible(iTracePoint2D, iTracePoint2D2);
                        iTracePoint2D2 = this.interpolateVisible(iTracePoint2D2, iTracePoint2D);
                        n4 = this.m_xChartStart + (int)Math.round(iTracePoint2D2.getScaledX() * (double)n2);
                        n5 = this.m_yChartStart - (int)Math.round(iTracePoint2D2.getScaledY() * (double)n3);
                        n7 = this.m_xChartStart + (int)Math.round(iTracePoint2D.getScaledX() * (double)n2);
                        n8 = this.m_yChartStart - (int)Math.round(iTracePoint2D.getScaledY() * (double)n3);
                        if (this.hasChartIntersection(iTracePoint2D, iTracePoint2D2)) {
                            this.paintPoint(n7, n8, n4, n5, true, (ITrace2D)object, graphics, iTracePoint2D2, false);
                        }
                        iTracePoint2D2 = iTracePoint2D3;
                        n4 = n9;
                        n5 = n10;
                        continue;
                    }
                    if (bl2 && !bl3) {
                        iTracePoint2D = this.interpolateVisible(iTracePoint2D, iTracePoint2D2);
                        n4 = this.m_xChartStart + (int)Math.round(iTracePoint2D2.getScaledX() * (double)n2);
                        n5 = this.m_yChartStart - (int)Math.round(iTracePoint2D2.getScaledY() * (double)n3);
                        n7 = this.m_xChartStart + (int)Math.round(iTracePoint2D.getScaledX() * (double)n2);
                        n8 = this.m_yChartStart - (int)Math.round(iTracePoint2D.getScaledY() * (double)n3);
                        this.paintPoint(n7, n8, n4, n5, true, (ITrace2D)object, graphics, iTracePoint2D2, false);
                        continue;
                    }
                    if (!bl2 && bl3) {
                        iTracePoint2D3 = (ITracePoint2D)iTracePoint2D2.clone();
                        iTracePoint2D2 = this.interpolateVisible(iTracePoint2D2, iTracePoint2D);
                        n4 = this.m_xChartStart + (int)Math.round(iTracePoint2D2.getScaledX() * (double)n2);
                        n5 = this.m_yChartStart - (int)Math.round(iTracePoint2D2.getScaledY() * (double)n3);
                        this.paintPoint(n7, n8, n4, n5, true, (ITrace2D)object, graphics, iTracePoint2D2, false);
                        iTracePoint2D2 = iTracePoint2D3;
                        continue;
                    }
                    n4 = this.m_xChartStart + (int)Math.round(iTracePoint2D2.getScaledX() * (double)n2);
                    n5 = this.m_yChartStart - (int)Math.round(iTracePoint2D2.getScaledY() * (double)n3);
                    this.paintPoint(n7, n8, n4, n5, false, (ITrace2D)object, graphics, iTracePoint2D2, bl);
                }
                for (ITracePainter<?> iTracePainter32 : object.getTracePainters()) {
                    iTracePainter32.endPaintIteration(graphics);
                }
                if (bl) {
                    for (IErrorBarPolicy iErrorBarPolicy : object.getErrorBarPolicies()) {
                        iErrorBarPolicy.endPaintIteration(graphics);
                    }
                }
            }
        }
        if (graphics2D != null) {
            graphics2D.setStroke(stroke);
        }
    }

    private void paintCoordinateSystem(Graphics graphics) {
        graphics.setColor(this.getForeground());
        for (IAxis<?> iAxis : this.m_axesXBottom) {
            iAxis.paint(graphics);
        }
        for (IAxis<?> iAxis : this.m_axesXTop) {
            iAxis.paint(graphics);
        }
        for (IAxis<?> iAxis : this.m_axesYLeft) {
            iAxis.paint(graphics);
        }
        for (IAxis<?> iAxis : this.m_axesYRight) {
            iAxis.paint(graphics);
        }
    }

    private void paintErrorBars(ITrace2D iTrace2D, int n, int n2, int n3, int n4, Graphics graphics, boolean bl, ITracePoint2D iTracePoint2D) {
        for (IErrorBarPolicy<?> iErrorBarPolicy : iTrace2D.getErrorBarPolicies()) {
            iErrorBarPolicy.paintPoint(n, n2, n3, n4, graphics, iTracePoint2D);
            if (!bl) continue;
            iErrorBarPolicy.discontinue(graphics);
        }
    }

    private final void paintPoint(int n, int n2, int n3, int n4, boolean bl, ITrace2D iTrace2D, Graphics graphics, ITracePoint2D iTracePoint2D, boolean bl2) {
        for (ITracePainter<?> iTracePainter : iTrace2D.getTracePainters()) {
            iTracePainter.paintPoint(n, n2, n3, n4, graphics, iTracePoint2D);
            Set<IPointPainter<?>> set = iTracePoint2D.getAdditionalPointPainters();
            for (IPointPainter<?> iPointPainter : set) {
                iPointPainter.paintPoint(n3, n4, n3, n4, graphics, iTracePoint2D);
            }
            if (!bl) continue;
            iTracePainter.discontinue(graphics);
        }
        if (bl2) {
            this.paintErrorBars(iTrace2D, n, n2, n3, n4, graphics, bl, iTracePoint2D);
        }
    }

    private int paintTraceLabels(Graphics graphics) {
        int n = 0;
        Dimension dimension = this.getSize();
        if (this.m_paintLabels) {
            int n2;
            Iterator iterator = this.getTraces().iterator();
            int n3 = this.m_xChartStart;
            int n4 = (int)dimension.getHeight() - 2;
            int n5 = n2 = (int)dimension.getWidth() - this.m_xChartStart;
            int n6 = 0;
            boolean bl = false;
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n7 = fontMetrics.getHeight();
            if (iterator.hasNext()) {
                n += n7;
            }
            while (iterator.hasNext()) {
                String string;
                ITrace2D iTrace2D = (ITrace2D)iterator.next();
                if (!iTrace2D.isVisible() || StringUtil.isEmpty(string = iTrace2D.getLabel())) continue;
                n6 = fontMetrics.stringWidth(string) + 10;
                if (n6 > n2) {
                    if (n6 <= n5 || !bl) {
                        n4 -= n7;
                        n3 = this.m_xChartStart;
                        n += n7;
                        bl = true;
                        n2 = (int)dimension.getWidth() - this.m_xChartStart;
                    } else {
                        bl = false;
                    }
                }
                n2 -= n6;
                graphics.setColor(iTrace2D.getColor());
                graphics.drawString(string, n3, n4);
                n3 += n6;
            }
        }
        return n;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        int n2;
        if (n > 0) {
            n2 = 1;
        } else {
            this.m_pageFormat = pageFormat;
            this.updateScaling(true);
            this.printAll(graphics);
            n2 = 0;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Chart2D chart2D = this;
        synchronized (chart2D) {
            String string = propertyChangeEvent.getPropertyName();
            if (!(string.equals("IRangePolicy.PROPERTY_RANGE") || string.equals("IRangePolicy.PROPERTY_RANGE") || string.equals("IRangePolicy.PROPERTY_RANGE") || string.equals("ITrace2D.PROPERTY_STROKE") || string.equals("ITrace2D.PROPERTY_COLOR") || string.equals("IAxis.PROPERTY_LABELFORMATTER"))) {
                if (string.equals(PROPERTY_ADD_REMOVE_TRACE)) {
                    this.firePropertyChange(PROPERTY_ADD_REMOVE_TRACE, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
                } else if (string.equals("ITrace2D.PROPERTY_POINT_HIGHLIGHTERS_CHANGED")) {
                    int n = 0;
                    if (propertyChangeEvent.getOldValue() != null) {
                        --n;
                    }
                    if (propertyChangeEvent.getNewValue() != null) {
                        ++n;
                    }
                    this.trackHighlightingEnablement(n);
                } else if (!(string.equals("IAxis.PROPERTY_AXIS_SCALE_POLICY_CHANGED") || string.equals("IAxis.PROPERTY_PAINTGRID") || string.equals("IAxis.PROPERTY_RANGEPOLICY"))) {
                    throw new IllegalStateException("Received a property change event \"" + string + "\" the code is not expecting (programming error).");
                }
            }
            this.setRequestedRepaint(true);
        }
    }

    public Set<ITrace2D> removeAllTraces() {
        Set<ITrace2D> set;
        TreeSet<ITrace2D> treeSet = new TreeSet<ITrace2D>();
        for (IAxis<?> iAxis : this.m_axesXBottom) {
            set = iAxis.removeAllTraces();
            treeSet.addAll(set);
        }
        for (IAxis<?> iAxis : this.m_axesXTop) {
            set = iAxis.removeAllTraces();
            treeSet.addAll(set);
            set.clear();
        }
        for (IAxis<?> iAxis : this.m_axesYLeft) {
            set = iAxis.removeAllTraces();
            set.clear();
        }
        for (IAxis<?> iAxis : this.m_axesYRight) {
            set = iAxis.removeAllTraces();
            set.clear();
        }
        return treeSet;
    }

    public boolean removeAxisXBottom(IAxis<?> iAxis) {
        boolean bl = this.m_axesXBottom.remove(iAxis);
        this.unlistenToAxis(iAxis);
        this.firePropertyChange(PROPERTY_AXIS_X, iAxis, null);
        this.setRequestedRepaint(true);
        return bl;
    }

    public boolean removeAxisXTop(IAxis<?> iAxis) {
        boolean bl = this.m_axesXTop.remove(iAxis);
        this.unlistenToAxis(iAxis);
        this.firePropertyChange(PROPERTY_AXIS_X, iAxis, null);
        this.setRequestedRepaint(true);
        return bl;
    }

    public boolean removeAxisYLeft(IAxis<?> iAxis) {
        boolean bl = this.m_axesYLeft.remove(iAxis);
        this.unlistenToAxis(iAxis);
        this.firePropertyChange(PROPERTY_AXIS_Y, iAxis, null);
        this.setRequestedRepaint(true);
        return bl;
    }

    public boolean removeAxisYRight(IAxis<?> iAxis) {
        boolean bl = this.m_axesYRight.remove(iAxis);
        this.unlistenToAxis(iAxis);
        this.firePropertyChange(PROPERTY_AXIS_Y, iAxis, null);
        this.setRequestedRepaint(true);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean removeTrace(ITrace2D iTrace2D) {
        boolean bl = false;
        Chart2D chart2D = this;
        synchronized (chart2D) {
            ITrace2D iTrace2D2 = iTrace2D;
            synchronized (iTrace2D2) {
                boolean bl2;
                IAxis<?> iAxis2;
                Iterator<IAxis<?>> iterator = this.m_axesXBottom.iterator();
                boolean bl3 = false;
                while (iterator.hasNext() && !(bl3 = (iAxis2 = iterator.next()).removeTrace(iTrace2D))) {
                }
                if (!bl3) {
                    iterator = this.m_axesXTop.iterator();
                    while (iterator.hasNext() && !(bl3 = (iAxis2 = iterator.next()).removeTrace(iTrace2D))) {
                    }
                }
                boolean bl4 = false;
                for (IAxis<?> iAxis2 : this.m_axesYLeft) {
                    bl4 = iAxis2.removeTrace(iTrace2D);
                }
                if (!bl4) {
                    iterator = this.m_axesYRight.iterator();
                    while (iterator.hasNext() && !(bl4 = (iAxis2 = iterator.next()).removeTrace(iTrace2D))) {
                    }
                }
                boolean bl5 = bl2 = bl4 && bl3;
                if (bl2) {
                    int n = iTrace2D.getPointHighlighters().size();
                    this.trackHighlightingEnablement(n);
                    this.unlistenToTrace(iTrace2D);
                    this.setRequestedRepaint(true);
                }
                bl = bl2;
                return bl;
            }
        }
    }

    @Override
    @Deprecated
    public void repaint() {
        super.repaint();
    }

    @Override
    @Deprecated
    public void repaint(int n, int n2, int n3, int n4) {
        super.repaint(n, n2, n3, n4);
    }

    @Override
    @Deprecated
    public void repaint(long l) {
        super.repaint(l);
    }

    @Override
    @Deprecated
    public void repaint(long l, int n, int n2, int n3, int n4) {
        super.repaint(l, n, n2, n3, n4);
    }

    @Override
    @Deprecated
    public void repaint(Rectangle rectangle) {
        super.repaint(rectangle);
    }

    public void resetPrintMode() {
        this.m_pageFormat = null;
        this.setRequestedRepaint(true);
    }

    public synchronized void setAxisTickPainter(IAxisTickPainter iAxisTickPainter) {
        this.m_axisTickPainter = iAxisTickPainter;
    }

    @Deprecated
    public List<IAxis<?>> setAxisX(AAxis<?> aAxis) {
        LinkedList linkedList = new LinkedList();
        for (IAxis<?> iterator2 : this.m_axesXBottom) {
            linkedList.add(iterator2);
        }
        LinkedList linkedList2 = new LinkedList();
        for (IAxis<?> iAxis : this.m_axesXTop) {
            linkedList2.add(iAxis);
        }
        for (IAxis iAxis : linkedList) {
            this.removeAxisXBottom(iAxis);
        }
        Iterator iterator = linkedList2.iterator();
        while (iterator.hasNext()) {
            IAxis iAxis = (IAxis)iterator.next();
            this.removeAxisXTop(iAxis);
        }
        linkedList.addAll(linkedList2);
        return linkedList;
    }

    public IAxis<?> setAxisXBottom(AAxis<?> aAxis, int n) {
        IAxis<?> iAxis = null;
        if (this.m_axesXBottom.size() > n) {
            iAxis = this.m_axesXBottom.get(n);
            this.removeAxisXBottom(iAxis);
            this.firePropertyChange(PROPERTY_AXIS_X_BOTTOM_REPLACE, iAxis, aAxis);
        }
        this.addAxisXBottom(aAxis);
        if (iAxis != null) {
            this.internalTransferAxisState(iAxis, aAxis);
        }
        this.m_mouseTranslationXAxis = aAxis;
        this.setRequestedRepaint(true);
        return iAxis;
    }

    public IAxis<?> setAxisXTop(AAxis<?> aAxis, int n) {
        IAxis<?> iAxis = null;
        if (this.m_axesXTop.size() > n) {
            iAxis = this.m_axesXTop.get(n);
            this.removeAxisXTop(iAxis);
            this.firePropertyChange(PROPERTY_AXIS_X_TOP_REPLACE, iAxis, aAxis);
        }
        if (iAxis != null) {
            this.internalTransferAxisState(iAxis, aAxis);
        }
        this.addAxisXTop(aAxis);
        this.m_mouseTranslationXAxis = aAxis;
        this.setRequestedRepaint(true);
        return iAxis;
    }

    @Deprecated
    public List<IAxis<?>> setAxisY(AAxis<?> aAxis) {
        LinkedList linkedList = new LinkedList();
        for (IAxis<?> iterator2 : this.m_axesYLeft) {
            linkedList.add(iterator2);
        }
        LinkedList linkedList2 = new LinkedList();
        for (IAxis<?> iAxis : this.m_axesYRight) {
            linkedList2.add(iAxis);
        }
        for (IAxis iAxis : linkedList) {
            this.removeAxisYLeft(iAxis);
        }
        Iterator iterator = linkedList2.iterator();
        while (iterator.hasNext()) {
            IAxis iAxis = (IAxis)iterator.next();
            this.removeAxisYRight(iAxis);
        }
        linkedList.addAll(linkedList2);
        return linkedList;
    }

    public IAxis<?> setAxisYLeft(AAxis<?> aAxis, int n) {
        IAxis<?> iAxis = null;
        if (this.m_axesYLeft.size() > n) {
            iAxis = this.m_axesYLeft.get(n);
            this.removeAxisYLeft(iAxis);
            this.firePropertyChange(PROPERTY_AXIS_Y_LEFT_REPLACE, iAxis, aAxis);
        }
        this.addAxisYLeft(aAxis);
        if (iAxis != null) {
            this.internalTransferAxisState(iAxis, aAxis);
        }
        this.m_mouseTranslationYAxis = aAxis;
        this.setRequestedRepaint(true);
        return iAxis;
    }

    public IAxis<?> setAxisYRight(AAxis<?> aAxis, int n) {
        IAxis<?> iAxis = null;
        if (this.m_axesYRight.size() > n) {
            iAxis = this.m_axesYRight.get(n);
            this.removeAxisYLeft(iAxis);
            this.firePropertyChange(PROPERTY_AXIS_Y_RIGHT_REPLACE, iAxis, aAxis);
        }
        this.addAxisYRight(aAxis);
        if (iAxis != null) {
            this.internalTransferAxisState(iAxis, aAxis);
        }
        this.m_mouseTranslationYAxis = aAxis;
        this.setRequestedRepaint(true);
        return iAxis;
    }

    public final void setGridColor(Color color) {
        if (color != null) {
            Color color2 = this.m_gridcolor;
            this.m_gridcolor = color;
            if (!color2.equals(this.m_gridcolor)) {
                this.firePropertyChange(PROPERTY_GRID_COLOR, color2, this.m_gridcolor);
            }
            this.setRequestedRepaint(true);
        }
    }

    public synchronized void setMinPaintLatency(int n) {
        this.m_minPaintLatency = n;
        this.m_repainter.setDelay(this.m_minPaintLatency);
    }

    public void setPaintLabels(boolean bl) {
        boolean bl2 = this.m_paintLabels != bl;
        this.m_paintLabels = bl;
        if (bl2) {
            this.firePropertyChange(PROPERTY_PAINTLABELS, new Boolean(!bl), new Boolean(bl));
            this.setRequestedRepaint(true);
        }
    }

    public void setPointFinder(IPointFinder iPointFinder) {
        IPointFinder iPointFinder2 = this.m_pointFinder;
        if (!this.m_pointFinder.equals(iPointFinder)) {
            this.m_pointFinder = iPointFinder;
            this.firePropertyChange(PROPERTY_POINTFINDER, iPointFinder2, this.m_pointFinder);
        }
    }

    public final synchronized void setRequestedRepaint(boolean bl) {
        this.m_requestedRepaint = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setSynchronizedXStartChart(Chart2D chart2D) {
        this.m_synchronizedXStartChart = chart2D;
        this.m_synchronizedXStart = false;
        Chart2D chart2D2 = chart2D;
        synchronized (chart2D2) {
            chart2D.m_synchronizedXStart = true;
        }
    }

    @Deprecated
    public final void setToolTipCoords(boolean bl) {
        if (bl) {
            this.setToolTipType(ToolTipType.DATAVALUES);
        } else {
            this.setToolTipType(ToolTipType.NONE);
        }
    }

    public final void setToolTipType(IToolTipType iToolTipType) {
        if (iToolTipType == ToolTipType.NONE) {
            this.setToolTipText(null);
        } else {
            this.setToolTipText("turnOn");
        }
        IToolTipType iToolTipType2 = this.m_toolTip;
        this.m_toolTip = iToolTipType;
        this.firePropertyChange(PROPERTY_TOOLTIP_TYPE, iToolTipType2, this.m_toolTip);
    }

    public void setTracePointProvider(ITracePointProvider iTracePointProvider) {
        assert (iTracePointProvider != null);
        this.m_tracePointProvider = iTracePointProvider;
    }

    public final void setUseAntialiasing(boolean bl) {
        if (this.m_useAntialiasing != bl) {
            boolean bl2 = this.m_useAntialiasing;
            this.m_useAntialiasing = bl;
            this.firePropertyChange(PROPERTY_ANTIALIASING_ENABLED, bl2, this.m_useAntialiasing);
        }
    }

    public BufferedImage snapShot() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (n <= 0 && n2 <= 0) {
            n = 600;
            n2 = 400;
        }
        return this.snapShot(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage snapShot(int n, int n2) {
        Chart2D chart2D = this;
        synchronized (chart2D) {
            Dimension dimension = new Dimension(this.getWidth(), this.getHeight());
            this.setSize(new Dimension(n, n2));
            BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.paint(graphics2D);
            this.setSize(dimension);
            return bufferedImage;
        }
    }

    @Override
    public String toString() {
        String string = super.toString();
        return string;
    }

    private void trackHighlightingEnablement(int n) {
        if (this.m_traceHighlighterCount <= 0) {
            if (n > 0) {
                this.enablePointHighlighting(true);
            }
        } else if (n < 0 && Math.abs(n) >= this.m_traceHighlighterCount) {
            this.enablePointHighlighting(false);
        }
        this.m_traceHighlighterCount += n;
        if (this.m_traceHighlighterCount < 0) {
            System.err.println("Internal amount of point highlighters below zero: " + this.m_traceHighlighterCount);
        }
    }

    @Deprecated
    public ITracePoint2D translateMousePosition(MouseEvent mouseEvent) throws IllegalArgumentException {
        if (mouseEvent.getSource() != this) {
            throw new IllegalArgumentException("The given mouse event does not belong to this chart but to: " + mouseEvent.getSource());
        }
        ITracePoint2D iTracePoint2D = null;
        double d = this.m_mouseTranslationXAxis.translateMousePosition(mouseEvent);
        double d2 = this.m_mouseTranslationYAxis.translateMousePosition(mouseEvent);
        iTracePoint2D = this.m_tracePointProvider.createTracePoint(d, d2);
        return iTracePoint2D;
    }

    private void unlistenToAxis(IAxis<?> iAxis) {
        iAxis.removePropertyChangeListener(PROPERTY_ADD_REMOVE_TRACE, this);
        iAxis.removePropertyChangeListener("IAxis.PROPERTY_LABELFORMATTER", this);
        iAxis.removePropertyChangeListener("IAxis.PROPERTY_PAINTGRID", this);
        iAxis.removePropertyChangeListener("IAxis.PROPERTY_RANGEPOLICY", this);
        iAxis.removePropertyChangeListener("IAxis.PROPERTY_AXIS_SCALE_POLICY_CHANGED", this);
    }

    private void unlistenToTrace(ITrace2D iTrace2D) {
        iTrace2D.removePropertyChangeListener("ITrace2D.PROPERTY_POINT_HIGHLIGHTERS_CHANGED", this.m_pointHighlightListener);
        iTrace2D.removePropertyChangeListener("ITrace2D.PROPERTY_POINT_HIGHLIGHTERS_CHANGED", this);
    }

    private synchronized void updateScaling(boolean bl) {
        boolean bl2;
        for (IAxis<?> iAxis : this.m_axesXBottom) {
            bl2 = bl;
            bl2 = bl2 || iAxis.isDirtyScaling();
            if (!bl2) continue;
            iAxis.initPaintIteration();
            iAxis.scale();
        }
        for (IAxis<?> iAxis : this.m_axesXTop) {
            bl2 = bl;
            bl2 = bl2 || iAxis.isDirtyScaling();
            if (!bl2) continue;
            iAxis.initPaintIteration();
            iAxis.scale();
        }
        for (IAxis<?> iAxis : this.m_axesYLeft) {
            bl2 = bl;
            bl2 = bl2 || iAxis.isDirtyScaling();
            if (!bl2) continue;
            iAxis.initPaintIteration();
            iAxis.scale();
        }
        for (IAxis<?> iAxis : this.m_axesYRight) {
            bl2 = bl;
            bl2 = bl2 || iAxis.isDirtyScaling();
            if (!bl2) continue;
            iAxis.initPaintIteration();
            iAxis.scale();
        }
    }

    final class PointHighlighter
    extends MouseMotionAdapter
    implements MouseMotionListener,
    PropertyChangeListener {
        private Map<ITrace2D, ITracePoint2D> m_previousHighlighted = new IdentityHashMap<ITrace2D, ITracePoint2D>();

        public PointHighlighter() {
            Chart2D.this.addPropertyChangeListener("ITrace2D.PROPERTY_POINT_HIGHLIGHTERS_CHANGED", this);
            Chart2D.this.addPropertyChangeListener(Chart2D.PROPERTY_ADD_REMOVE_TRACE, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean setActive(boolean bl) {
            boolean bl2 = false;
            boolean bl3 = Chart2D.this.isEnabledPointHighlighting();
            if (!bl) {
                if (bl3) {
                    Chart2D chart2D = Chart2D.this;
                    synchronized (chart2D) {
                        for (Map.Entry<ITrace2D, ITracePoint2D> entry : this.m_previousHighlighted.entrySet()) {
                            ITrace2D iTrace2D = entry.getKey();
                            synchronized (iTrace2D) {
                                Set<IPointPainter<?>> set = entry.getKey().getPointHighlighters();
                                Set<IPointPainter<?>> set2 = entry.getValue().getAdditionalPointPainters();
                                Iterator<IPointPainter<?>> iterator = set2.iterator();
                                block10: while (iterator.hasNext()) {
                                    IPointPainter<?> iPointPainter = iterator.next();
                                    for (IPointPainter<?> iPointPainter2 : set) {
                                        if (iPointPainter != iPointPainter2) continue;
                                        iterator.remove();
                                        continue block10;
                                    }
                                }
                            }
                        }
                        Chart2D.this.removeMouseMotionListener(this);
                        Chart2D.this.firePropertyChange(Chart2D.PROPERTY_POINT_HIGHLIGHTING_ENABLED, Boolean.TRUE, Boolean.FALSE);
                        this.m_previousHighlighted.clear();
                        Chart2D.this.setRequestedRepaint(true);
                        bl2 = true;
                    }
                }
            } else if (!bl3) {
                Chart2D chart2D = Chart2D.this;
                synchronized (chart2D) {
                    Chart2D.this.addMouseMotionListener(this);
                    Chart2D.this.firePropertyChange(Chart2D.PROPERTY_POINT_HIGHLIGHTING_ENABLED, Boolean.FALSE, Boolean.TRUE);
                    Chart2D.this.setRequestedRepaint(true);
                    bl2 = true;
                }
            }
            return bl2;
        }

        private void attachHighlighters(ITracePoint2D iTracePoint2D) {
            ITrace2D iTrace2D = iTracePoint2D.getListener();
            for (IPointPainter<?> iPointPainter : iTrace2D.getPointHighlighters()) {
                iTracePoint2D.addAdditionalPointPainter(iPointPainter);
            }
        }

        private void clearOutdatedHighlighters(ITrace2D iTrace2D) {
            ITracePoint2D iTracePoint2D = this.m_previousHighlighted.remove(iTrace2D);
            if (iTracePoint2D != null) {
                Iterator<IPointPainter<?>> iterator = iTracePoint2D.getAdditionalPointPainters().iterator();
                Set<IPointPainter<?>> set = iTrace2D.getPointHighlighters();
                block0: while (iterator.hasNext()) {
                    IPointPainter<?> iPointPainter = iterator.next();
                    for (IPointPainter<?> iPointPainter2 : set) {
                        if (iPointPainter2 != iPointPainter) continue;
                        iterator.remove();
                        continue block0;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseMoved(MouseEvent mouseEvent) {
            ITracePoint2D iTracePoint2D;
            ITracePoint2D iTracePoint2D2 = Chart2D.this.getPointFinder().getNearestPoint(mouseEvent, Chart2D.this);
            if (iTracePoint2D2 != null && !iTracePoint2D2.equals(iTracePoint2D = this.m_previousHighlighted.get(iTracePoint2D2.getListener()))) {
                ITrace2D iTrace2D = iTracePoint2D2.getListener();
                PointHighlighter pointHighlighter = this;
                synchronized (pointHighlighter) {
                    ITrace2D iTrace2D2 = iTrace2D;
                    synchronized (iTrace2D2) {
                        this.clearOutdatedHighlighters(iTrace2D);
                        this.attachHighlighters(iTracePoint2D2);
                        this.m_previousHighlighted.put(iTrace2D, iTracePoint2D2);
                        Chart2D.this.setRequestedRepaint(true);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("ITrace2D.PROPERTY_POINT_HIGHLIGHTERS_CHANGED".equals(string)) {
                ITrace2D iTrace2D = (ITrace2D)propertyChangeEvent.getSource();
                ITracePoint2D iTracePoint2D = this.m_previousHighlighted.get(iTrace2D);
                if (iTracePoint2D == null) return;
                if (propertyChangeEvent.getNewValue() != null && propertyChangeEvent.getOldValue() == null) {
                    if (this.m_previousHighlighted == null) return;
                    Chart2D chart2D = Chart2D.this;
                    synchronized (chart2D) {
                        ITrace2D iTrace2D2 = iTrace2D;
                        synchronized (iTrace2D2) {
                            iTracePoint2D.addAdditionalPointPainter((IPointPainter)propertyChangeEvent.getNewValue());
                            Chart2D.this.setRequestedRepaint(true);
                        }
                        return;
                    }
                }
                if (propertyChangeEvent.getNewValue() != null || propertyChangeEvent.getOldValue() == null) throw new RuntimeException("Programming error. Unneccessary event caught: " + propertyChangeEvent + ". You only have to fire this event, if a point highlighter was addded or removed.");
                if (this.m_previousHighlighted == null) return;
                Chart2D chart2D = Chart2D.this;
                synchronized (chart2D) {
                    ITrace2D iTrace2D3 = iTrace2D;
                    synchronized (iTrace2D3) {
                        iTracePoint2D.removeAdditionalPointPainter((IPointPainter)propertyChangeEvent.getOldValue());
                        Chart2D.this.setRequestedRepaint(true);
                    }
                    return;
                }
            }
            if (!Chart2D.PROPERTY_ADD_REMOVE_TRACE.equals(string)) throw new RuntimeException("Programming error: " + this.getClass().getName() + " only has to be registered to the event " + "ITrace2D.PROPERTY_POINT_HIGHLIGHTERS_CHANGED" + " on instances of type (or subtype) " + ITrace2D.class.getName());
            ITrace2D iTrace2D = (ITrace2D)propertyChangeEvent.getOldValue();
            if (propertyChangeEvent.getNewValue() != null) return;
            this.m_previousHighlighted.remove(iTrace2D);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ToolTipType implements IToolTipType
    {
        DATAVALUES{

            public String getDescription() {
                return "Value at cursor (rel. to 1st trace)";
            }

            public String getToolTipText(Chart2D chart2D, MouseEvent mouseEvent) {
                ITracePoint2D iTracePoint2D = chart2D.translateMousePosition(mouseEvent);
                StringBuffer stringBuffer = new StringBuffer("X: ");
                stringBuffer.append(chart2D.getAxisX().getFormatter().format(iTracePoint2D.getX())).append(" ");
                stringBuffer.append("Y: ");
                stringBuffer.append(chart2D.getAxisY().getFormatter().format(iTracePoint2D.getY()));
                String string = stringBuffer.toString();
                return string;
            }
        }
        ,
        NONE,
        PIXEL{

            public String getDescription() {
                return "Pixel, not implemented yet";
            }

            public String getToolTipText(Chart2D chart2D, MouseEvent mouseEvent) {
                return "pixel, not implemented yet";
            }
        }
        ,
        VALUE_SNAP_TO_TRACEPOINTS{

            public String getDescription() {
                return "Values, snap to nearest point";
            }

            public String getToolTipText(Chart2D chart2D, MouseEvent mouseEvent) {
                ITracePoint2D iTracePoint2D = chart2D.getPointFinder().getNearestPoint(mouseEvent, chart2D);
                ITrace2D iTrace2D = iTracePoint2D.getListener();
                IAxis<?> iAxis = chart2D.getAxisX(iTrace2D);
                IAxis<?> iAxis2 = chart2D.getAxisY(iTrace2D);
                chart2D.setRequestedRepaint(true);
                StringBuffer stringBuffer = new StringBuffer("X: ");
                stringBuffer.append(iAxis.getFormatter().format(iTracePoint2D.getX())).append(" ");
                stringBuffer.append("Y: ");
                stringBuffer.append(iAxis2.getFormatter().format(iTracePoint2D.getY()));
                String string = stringBuffer.toString();
                return string;
            }
        };


        @Override
        public String getDescription() {
            return "None";
        }

        @Override
        public String getToolTipText(Chart2D chart2D, MouseEvent mouseEvent) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PointFinder implements IPointFinder
    {
        EUCLID{

            public ITracePoint2D getNearestPoint(int n, int n2, Chart2D chart2D) {
                return chart2D.getNearestPointEuclid(n, n2);
            }
        }
        ,
        MANHATTAN{

            public ITracePoint2D getNearestPoint(int n, int n2, Chart2D chart2D) {
                return chart2D.getNearestPointManhattan(n, n2);
            }
        };


        @Override
        public ITracePoint2D getNearestPoint(MouseEvent mouseEvent, Chart2D chart2D) {
            return this.getNearestPoint(mouseEvent.getX(), mouseEvent.getY(), chart2D);
        }
    }
}

