/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Member;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.visitor.MemberVisitor;
import proguard.obfuscate.MemberObfuscator;

public class MemberNameFilter
implements MemberVisitor {
    private final MemberVisitor memberVisitor;

    public MemberNameFilter(MemberVisitor memberVisitor) {
        this.memberVisitor = memberVisitor;
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        if (MemberNameFilter.hasName(programField)) {
            this.memberVisitor.visitProgramField(programClass, programField);
        }
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        if (MemberNameFilter.hasName(programMethod)) {
            this.memberVisitor.visitProgramMethod(programClass, programMethod);
        }
    }

    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        if (MemberNameFilter.hasName(libraryField)) {
            this.memberVisitor.visitLibraryField(libraryClass, libraryField);
        }
    }

    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        if (MemberNameFilter.hasName(libraryMethod)) {
            this.memberVisitor.visitLibraryMethod(libraryClass, libraryMethod);
        }
    }

    private static boolean hasName(Member member) {
        return MemberObfuscator.newMemberName(member) != null;
    }
}

