/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.util.math;

public final class MathUtil {
    private static MathUtil instance = null;

    public static void assertDouble(double d) throws IllegalArgumentException {
        if (!MathUtil.isDouble(d)) {
            throw new IllegalArgumentException(d + " is not valid.");
        }
    }

    public static boolean assertEqual(double d1, double d2, double precisionRange) {
        return Math.abs(d1 - d2) < precisionRange;
    }

    public static boolean isDouble(double d) {
        return !Double.isInfinite(d) && !Double.isNaN(d);
    }

    private MathUtil() {
    }
}

