/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.rangepolicies;

import info.monitorenter.gui.chart.IRangePolicy;
import info.monitorenter.util.Range;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.event.SwingPropertyChangeSupport;

public abstract class ARangePolicy
implements IRangePolicy {
    protected PropertyChangeSupport m_propertyChangeSupport = new SwingPropertyChangeSupport(this);
    private Range m_range;

    public ARangePolicy() {
        this.m_range = Range.RANGE_UNBOUNDED;
    }

    public ARangePolicy(Range range) {
        this.m_range = range;
    }

    public final void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.m_propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ARangePolicy other = (ARangePolicy)obj;
        if (this.m_propertyChangeSupport == null ? other.m_propertyChangeSupport != null : !this.m_propertyChangeSupport.equals(other.m_propertyChangeSupport)) {
            return false;
        }
        return !(this.m_range == null ? other.m_range != null : !this.m_range.equals(other.m_range));
    }

    protected final void firePropertyChange(String property, Object oldvalue, Object newvalue) {
        this.m_propertyChangeSupport.firePropertyChange(property, oldvalue, newvalue);
    }

    public final Range getRange() {
        return this.m_range;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_propertyChangeSupport == null ? 0 : this.m_propertyChangeSupport.hashCode());
        result = 31 * result + (this.m_range == null ? 0 : this.m_range.hashCode());
        return result;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener, String property) {
        this.m_propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void setRange(Range range) {
        double oldMin = this.m_range.getMin();
        double oldMax = this.m_range.getMax();
        Range oldRange = this.m_range;
        boolean minchanged = range.getMin() != oldMin;
        boolean maxchanged = range.getMax() != oldMax;
        this.m_range = range;
        if (minchanged && maxchanged) {
            this.firePropertyChange("IRangePolicy.PROPERTY_RANGE", oldRange, this.m_range);
        } else if (minchanged) {
            this.firePropertyChange("IRangePolicy.PROPERTY_RANGE", new Double(oldMin), new Double(range.getMin()));
        } else if (maxchanged) {
            this.firePropertyChange("IRangePolicy.PROPERTY_RANGE", new Double(oldMax), new Double(range.getMax()));
        }
    }
}

