/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.pointpainters;

import info.monitorenter.gui.chart.ITracePoint2D;
import info.monitorenter.gui.chart.pointpainters.APointPainter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointPainterDisc
extends APointPainter<PointPainterDisc> {
    private int m_discSize;
    private int m_halfDiscSize;

    public PointPainterDisc() {
        this.setDiscSize(4);
    }

    public PointPainterDisc(int diameter) {
        this.setDiscSize(diameter);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PointPainterDisc other = (PointPainterDisc)obj;
        if (this.m_discSize != other.m_discSize) {
            return false;
        }
        return this.m_halfDiscSize == other.m_halfDiscSize;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.m_discSize;
        result = 31 * result + this.m_halfDiscSize;
        return result;
    }

    @Override
    public void paintPoint(int absoluteX, int absoluteY, int nextX, int nextY, Graphics g, ITracePoint2D original) {
        Stroke backupStroke = this.installStroke(g);
        Color backupColor = null;
        Color test = this.installColorFill(g);
        if (test != null) {
            backupColor = test;
            g.fillOval(absoluteX - this.m_halfDiscSize, absoluteY - this.m_halfDiscSize, this.m_discSize, this.m_discSize);
        }
        test = this.installColor(g);
        if (backupColor == null) {
            backupColor = test;
        } else if (test == null) {
            g.setColor(backupColor);
            backupColor = null;
        }
        g.drawOval(absoluteX - this.m_halfDiscSize, absoluteY - this.m_halfDiscSize, this.m_discSize, this.m_discSize);
        if (backupStroke != null) {
            ((Graphics2D)g).setStroke(backupStroke);
        }
        if (backupColor != null) {
            g.setColor(backupColor);
        }
    }

    public void setDiscSize(int discSize) {
        this.m_discSize = discSize;
        this.m_halfDiscSize = this.m_discSize / 2;
    }
}

