/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.labelformatters;

import info.monitorenter.gui.chart.IAxisLabelFormatter;
import info.monitorenter.gui.chart.labelformatters.ALabelFormatter;
import info.monitorenter.util.Range;
import info.monitorenter.util.SimpleDateFormatAnalyzer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LabelFormatterDate
extends ALabelFormatter
implements IAxisLabelFormatter {
    private int m_cachedMaxAmountChars = Integer.MAX_VALUE;
    private SimpleDateFormat m_dateFormat;
    private double m_lastFormatted = 0.0;

    public LabelFormatterDate() {
        this((SimpleDateFormat)DateFormat.getDateTimeInstance(3, 3));
    }

    public LabelFormatterDate(SimpleDateFormat dateFormat) {
        this.m_dateFormat = dateFormat;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LabelFormatterDate other = (LabelFormatterDate)obj;
        if (this.m_cachedMaxAmountChars != other.m_cachedMaxAmountChars) {
            return false;
        }
        if (this.m_dateFormat == null ? other.m_dateFormat != null : !this.m_dateFormat.equals(other.m_dateFormat)) {
            return false;
        }
        return Double.doubleToLongBits(this.m_lastFormatted) == Double.doubleToLongBits(other.m_lastFormatted);
    }

    public String format(double value) {
        this.m_lastFormatted = value;
        return this.m_dateFormat.format(new Date((long)value));
    }

    public int getMaxAmountChars() {
        Range range = this.getAxis().getRange();
        double dRange = range.getExtent();
        if (this.m_cachedMaxAmountChars == Integer.MAX_VALUE) {
            this.m_cachedMaxAmountChars = this.m_dateFormat.format(new Date((long)dRange)).length();
        }
        return this.m_cachedMaxAmountChars;
    }

    public double getMinimumValueShiftForChange() {
        double ret = 0.0;
        ret = SimpleDateFormatAnalyzer.displaysMillisecond(this.m_dateFormat) ? 1.0 : (SimpleDateFormatAnalyzer.displaysSecond(this.m_dateFormat) ? 1000.0 : (SimpleDateFormatAnalyzer.displaysMinute(this.m_dateFormat) ? 60000.0 : (SimpleDateFormatAnalyzer.displaysHour(this.m_dateFormat) ? 360000.0 : (SimpleDateFormatAnalyzer.displaysDay(this.m_dateFormat) ? 8640000.0 : (SimpleDateFormatAnalyzer.displaysMonth(this.m_dateFormat) ? 2.6784E8 : 5.3568E8)))));
        return ret;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.m_cachedMaxAmountChars;
        result = 31 * result + (this.m_dateFormat == null ? 0 : this.m_dateFormat.hashCode());
        long temp = Double.doubleToLongBits(this.m_lastFormatted);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public Number parse(String formatted) throws NumberFormatException {
        return new Double(this.m_lastFormatted);
    }
}

