/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.events;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.IAxis;
import info.monitorenter.gui.chart.IRangePolicy;
import info.monitorenter.gui.chart.events.AAxisAction;
import info.monitorenter.util.Range;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;

public class AxisActionSetRangePolicy
extends AAxisAction {
    private final transient IRangePolicy m_rangePolicy;

    public AxisActionSetRangePolicy(Chart2D chart, String description, int axis, IRangePolicy rangePolicy) {
        super(chart, description, axis);
        this.m_rangePolicy = rangePolicy;
        this.getAxis().addPropertyChangeListener("IAxis.PROPERTY_RANGEPOLICY", this);
    }

    public void actionPerformed(ActionEvent e) {
        IAxis axis = this.getAxis();
        Range actualRange = new Range(axis.getMinValue(), axis.getMaxValue());
        this.m_rangePolicy.setRange(actualRange);
        this.m_rangePolicy.setRange(actualRange);
        this.getAxis().setRangePolicy(this.m_rangePolicy);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        String property = evt.getPropertyName();
        if (property.equals("IAxis.PROPERTY_RANGEPOLICY")) {
            Boolean newValue;
            Boolean oldValue;
            Class<?> rangepolicyClass = evt.getNewValue().getClass();
            if (rangepolicyClass == this.m_rangePolicy.getClass()) {
                oldValue = new Boolean(false);
                newValue = new Boolean(true);
            } else {
                oldValue = new Boolean(true);
                newValue = new Boolean(false);
            }
            this.firePropertyChange("", oldValue, newValue);
        }
    }
}

