/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.errorbars;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.IErrorBarPainter;
import info.monitorenter.gui.chart.IErrorBarPixel;
import info.monitorenter.gui.chart.IPointPainter;
import info.monitorenter.gui.chart.IPointPainterConfigurableUI;
import info.monitorenter.gui.chart.ITracePoint2D;
import info.monitorenter.gui.chart.pointpainters.PointPainterDisc;
import info.monitorenter.gui.chart.pointpainters.PointPainterLine;
import java.awt.Color;
import java.awt.Graphics;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.event.SwingPropertyChangeSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorBarPainter
implements IErrorBarPainter {
    private IPointPainterConfigurableUI<?> m_connectionPainter;
    private IPointPainterConfigurableUI<?> m_endPointPainter;
    protected PropertyChangeSupport m_propertyChangeSupport = new SwingPropertyChangeSupport(this);
    private final IErrorBarPainter.ISegment m_segmentConnection = new ASegment(){

        @Override
        public Color getColor() {
            return ErrorBarPainter.this.getConnectionColor();
        }

        @Override
        public String getName() {
            return "Connection segment";
        }

        @Override
        public IPointPainterConfigurableUI<?> getPointPainter() {
            return ErrorBarPainter.this.getConnectionPainter();
        }

        @Override
        public final String getPropertySegmentColor() {
            return "IErrorBarPainter.PROPERTY_CONNECTION_COLOR";
        }

        @Override
        public void setColor(Color color) {
            ErrorBarPainter.this.setConnectionColor(color);
        }

        @Override
        public void setPointPainter(IPointPainterConfigurableUI<?> pointPainter) {
            ErrorBarPainter.this.setConnectionPainter(pointPainter);
        }
    };
    private final IErrorBarPainter.ISegment m_segmentEnd = new ASegment(){

        @Override
        public Color getColor() {
            return ErrorBarPainter.this.getEndPointColor();
        }

        @Override
        public String getName() {
            return "End segment";
        }

        @Override
        public IPointPainterConfigurableUI<?> getPointPainter() {
            return ErrorBarPainter.this.getEndPointPainter();
        }

        @Override
        public String getPropertySegmentColor() {
            return "IErrorBarPainter.PROPERTY_ENDPOINT_COLOR";
        }

        @Override
        public void setColor(Color color) {
            ErrorBarPainter.this.setEndPointColor(color);
        }

        @Override
        public void setPointPainter(IPointPainterConfigurableUI<?> pointPainter) {
            ErrorBarPainter.this.setEndPointPainter(pointPainter);
        }
    };
    private final IErrorBarPainter.ISegment m_segmentStart = new ASegment(){

        @Override
        public Color getColor() {
            return ErrorBarPainter.this.getStartPointColor();
        }

        @Override
        public String getName() {
            return "Start segment";
        }

        @Override
        public IPointPainterConfigurableUI<?> getPointPainter() {
            return ErrorBarPainter.this.getStartPointPainter();
        }

        @Override
        public String getPropertySegmentColor() {
            return "IErrorBarPainter.PROPERTY_STARTPOINT_COLOR";
        }

        @Override
        public void setColor(Color color) {
            ErrorBarPainter.this.setStartPointColor(color);
        }

        @Override
        public void setPointPainter(IPointPainterConfigurableUI<?> pointPainter) {
            ErrorBarPainter.this.setStartPointPainter(pointPainter);
        }
    };
    private IPointPainterConfigurableUI<?> m_startPointPainter = null;
    public static final Color DEFAULT_SEGMENT_COLOR = Color.GRAY;

    public ErrorBarPainter() {
        this.m_connectionPainter = new PointPainterLine();
        this.m_endPointPainter = new PointPainterDisc(4);
    }

    @Override
    public final void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.m_propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ErrorBarPainter other = (ErrorBarPainter)obj;
        if (this.m_connectionPainter == null ? other.m_connectionPainter != null : !this.m_connectionPainter.equals(other.m_connectionPainter)) {
            return false;
        }
        if (this.m_endPointPainter == null ? other.m_endPointPainter != null : !this.m_endPointPainter.equals(other.m_endPointPainter)) {
            return false;
        }
        if (this.m_propertyChangeSupport == null ? other.m_propertyChangeSupport != null : !this.m_propertyChangeSupport.equals(other.m_propertyChangeSupport)) {
            return false;
        }
        if (this.m_segmentConnection == null ? other.m_segmentConnection != null : !this.m_segmentConnection.equals(other.m_segmentConnection)) {
            return false;
        }
        if (this.m_segmentEnd == null ? other.m_segmentEnd != null : !this.m_segmentEnd.equals(other.m_segmentEnd)) {
            return false;
        }
        if (this.m_segmentStart == null ? other.m_segmentStart != null : !this.m_segmentStart.equals(other.m_segmentStart)) {
            return false;
        }
        return !(this.m_startPointPainter == null ? other.m_startPointPainter != null : !this.m_startPointPainter.equals(other.m_startPointPainter));
    }

    public final Color getConnectionColor() {
        Color result = this.getDefaultedColor(this.m_connectionPainter);
        return result;
    }

    public final IPointPainterConfigurableUI<?> getConnectionPainter() {
        return this.m_connectionPainter;
    }

    public final Color getEndPointColor() {
        Color result = this.getDefaultedColor(this.m_endPointPainter);
        return result;
    }

    public final IPointPainterConfigurableUI<?> getEndPointPainter() {
        return this.m_endPointPainter;
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String property) {
        return this.m_propertyChangeSupport.getPropertyChangeListeners(property);
    }

    @Override
    public IErrorBarPainter.ISegment getSegmentConnection() {
        return this.m_segmentConnection;
    }

    @Override
    public IErrorBarPainter.ISegment getSegmentEnd() {
        return this.m_segmentEnd;
    }

    @Override
    public IErrorBarPainter.ISegment getSegmentStart() {
        return this.m_segmentStart;
    }

    public final Color getStartPointColor() {
        Color result = this.getDefaultedColor(this.m_startPointPainter);
        return result;
    }

    private Color getDefaultedColor(IPointPainterConfigurableUI<?> painter) {
        Color result = null;
        if (painter != null) {
            result = painter.getColor();
        }
        if (result == null) {
            result = DEFAULT_SEGMENT_COLOR;
        }
        return result;
    }

    public final IPointPainterConfigurableUI<?> getStartPointPainter() {
        return this.m_startPointPainter;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_connectionPainter == null ? 0 : this.m_connectionPainter.hashCode());
        result = 31 * result + (this.m_endPointPainter == null ? 0 : this.m_endPointPainter.hashCode());
        result = 31 * result + (this.m_propertyChangeSupport == null ? 0 : this.m_propertyChangeSupport.hashCode());
        result = 31 * result + (this.m_segmentConnection == null ? 0 : this.m_segmentConnection.hashCode());
        result = 31 * result + (this.m_segmentEnd == null ? 0 : this.m_segmentEnd.hashCode());
        result = 31 * result + (this.m_segmentStart == null ? 0 : this.m_segmentStart.hashCode());
        result = 31 * result + (this.m_startPointPainter == null ? 0 : this.m_startPointPainter.hashCode());
        return result;
    }

    @Override
    public void paintErrorBar(int absoluteX, int absoluteY, ITracePoint2D original, Graphics g, IErrorBarPixel errorBar) {
        int x2;
        int y2;
        Chart2D chart = errorBar.getTrace().getRenderer();
        int xStart = chart.getXChartStart();
        int xEnd = chart.getXChartEnd();
        int yStart = chart.getYChartStart();
        int yEnd = chart.getYChartEnd();
        int x1 = absoluteX < xStart ? xStart : absoluteX;
        x1 = absoluteX > xEnd ? xEnd : absoluteX;
        int y1 = absoluteY > yStart ? yStart : absoluteY;
        y1 = absoluteY < yEnd ? yEnd : absoluteY;
        int error = errorBar.getNegativeXErrorPixel();
        if (error != Integer.MAX_VALUE) {
            y2 = y1;
            x2 = error < xStart ? xStart : error;
            this.paintErrorBarPart(x1, y1, x2, y2, original, this.m_connectionPainter, g);
            this.paintErrorBarPart(x1, y1, x2, y2, original, this.m_startPointPainter, g);
            if (x2 == error) {
                this.paintErrorBarPart(x2, y1, x1, y1, original, this.m_endPointPainter, g);
            }
        }
        if ((error = errorBar.getPositiveXErrorPixel()) != Integer.MAX_VALUE) {
            y2 = y1;
            x2 = error > xEnd ? xEnd : error;
            this.paintErrorBarPart(x1, y1, x2, y2, original, this.m_connectionPainter, g);
            this.paintErrorBarPart(x1, y1, x2, y2, original, this.m_startPointPainter, g);
            if (x2 == error) {
                this.paintErrorBarPart(x2, y1, x1, y1, original, this.m_endPointPainter, g);
            }
        }
        if ((error = errorBar.getNegativeYErrorPixel()) != Integer.MAX_VALUE) {
            x2 = x1;
            y2 = error > yStart ? yStart : error;
            this.paintErrorBarPart(x1, y1, x2, y2, original, this.m_connectionPainter, g);
            this.paintErrorBarPart(x1, y1, x2, y2, original, this.m_startPointPainter, g);
            if (y2 == error) {
                this.paintErrorBarPart(x1, y2, x1, y1, original, this.m_endPointPainter, g);
            }
        }
        if ((error = errorBar.getPositiveYErrorPixel()) != Integer.MAX_VALUE) {
            x2 = x1;
            y2 = error < yEnd ? yEnd : error;
            this.paintErrorBarPart(x1, y1, x2, y2, original, this.m_connectionPainter, g);
            this.paintErrorBarPart(x1, y1, x2, y2, original, this.m_startPointPainter, g);
            if (y2 == error) {
                this.paintErrorBarPart(x1, y2, x1, y1, original, this.m_endPointPainter, g);
            }
        }
    }

    private final void paintErrorBarPart(int absoluteX, int absoluteY, int nextX, int nextY, ITracePoint2D original, IPointPainter<?> pointPainter, Graphics g2d) {
        if (pointPainter != null) {
            pointPainter.paintPoint(absoluteX, absoluteY, nextX, nextY, g2d, original);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        this.m_propertyChangeSupport.removePropertyChangeListener(property, listener);
    }

    public final void setConnectionColor(Color connectionColor) {
        if (this.m_connectionPainter != null) {
            Color old = this.m_connectionPainter.getColor();
            this.m_connectionPainter.setColor(connectionColor);
            this.m_propertyChangeSupport.firePropertyChange("IErrorBarPainter.PROPERTY_CONNECTION_COLOR", old, connectionColor);
        }
    }

    public final void setConnectionPainter(IPointPainterConfigurableUI<?> connectionPainter) {
        Color oldColor;
        IPointPainterConfigurableUI<?> old = this.m_connectionPainter;
        if (this.m_connectionPainter != null && (oldColor = this.m_connectionPainter.getColor()) != null && connectionPainter != null) {
            connectionPainter.setColor(oldColor);
        }
        this.m_connectionPainter = connectionPainter;
        this.m_propertyChangeSupport.firePropertyChange("IErrorBarPainter.PROPERTY_CONNECTION", old, connectionPainter);
    }

    public final void setEndPointColor(Color endPointColor) {
        if (this.m_endPointPainter != null) {
            Color old = this.m_endPointPainter.getColor();
            this.m_endPointPainter.setColor(endPointColor);
            this.m_propertyChangeSupport.firePropertyChange("IErrorBarPainter.PROPERTY_ENDPOINT_COLOR", old, endPointColor);
        }
    }

    public final void setEndPointPainter(IPointPainterConfigurableUI<?> endPointPainter) {
        Color oldColor;
        IPointPainterConfigurableUI<?> old = this.m_endPointPainter;
        if (this.m_endPointPainter != null && (oldColor = this.m_endPointPainter.getColor()) != null && endPointPainter != null) {
            endPointPainter.setColor(oldColor);
        }
        this.m_endPointPainter = endPointPainter;
        this.m_propertyChangeSupport.firePropertyChange("IErrorBarPainter.PROPERTY_ENDPOINT", old, endPointPainter);
    }

    public final void setStartPointColor(Color startPointColor) {
        if (this.m_startPointPainter != null) {
            Color old = this.m_startPointPainter.getColor();
            this.m_startPointPainter.setColor(startPointColor);
            this.m_propertyChangeSupport.firePropertyChange("IErrorBarPainter.PROPERTY_STARTPOINT_COLOR", old, startPointColor);
        }
    }

    public final void setStartPointPainter(IPointPainterConfigurableUI<?> startPointPainter) {
        Color oldColor;
        IPointPainterConfigurableUI<?> old = this.m_startPointPainter;
        if (this.m_startPointPainter != null && (oldColor = this.m_startPointPainter.getColor()) != null && startPointPainter != null) {
            startPointPainter.setColor(oldColor);
        }
        this.m_startPointPainter = startPointPainter;
        this.m_propertyChangeSupport.firePropertyChange("IErrorBarPainter.PROPERTY_STARTPOINT", old, this.m_startPointPainter);
    }

    private abstract class ASegment
    implements IErrorBarPainter.ISegment {
        protected ASegment() {
        }

        public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
            ErrorBarPainter.this.addPropertyChangeListener(property, listener);
        }
    }
}

