/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.ICodeBlock;
import info.monitorenter.gui.chart.IPointPainter;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.ITracePoint2D;
import java.awt.geom.Point2D;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TracePoint2D
extends Point2D.Double
implements ITracePoint2D {
    private Set<IPointPainter<?>> m_additionalPointPainters = new LinkedHashSet();
    private ITrace2D m_listener;
    private double m_scaledX;
    private double m_scaledY;
    private double m_x;
    private double m_y;

    protected TracePoint2D() {
    }

    public TracePoint2D(double xValue, double yValue) {
        this.m_x = xValue;
        this.m_y = yValue;
    }

    @Override
    public final boolean addAdditionalPointPainter(final IPointPainter<?> additionalPointPainter) {
        Boolean result = this.doSynchronized(new ICodeBlock<Boolean>(){

            @Override
            public Boolean execute() {
                boolean res = TracePoint2D.this.m_additionalPointPainters.add(additionalPointPainter);
                if (res && TracePoint2D.this.m_listener != null) {
                    TracePoint2D.this.m_listener.firePointChanged(TracePoint2D.this, 4);
                }
                return res;
            }
        });
        return result;
    }

    @Override
    public Object clone() {
        TracePoint2D result = (TracePoint2D)super.clone();
        result.m_x = this.m_x;
        result.m_y = this.m_y;
        result.m_scaledX = this.m_scaledX;
        result.m_scaledY = this.m_scaledY;
        result.m_additionalPointPainters = new LinkedHashSet(this.m_additionalPointPainters);
        return result;
    }

    @Override
    public int compareTo(ITracePoint2D obj) {
        double othx = obj.getX();
        int result = this.m_x < othx ? -1 : (this.m_x == othx ? 0 : 1);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TracePoint2D other = (TracePoint2D)obj;
        if (Double.doubleToLongBits(this.m_x) != Double.doubleToLongBits(other.m_x)) {
            return false;
        }
        return Double.doubleToLongBits(this.m_y) == Double.doubleToLongBits(other.m_y);
    }

    @Override
    public final Set<IPointPainter<?>> getAdditionalPointPainters() {
        return this.m_additionalPointPainters;
    }

    @Override
    public double getEuclidDistance(double xNormalized, double yNormalized) {
        double xdist = Math.abs(this.m_scaledX - xNormalized);
        double ydist = Math.abs(this.m_scaledY - yNormalized);
        double result = Math.sqrt(Math.pow(xdist, 2.0) + Math.pow(ydist, 2.0));
        return result;
    }

    @Override
    public ITrace2D getListener() {
        return this.m_listener;
    }

    @Override
    public double getManhattanDistance(double xNormalized, double yNormalized) {
        double result = Math.abs(this.m_scaledX - xNormalized) + Math.abs(this.m_scaledY - yNormalized);
        return result;
    }

    @Override
    public final double getScaledX() {
        return this.m_scaledX;
    }

    @Override
    public final double getScaledY() {
        return this.m_scaledY;
    }

    @Override
    public double getX() {
        return this.m_x;
    }

    @Override
    public double getY() {
        return this.m_y;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.m_x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m_y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public void setListener(ITrace2D listener) {
        this.m_listener = listener;
    }

    @Override
    public void setLocation(final double xValue, final double yValue) {
        this.doSynchronized(new ICodeBlock<Object>(){

            @Override
            public Object execute() {
                TracePoint2D.this.m_x = xValue;
                TracePoint2D.this.m_y = yValue;
                if (TracePoint2D.this.m_listener != null) {
                    TracePoint2D.this.m_listener.firePointChanged(TracePoint2D.this, 4);
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T doSynchronized(ICodeBlock<T> runSynchronized) {
        T result;
        if (this.m_listener != null) {
            Chart2D chart = this.m_listener.getRenderer();
            if (chart != null) {
                Chart2D chart2D = chart;
                synchronized (chart2D) {
                    ITrace2D iTrace2D = this.m_listener;
                    synchronized (iTrace2D) {
                        result = runSynchronized.execute();
                    }
                }
            }
            ITrace2D iTrace2D = this.m_listener;
            synchronized (iTrace2D) {
                result = runSynchronized.execute();
            }
        }
        result = runSynchronized.execute();
        return result;
    }

    @Override
    public final void setScaledX(double scaledX) {
        this.m_scaledX = scaledX;
    }

    @Override
    public final void setScaledY(double scaledY) {
        this.m_scaledY = scaledY;
    }

    @Override
    public String toString() {
        return "TracePoint2D[" + this.m_x + ", " + this.m_y + "]";
    }

    @Override
    public boolean removeAdditionalPointPainter(final IPointPainter<?> pointPainter) {
        Boolean result = this.doSynchronized(new ICodeBlock<Boolean>(){

            @Override
            public Boolean execute() {
                boolean res = TracePoint2D.this.m_additionalPointPainters.remove(pointPainter);
                if (res && TracePoint2D.this != null) {
                    TracePoint2D.this.m_listener.firePointChanged(TracePoint2D.this, 4);
                }
                return res;
            }
        });
        return result;
    }
}

