/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart;

import info.monitorenter.gui.chart.IAxisLabelFormatter;
import info.monitorenter.gui.chart.IAxisTitlePainter;
import info.monitorenter.gui.chart.IRangePolicy;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.axis.AAxis;
import info.monitorenter.gui.chart.axistitlepainters.AxisTitlePainterDefault;
import info.monitorenter.util.Range;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IAxis
extends Serializable {
    public void addPropertyChangeListener(String var1, PropertyChangeListener var2);

    public boolean addTrace(ITrace2D var1);

    public AAxis.AChart2DDataAccessor getAccessor();

    public int getAxisPosition();

    public AxisTitle getAxisTitle();

    public AxisTitle removeAxisTitle();

    public int getDimension();

    public IAxisLabelFormatter getFormatter();

    public int getHeight(Graphics var1);

    public double getMax();

    public double getMaxValue();

    public double getMin();

    public double getMinValue();

    public int getPixelXLeft();

    public int getPixelYBottom();

    public int getPixelYTop();

    public Range getRange();

    public IRangePolicy getRangePolicy();

    public double getScaledValue(double var1);

    public Set<ITrace2D> getTraces();

    public int getWidth(Graphics var1);

    public boolean hasTrace(ITrace2D var1);

    public void initPaintIteration();

    public boolean isDirtyScaling();

    public boolean isPaintGrid();

    public boolean isPaintScale();

    public boolean isStartMajorTick();

    public boolean isVisible();

    public void paint(Graphics var1);

    public Set<ITrace2D> removeAllTraces();

    public void removePropertyChangeListener(String var1, PropertyChangeListener var2);

    public boolean removeTrace(ITrace2D var1);

    public void scale();

    public void setFormatter(IAxisLabelFormatter var1);

    public void setPaintGrid(boolean var1);

    public void setPixelXLeft(int var1);

    public void setPixelXRight(int var1);

    public void setPixelYBottom(int var1);

    public void setPixelYTop(int var1);

    public void setRange(Range var1);

    public void setRangePolicy(IRangePolicy var1);

    public double translatePxToValue(int var1);

    public int translateValueToPx(double var1);

    public static final class AxisTitle
    implements Serializable,
    Cloneable {
        private PropertyChangeSupport m_propertyChangeSupport = new PropertyChangeSupport(this);
        private String m_title;
        private Color m_titleColor = Color.BLACK;
        private Font m_titleFont;
        private IAxisTitlePainter m_titlePainter;

        public AxisTitle(String title) {
            this(title, new AxisTitlePainterDefault());
        }

        public AxisTitle(String title, IAxisTitlePainter painter) {
            this.m_title = title;
            this.m_titlePainter = painter;
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.m_propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
        }

        protected Object clone() throws CloneNotSupportedException {
            Object result = super.clone();
            return result;
        }

        public final String getTitle() {
            return this.m_title;
        }

        public Color getTitleColor() {
            return this.m_titleColor;
        }

        public Font getTitleFont() {
            return this.m_titleFont;
        }

        public final IAxisTitlePainter getTitlePainter() {
            return this.m_titlePainter;
        }

        public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
            this.m_propertyChangeSupport.removePropertyChangeListener(property, listener);
        }

        public final String setTitle(String title) {
            String old = this.m_title;
            this.m_title = title;
            this.m_propertyChangeSupport.firePropertyChange("IAxis.AxisTitle.PROPERTY_TITLE", old, this.m_title);
            return old;
        }

        public void setTitleFont(Font font) {
            Font old = this.m_titleFont;
            this.m_titleFont = font;
            this.m_propertyChangeSupport.firePropertyChange("IAxis.AxisTitle.PROPERTY_TITLEFONT", old, this.m_titleFont);
        }
    }
}

