/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.axis;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.IAxisLabelFormatter;
import info.monitorenter.gui.chart.axis.AAxis;
import info.monitorenter.util.Range;
import info.monitorenter.util.math.MathUtil;

public class AxisLinear
extends AAxis {
    public AxisLinear() {
    }

    public AxisLinear(IAxisLabelFormatter formatter) {
        super(formatter);
    }

    protected AAxis.AChart2DDataAccessor createAccessor(Chart2D chart, int dimension, int position) {
        AAxis.AChart2DDataAccessor result;
        if (dimension == 1) {
            if ((position & 0x30) == 0) {
                throw new IllegalArgumentException("X axis only valid with top or bottom position.");
            }
            this.setAxisPosition(position);
            result = new AAxis.XDataAccessor(chart);
        } else if (dimension == 2) {
            if ((position & 0xC) == 0) {
                throw new IllegalArgumentException("Y axis only valid with left or right position.");
            }
            this.setAxisPosition(position);
            result = new AAxis.YDataAccessor(chart);
        } else {
            throw new IllegalArgumentException("Dimension has to be Chart2D.X or Chart2D.Y!");
        }
        return result;
    }

    public double getScaledValue(double absolute) {
        Range range = this.getRange();
        double scalerX = range.getExtent();
        double result = (absolute - range.getMin()) / scalerX;
        if (!MathUtil.isDouble(result)) {
            result = 0.0;
        }
        return result;
    }
}

