/*
 * Decompiled with CFR 0.152.
 */
package com.mentorgen.tools.profile.runtime;

import com.mentorgen.tools.profile.Controller;
import com.mentorgen.tools.profile.runtime.Method;
import com.mentorgen.tools.profile.runtime.Metrics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Frame {
    private Method _method;
    private Frame _parent;
    private long _netTime = 0L;
    private long _threadId;
    private Map<Method, Frame> _children = new HashMap<Method, Frame>();
    private ArrayList<Frame> _childList = new ArrayList();
    public Metrics _metrics = new Metrics();
    private long _lastStartTime = 0L;
    private long _lastWaitStartTime = 0L;
    private long _waitTime = 0L;

    private Frame() {
    }

    Frame(Frame frame, Method method, long l) {
        assert (method != null);
        this._parent = frame;
        this._method = method;
        this._threadId = l;
        if (frame != null) {
            frame.addChild(method, this);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toStringBuffer(stringBuffer, 0);
        return stringBuffer.toString();
    }

    public long getThreadId() {
        return this._threadId;
    }

    public String getName() {
        return this._method.toString();
    }

    public String getInvertedName() {
        return this._method.toInvertedString();
    }

    public String getClassName() {
        return this._method.getClassName();
    }

    public String getMethodName() {
        return this._method.getMethodName();
    }

    public Iterable<Frame> childIterator() {
        return this._childList;
    }

    public boolean hasChildren() {
        return this._childList.size() > 0;
    }

    public Frame getParent() {
        return this._parent;
    }

    public long netTime() {
        return this._netTime;
    }

    void computeNetTime() {
        long l = 0L;
        for (Frame frame : this._childList) {
            l += frame._metrics.getTotalTime();
        }
        this._netTime = this._metrics.getTotalTime() - l - this._waitTime;
        if (this._netTime < 0L) {
            this._netTime = 0L;
        }
    }

    void setBeginTime(long l) {
        this._lastStartTime = l;
    }

    void setEndTime(long l) {
        if (0L < l - this._lastStartTime) {
            this._metrics.inc(l - this._lastStartTime);
        } else {
            this._metrics.inc(0L);
        }
        this._lastStartTime = 0L;
    }

    void beginWait(long l) {
        this._lastWaitStartTime = l;
    }

    void endWait(long l) {
        if (0L < l - this._lastWaitStartTime) {
            this._waitTime += l - this._lastWaitStartTime;
        }
        this._lastWaitStartTime = 0L;
    }

    Frame getChild(Method method) {
        return this._children.get(method);
    }

    void overhead(long l) {
        this._metrics.adjust(l);
    }

    void close() {
        if (this._lastStartTime > 0L) {
            this.setEndTime(System.nanoTime());
            if (Controller._debug) {
                System.err.print("Fixup: ");
                System.err.println(this._method);
            }
        }
        for (Frame frame : this._childList) {
            frame.close();
        }
    }

    private void addChild(Method method, Frame frame) {
        this._children.put(method, frame);
        this._childList.add(frame);
    }

    private void toStringBuffer(StringBuffer stringBuffer, int n) {
        if (n > 5) {
            return;
        }
        stringBuffer.append(" ");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("| ");
        }
        stringBuffer.append("+--");
        stringBuffer.append(this.getInvertedName());
        stringBuffer.append(System.getProperty("line.separator"));
        if (Controller._threadDepth != -1 && n == Controller._threadDepth - 1) {
            return;
        }
        for (Frame frame : this._childList) {
            if (Controller._compactThreadDepth && frame._metrics.getTotalTime() < (long)(Controller._compactThreadThreshold * 1000000)) continue;
            frame.toStringBuffer(stringBuffer, n + 1);
        }
    }
}

