/*
 * Decompiled with CFR 0.152.
 */
package com.tivo.jipviewer;

import com.tivo.jipviewer.JipFrame;
import com.tivo.jipviewer.JipMethod;

class MethodRow {
    private JipMethod mMethod;
    int mCount = 0;
    double mTimeDenominator = 1.0;
    long mTotalTime = 0L;
    long mNetTime = 0L;

    MethodRow(JipMethod jipMethod) {
        this.mMethod = jipMethod;
    }

    JipMethod getMethod() {
        return this.mMethod;
    }

    void setTimeDenominator(double d) {
        if (d == 0.0) {
            throw new RuntimeException("don't divide by zero!");
        }
        this.mTimeDenominator = d;
    }

    double getPercentTotal() {
        double d = this.toPercent((double)this.mTotalTime / this.mTimeDenominator);
        return d;
    }

    double getPercentNet() {
        return this.toPercent((double)this.mNetTime / this.mTimeDenominator);
    }

    long getCount() {
        return this.mCount;
    }

    long getTotalTime() {
        return this.mTotalTime;
    }

    long getNetTime() {
        return this.mNetTime;
    }

    void addFrame(JipFrame jipFrame) {
        this.mCount = (int)((long)this.mCount + jipFrame.getCount());
        this.mTotalTime += jipFrame.getTotalTime();
        this.mNetTime += jipFrame.getNetTime();
    }

    double toPercent(double d) {
        return Math.floor(10000.0 * d) / 100.0;
    }
}

